/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StreamInterceptor;

public class ResponseInputStream
extends InputStream {
    protected StreamInterceptor interceptor = null;
    protected boolean closed = false;
    protected boolean chunk = false;
    protected boolean endChunk = false;
    protected byte[] buffer = null;
    protected int length = 0;
    protected int pos = 0;
    protected int count = 0;
    protected int contentLength = -1;
    protected InputStream stream = null;
    protected HttpMethod method = null;

    public ResponseInputStream(InputStream stream, HttpMethod method, Hashtable responseHeaders) {
        Header contentLength;
        Header transferEncoding = (Header)responseHeaders.get("transfer-encoding");
        if (transferEncoding != null && transferEncoding.getValue().indexOf("chunked") != -1) {
            this.chunk = true;
        }
        if ((contentLength = (Header)responseHeaders.get("content-length")) != null) {
            try {
                this.contentLength = Integer.parseInt(contentLength.getValue());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.stream = stream;
        this.method = method;
    }

    public void setInterceptor(StreamInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void close() throws IOException {
        if (!this.closed) {
            if (this.chunk) {
                while (!this.endChunk) {
                    int b = this.read();
                    if (b >= 0) {
                        continue;
                    }
                    break;
                }
            } else if (this.length > 0) {
                while (this.count < this.length) {
                    int b = this.read();
                    if (b >= 0) {
                        continue;
                    }
                    break;
                }
            }
            this.closed = true;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int avail = this.length - this.pos;
        if (avail == 0 && !this.fillBuffer()) {
            return -1;
        }
        avail = this.length - this.pos;
        if (avail == 0) {
            return -1;
        }
        int toCopy = avail;
        if (toCopy < 0) {
            return -1;
        }
        if (avail > len) {
            toCopy = len;
        }
        System.arraycopy(this.buffer, this.pos, b, off, toCopy);
        this.pos += toCopy;
        return toCopy;
    }

    public int read() throws IOException {
        if (this.pos == this.length && !this.fillBuffer()) {
            return -1;
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    private boolean fillBuffer() throws IOException {
        if (this.closed) {
            return false;
        }
        if (this.endChunk) {
            return false;
        }
        if (this.contentLength >= 0 && this.count >= this.contentLength) {
            return false;
        }
        if (!this.method.hasResponseBody()) {
            return false;
        }
        this.pos = 0;
        if (this.chunk) {
            try {
                String numberValue = this.readLineFromStream();
                if (numberValue == null) {
                    throw new NumberFormatException();
                }
                this.length = Integer.parseInt(numberValue.trim(), 16);
            }
            catch (NumberFormatException e) {
                this.length = -1;
                this.chunk = false;
                this.endChunk = true;
                this.closed = true;
                return false;
            }
            if (this.length == 0) {
                String trailingLine = this.readLineFromStream();
                while (!trailingLine.equals("")) {
                    trailingLine = this.readLineFromStream();
                }
                this.endChunk = true;
                return false;
            }
            if (this.buffer == null || this.length > this.buffer.length) {
                this.buffer = new byte[this.length];
            }
            int nbRead = 0;
            int currentRead = 0;
            while (nbRead < this.length) {
                try {
                    currentRead = this.stream.read(this.buffer, nbRead, this.length - nbRead);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new IOException();
                }
                if (currentRead < 0) {
                    throw new IOException("Not enough bytes read");
                }
                nbRead += currentRead;
            }
            String string = this.readLineFromStream();
        } else {
            try {
                if (this.buffer == null) {
                    this.buffer = new byte[4096];
                }
                this.length = this.stream.read(this.buffer);
                this.count += this.length;
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new IOException();
            }
        }
        if (this.interceptor != null) {
            this.interceptor.bytesRead(this.buffer, 0, this.length);
        }
        return true;
    }

    private String readLineFromStream() throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int ch;
            if ((ch = this.stream.read()) < 0) {
                if (sb.length() != 0) break;
                return null;
            }
            if (ch == 13) continue;
            if (ch == 10) break;
            sb.append((char)ch);
        }
        return sb.toString();
    }
}

