/*
 * Decompiled with CFR 0.152.
 */
package talon;

import java.io.PrintStream;
import java.util.Enumeration;
import talon.BaseComponent;
import talon.ComponentFactory;
import talon.ComponentHandle;
import talon.NotFoundException;
import talon.TalonException;
import talon.components.Logger;
import talon.components.PropertyManager;
import talon.implementations.SimplePropertyManager;

public class HandleManager
extends BaseComponent {
    private static SimplePropertyManager byName = new SimplePropertyManager();
    private static SimplePropertyManager byInterface = new SimplePropertyManager();
    private static SimplePropertyManager byImplementation = new SimplePropertyManager();

    public void init() throws TalonException {
    }

    public static void registerComponentHandle(ComponentHandle handle) throws TalonException {
        Logger logger = ComponentFactory.getLogger();
        logger.debug("registering handle:" + handle.toString());
        if (handle.getName() != null) {
            logger.debug("registering handle (byName):" + handle.toString());
            HandleManager.registerComponentHandle(byName, handle.getName(), handle);
        }
        if (handle.getInterface() != null) {
            logger.debug("registering handle (byInterface):" + handle.toString());
            HandleManager.registerComponentHandle(byInterface, handle.getInterface(), handle);
        }
        if (handle.getImplementation() != null) {
            logger.debug("registering handle (byImplementation):" + handle.toString());
            HandleManager.registerComponentHandle(byImplementation, handle.getImplementation(), handle);
        }
    }

    private static void registerComponentHandle(SimplePropertyManager manager, String key, ComponentHandle handle) throws TalonException {
        if (manager.contains(key)) {
            throw new TalonException("HandleManager already contains this component: " + handle.toString());
        }
        manager.setProperty(key, handle);
    }

    public static ComponentHandle byName(String _name) throws TalonException {
        ComponentHandle handle = (ComponentHandle)byName.getProperty(_name);
        if (handle == null) {
            throw new NotFoundException("ComponentHandle not found: " + _name);
        }
        return handle;
    }

    public static ComponentHandle byInterface(String _interface) throws TalonException {
        return (ComponentHandle)byInterface.getProperty(_interface);
    }

    public static ComponentHandle byImplementation(String _implementation) throws TalonException {
        ComponentHandle handle = (ComponentHandle)byImplementation.getProperty(_implementation);
        if (handle == null) {
            throw new NotFoundException("ComponentHandle not found: " + _implementation);
        }
        return handle;
    }

    public static ComponentHandle byImplementation(Class _implementation) throws TalonException {
        return HandleManager.byImplementation(_implementation.getName());
    }

    static PropertyManager getNameRegistry() {
        return byName;
    }

    static PropertyManager getInterfaceRegistry() {
        return byInterface;
    }

    static PropertyManager getImplementationRegistry() {
        return byImplementation;
    }

    public static void dump() {
        HandleManager.dump(System.out);
    }

    public static void dump(PrintStream ps) {
        ps.println(" --- BEGIN Dumping HandleManager --- ");
        HandleManager.dump(ps, byName, "\n\n\n\tBY NAME\n\n\n");
        HandleManager.dump(ps, byInterface, "\n\n\n\tBY INTERFACE\n\n\n");
        HandleManager.dump(ps, byImplementation, "\n\n\n\tBY IMPLEMENTATION\n\n\n");
        ps.println(" --- END Dumping HandleManager --- ");
    }

    private static void dump(PrintStream ps, SimplePropertyManager spm, String name) {
        ps.println(name);
        Enumeration keys = spm.getKeys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = spm.getProperty(key.toString());
            ps.print("\t\t");
            ps.println(key.toString());
            ps.print("\t\t");
            ps.println(value.toString());
            ps.println();
            ((ComponentHandle)value).getInitProperties().dump(ps);
        }
    }
}

