/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.ServletWriter;

abstract class TagGeneratorBase
extends GeneratorBase {
    private Stack tagHandlerStack;
    private Hashtable tagVarNumbers;

    TagGeneratorBase() {
    }

    protected void declareVariables(ServletWriter writer, VariableInfo[] vi, TagVariableInfo[] tvi, TagData tagData, boolean declare, boolean update, int scope) {
        block9: {
            block8: {
                if (vi == null) break block8;
                int i = 0;
                while (i < vi.length) {
                    if (vi[i].getScope() == scope) {
                        if (vi[i].getDeclare() && declare) {
                            writer.println(String.valueOf(vi[i].getClassName()) + " " + vi[i].getVarName() + " = null;");
                        }
                        if (update) {
                            writer.println(String.valueOf(vi[i].getVarName()) + " = (" + vi[i].getClassName() + ") pageContext.findAttribute(" + writer.quoteString(vi[i].getVarName()) + ");");
                        }
                    }
                    ++i;
                }
                break block9;
            }
            if (tvi == null) break block9;
            int i = 0;
            while (i < tvi.length) {
                String name = tvi[i].getNameGiven() != null ? tvi[i].getNameGiven() : tagData.getAttributeString(tvi[i].getNameFromAttribute());
                if (tvi[i].getScope() == scope) {
                    if (tvi[i].getDeclare() && declare) {
                        writer.println(String.valueOf(tvi[i].getClassName()) + " " + name + " = null;");
                    }
                    if (update) {
                        writer.println(String.valueOf(name) + " = (" + tvi[i].getClassName() + ") pageContext.findAttribute(" + writer.quoteString(name) + ");");
                    }
                }
                ++i;
            }
        }
    }

    protected String getTagVarName(String prefix, String shortTagName) {
        if (shortTagName.indexOf(45) >= 0) {
            shortTagName = this.substitute(shortTagName, '-', "$1");
        }
        if (shortTagName.indexOf(46) >= 0) {
            shortTagName = this.substitute(shortTagName, '.', "$2");
        }
        if (shortTagName.indexOf(58) >= 0) {
            shortTagName = this.substitute(shortTagName, ':', "$3");
        }
        Hashtable hashtable = this.tagVarNumbers;
        synchronized (hashtable) {
            String tag = String.valueOf(prefix) + ":" + shortTagName;
            String varName = String.valueOf(prefix) + "_" + shortTagName + "_";
            if (this.tagVarNumbers.get(tag) != null) {
                Integer i = (Integer)this.tagVarNumbers.get(tag);
                varName = String.valueOf(varName) + i;
                this.tagVarNumbers.put(tag, new Integer(i + 1));
                String string = varName;
                Object var5_9 = null;
                return string;
            }
            this.tagVarNumbers.put(tag, new Integer(1));
            String string = String.valueOf(varName) + "0";
            Object var5_10 = null;
            return string;
        }
    }

    protected void setTagHandlerStack(Stack tagHandlerStack) {
        this.tagHandlerStack = tagHandlerStack;
    }

    protected void setTagVarNumbers(Hashtable tagVarNumbers) {
        this.tagVarNumbers = tagVarNumbers;
    }

    private String substitute(String name, char from, String to) {
        StringBuffer s = new StringBuffer();
        int begin = 0;
        int last = name.length();
        while (true) {
            int end;
            if ((end = name.indexOf(from, begin)) < 0) {
                end = last;
            }
            s.append(name.substring(begin, end));
            if (end == last) break;
            s.append(to);
            begin = end + 1;
        }
        return s.toString();
    }

    protected void tagBegin(TagVariableData tvd) {
        this.tagHandlerStack.push(tvd);
    }

    protected TagVariableData tagEnd() {
        return (TagVariableData)this.tagHandlerStack.pop();
    }

    protected TagVariableData topTag() {
        if (this.tagHandlerStack.empty()) {
            return null;
        }
        return (TagVariableData)this.tagHandlerStack.peek();
    }

    class TagVariableData {
        String tagHandlerInstanceName;
        String tagEvalVarName;

        TagVariableData(String tagHandlerInstanceName, String tagEvalVarName) {
            this.tagHandlerInstanceName = tagHandlerInstanceName;
            this.tagEvalVarName = tagEvalVarName;
        }
    }
}

