<?xml version="1.0"?> 

<!--

$Id: mozilla-view-import.xsl,v 1.7 2002/02/24 23:47:38 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:view-import="http://schemas.openprivacy.org/reptile/view-import"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                version="1.0">

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <xsl:param name="reptile.home.location" select="''"/>

    <xsl:template match="/view-import:view-import">

        <control:content>
    
            <dc:title>Manually view or import a channel</dc:title>
            
            <control:body>
                
                <img src="/reptile/images/view-import.png"
                     align="right"
                     hspace="10"
                     vspace="10"/>

                <p>
                    If you have a URL for content you can subscribe to it here.
                </p>
    
                <div align="center">
    
                    <form action="{$reptile.home.location}" method="post ">
    
                        <table>

                            <tr>
                                <td>
                            
                                    <b>URL/Location: </b>

                                </td>

                                <td>
                                
                                    <input type="text" name="reptile.channel-management.location"/>

                                </td>
                
                            </tr>

                            <tr>

                                <td>
                                
                                    <b>Content Type (URI): </b>

                                </td>

                                <td>
                                
                                    <select name="reptile.channel-management.contentType">
                                        
                                        <option value="http://my.netscape.com/rdf/simple/0.9/">RSS 0.90</option>
                                        <option value="http://my.netscape.com/publish/formats/rss-0.91.dtd">RSS 0.91</option>
                                        <option value="http://www.scripting.com/dtd/rss-0.92.dtd">RSS 0.92</option>
                                        <option value="http://purl.org/rss/1.0/">RSS 1.0</option>
                                        
                                    </select>
                                </td>
                            </tr>

                        </table>

                        <input type="hidden" name="reptile.sequence.name" value="urn:channel-management"/>
                        
                        <input type="submit" name="submit" value="View/Import"/>

                    </form>

                </div>
    
            </control:body>

        </control:content>

    </xsl:template>    

</xsl:stylesheet>

