/*
 * Decompiled with CFR 0.152.
 */
package tyrex.conf;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import tyrex.conf.EnvEntry;
import tyrex.conf.Resource;
import tyrex.util.Logger;
import tyrex.util.Messages;

public class Resources
implements Serializable {
    public static String FileName = "resources.xml";
    private Vector _resList = new Vector();
    private Vector _envEntries = new Vector();
    private transient File _source;
    public static boolean debug;
    private static Resources _resources;
    static /* synthetic */ Class class$tyrex$conf$Server;
    static /* synthetic */ Class class$tyrex$conf$Resources;

    public void addEnvEntry(EnvEntry envEntry) {
        if (!this._envEntries.contains(envEntry)) {
            this._envEntries.addElement(envEntry);
        }
    }

    public void addResource(Resource resource) {
        if (!this._resList.contains(resource)) {
            this._resList.addElement(resource);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static synchronized Resources getResources() {
        if (_resources == null) {
            Resources.reloadResources();
        }
        return _resources;
    }

    public Enumeration listEnvEntries() {
        return this._envEntries.elements();
    }

    public Enumeration listResources() {
        return this._resList.elements();
    }

    public static Resources load() throws IOException {
        try {
            File file = new File(System.getProperty("user.dir"), FileName);
            if (file.exists()) {
                Logger.getSystemLogger().println(Messages.format("tyrex.conf.loadingResources", file));
                return Resources.load(file);
            }
            URL uRL = (class$tyrex$conf$Server != null ? class$tyrex$conf$Server : (class$tyrex$conf$Server = Resources.class$("tyrex.conf.Server"))).getResource("/" + FileName);
            if (uRL != null && (file = new File(uRL.getFile())).exists()) {
                Logger.getSystemLogger().println(Messages.format("tyrex.conf.loadingResources", file));
                return Resources.load(file);
            }
            file = new File(System.getProperty("java.home"), "lib");
            if ((file = new File(file, FileName)).exists()) {
                Logger.getSystemLogger().println(Messages.format("tyrex.conf.loadingResources", file));
                return Resources.load(file);
            }
        }
        catch (IOException iOException) {
            Logger.getSystemLogger().println(Messages.format("tyrex.conf.loadingResourcesError", iOException));
            throw iOException;
        }
        Logger.getSystemLogger().println(Messages.format("tyrex.conf.loadingResourcesMissing", FileName));
        throw new IOException(Messages.format("tyrex.conf.loadingResourcesMissing", FileName));
    }

    public static Resources load(File file) throws IOException {
        Resources resources = Resources.load(new FileReader(file));
        resources._source = file;
        return resources;
    }

    public static Resources load(Reader reader) throws IOException {
        try {
            ClassLoader classLoader = (class$tyrex$conf$Resources != null ? class$tyrex$conf$Resources : (class$tyrex$conf$Resources = Resources.class$("tyrex.conf.Resources"))).getClassLoader();
            Mapping mapping = new Mapping(classLoader);
            mapping.loadMapping(classLoader.getResource("tyrex/conf/mapping.xml"));
            Unmarshaller unmarshaller = new Unmarshaller(mapping);
            if (debug) {
                unmarshaller.setLogWriter((PrintWriter)Logger.getSystemLogger());
            }
            unmarshaller.setEntityResolver((EntityResolver)new SchemaEntityResolver());
            return (Resources)unmarshaller.unmarshal(reader);
        }
        catch (MarshalException marshalException) {
            Logger.getSystemLogger().println(Messages.format("tyrex.conf.loadingResourcesError", (Object)marshalException));
            throw new IOException(marshalException.toString());
        }
        catch (Exception exception) {
            Logger.getSystemLogger().println(Messages.format("tyrex.conf.loadingResourcesError", exception));
            throw new IOException("Nested exception: " + exception.toString());
        }
    }

    public static synchronized void reloadResources() {
        block2: {
            try {
                _resources = Resources.load();
            }
            catch (IOException iOException) {
                if (_resources != null) break block2;
                _resources = new Resources();
            }
        }
    }

    public void save() throws IOException {
        if (this._source == null) {
            throw new IOException(Messages.message("tyrex.conf.savingResourcesNotLoaded"));
        }
        this.save(new FileWriter(this._source));
    }

    public void save(Writer writer) throws IOException {
        try {
            Marshaller marshaller = new Marshaller(writer);
            if (debug) {
                marshaller.setLogWriter((PrintWriter)Logger.getSystemLogger());
            }
            marshaller.marshal((Object)this);
        }
        catch (MarshalException marshalException) {
            throw new IOException(marshalException.toString());
        }
        catch (Exception exception) {
            throw new IOException("Nested exception: " + exception);
        }
    }

    public static class DTD {
        public static final String PublicId = "-//EXOLAB/Tyrex Resources DTD Version 1.0//EN";
        public static final String SystemId = "http://tyrex.exolab.org/resources.dtd";
        private static final String Resource = "/tyrex/conf/resources.dtd";
    }

    public static class Namespace {
        public static final String PublicId = "-//EXOLAB/Tyrex Resources Schema Version 1.0//EN";
        public static final String SystemId = "http://tyrex.exolab.org/resources.xsd";
        public static final String prefix = "resources";
        public static final String URI = "http://tyrex.exolab.org/resources";
        private static final String Resource = "/tyrex/conf/resources.xsd";
    }

    static class SchemaEntityResolver
    implements EntityResolver {
        SchemaEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws IOException {
            if (string.equals("-//EXOLAB/Tyrex Resources DTD Version 1.0//EN") || string2.equals("http://tyrex.exolab.org/resources.dtd")) {
                InputSource inputSource = new InputSource();
                inputSource.setByteStream((class$tyrex$conf$Server != null ? class$tyrex$conf$Server : (class$tyrex$conf$Server = Resources.class$("tyrex.conf.Server"))).getResourceAsStream("/tyrex/conf/resources.dtd"));
                return inputSource;
            }
            if (string.equals("-//EXOLAB/Tyrex Resources Schema Version 1.0//EN") || string2.equals("http://tyrex.exolab.org/resources.xsd")) {
                InputSource inputSource = new InputSource();
                inputSource.setByteStream((class$tyrex$conf$Server != null ? class$tyrex$conf$Server : (class$tyrex$conf$Server = Resources.class$("tyrex.conf.Server"))).getResourceAsStream("/tyrex/conf/resources.xsd"));
                return inputSource;
            }
            return null;
        }
    }
}

