/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.sierra.tests;

import org.arrowhead.testlet.TestletContext;
import org.openprivacy.sierra.factories.ReputationFactory;
import org.openprivacy.sierra.nym.talon.components.NymBuilder;
import org.openprivacy.sierra.query.talon.components.QueryManager;
import org.openprivacy.sierra.query.talon.components.Result;
import org.openprivacy.sierra.query.talon.implementations.PropertyManagerTargetedQuery;
import org.openprivacy.sierra.rce.talon.components.RCE;
import org.openprivacy.sierra.reputation.ReputationConstrainer;
import org.openprivacy.sierra.reputation.talon.components.Reference;
import org.openprivacy.sierra.reputation.talon.components.Reputation;
import org.openprivacy.sierra.reputation.talon.implementations.PropertyManagerPayload;
import org.openprivacy.sierra.store.talon.components.StoreEngine;
import org.openprivacy.sierra.store.talon.implementations.simple.SimpleStoreEngine;
import org.openprivacy.sierra.tests.BaseTest;
import org.openprivacy.sierra.util.SierraResources;
import talon.ComponentFactory;
import talon.util.net.URI;

public class Test9
extends BaseTest {
    private RCE rce = null;
    private StoreEngine se = null;
    private NymBuilder a1 = null;
    private NymBuilder a2 = null;
    private NymBuilder r1 = null;
    static /* synthetic */ Class class$org$openprivacy$sierra$query$talon$implementations$PropertyManagerTargetedQuery;
    static /* synthetic */ Class class$org$openprivacy$sierra$reputation$talon$implementations$PropertyManagerPayload;

    public void initialize(TestletContext context) throws Exception {
        this.rce = (RCE)this.requireComponent(SierraResources.RCE_HANDLE);
        this.se = this.rce.getStoreEngine();
        this.a1 = this.getNymBuilder("urn:burtonator");
        this.a2 = this.getNymBuilder("urn:fen");
        this.r1 = this.getNymBuilder("urn:reptile");
        this.step_one();
        this.step_two();
        ((SimpleStoreEngine)this.se).dump();
        this.step_three();
    }

    public void step_one() throws Exception {
        Reputation channel_one = ReputationFactory.getInstance();
        channel_one.setReference("http://www.slashdot.org/slashdot.rdf");
        PropertyManagerPayload pmp = this.getPayload();
        pmp.setString("openprivacy:///reserved-properties/ontology", "rss");
        channel_one.addPayload(pmp);
        ReputationConstrainer.constrain(channel_one, this.r1);
        this.se.put(channel_one);
    }

    public void step_two() throws Exception {
        QueryManager qm = this.se.getQueryManager();
        PropertyManagerTargetedQuery query = (PropertyManagerTargetedQuery)ComponentFactory.getInstance((Class)(class$org$openprivacy$sierra$query$talon$implementations$PropertyManagerTargetedQuery == null ? (class$org$openprivacy$sierra$query$talon$implementations$PropertyManagerTargetedQuery = Test9.class$("org.openprivacy.sierra.query.talon.implementations.PropertyManagerTargetedQuery")) : class$org$openprivacy$sierra$query$talon$implementations$PropertyManagerTargetedQuery));
        query.setString("openprivacy:///reserved-properties/ontology", "rss");
        Result result = qm.execute(query);
        URI[] reputationURIs = result.getReputations();
        int i = 0;
        while (i < reputationURIs.length) {
            URI current = reputationURIs[i];
            Reputation reputation = this.se.get(current);
            if (reputation != null) {
                System.out.println("StepTwo: Found reputation URI: " + current);
                this.createGoodReputation(reputation.getReference());
            }
            ++i;
        }
    }

    public void step_three() throws Exception {
        System.out.println("Trying to find URLs which have a GOOD reputation.");
        QueryManager qm = this.se.getQueryManager();
        PropertyManagerTargetedQuery query = (PropertyManagerTargetedQuery)ComponentFactory.getInstance((Class)(class$org$openprivacy$sierra$query$talon$implementations$PropertyManagerTargetedQuery == null ? (class$org$openprivacy$sierra$query$talon$implementations$PropertyManagerTargetedQuery = Test9.class$("org.openprivacy.sierra.query.talon.implementations.PropertyManagerTargetedQuery")) : class$org$openprivacy$sierra$query$talon$implementations$PropertyManagerTargetedQuery));
        query.setString("openprivacy:///reserved-properties/ontology", "rss");
        query.setString("openprivacy:///reserved-properties/quality", "GOOD");
        Result result = qm.execute(query);
        URI[] reputationURIs = result.getReputations();
        int i = 0;
        while (i < reputationURIs.length) {
            URI current = reputationURIs[i];
            System.out.println("Found the following GOOD reputation: " + current);
            ++i;
        }
    }

    private void createGoodReputation(Reference reference) throws Exception {
        Reputation opinion = ReputationFactory.getInstance();
        opinion.setReference(reference);
        PropertyManagerPayload pmp = this.getPayload();
        pmp.setString("openprivacy:///reserved-properties/quality", "GOOD");
        opinion.addPayload(pmp);
        ReputationConstrainer.constrain(opinion, this.a1);
        this.se.put(opinion);
    }

    private PropertyManagerPayload getPayload() throws Exception {
        return (PropertyManagerPayload)ComponentFactory.getInstance((String)(class$org$openprivacy$sierra$reputation$talon$implementations$PropertyManagerPayload == null ? (class$org$openprivacy$sierra$reputation$talon$implementations$PropertyManagerPayload = Test9.class$("org.openprivacy.sierra.reputation.talon.implementations.PropertyManagerPayload")) : class$org$openprivacy$sierra$reputation$talon$implementations$PropertyManagerPayload).getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

