/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.sierra.query.talon.implementations.simple.util;

import java.util.Enumeration;
import org.openprivacy.sierra.query.talon.implementations.simple.SimpleQueryEngine;
import org.openprivacy.sierra.reputation.talon.components.Payload;
import org.openprivacy.sierra.reputation.talon.components.Reputation;
import org.openprivacy.sierra.reputation.talon.implementations.PropertyManagerPayload;
import org.openprivacy.sierra.util.sql.Insert;
import org.openprivacy.sierra.util.sql.Select;
import talon.components.DatabaseConnectionPool;

public class InsertReputation {
    private DatabaseConnectionPool dcp = null;
    private Reputation reputation = null;
    private SimpleQueryEngine sqe = null;
    int table_properties_fk_reputation = -1;

    public InsertReputation(DatabaseConnectionPool dcp, Reputation reputation, SimpleQueryEngine sqe) {
        this.dcp = dcp;
        this.reputation = reputation;
        this.sqe = sqe;
    }

    private void insertIntoReputationsTable(DatabaseConnectionPool dcp) throws Exception {
        this.sqe.getLogger().message((Object)("Adding database record for reputation: " + this.reputation.getURI().toString()));
        Insert insert = new Insert();
        insert.setDatabaseConnectionPool(dcp).setTable("reputations").addString("reference", this.reputation.getReference().toString()).addString("uri", this.reputation.getURI().toString());
        insert.commit();
        Select select = new Select();
        select.setDatabaseConnectionPool(dcp).setTable("reputations").addString("uri", this.reputation.getURI().toString());
        select.commit();
        this.table_properties_fk_reputation = select.getResultSet().getInt("pk");
    }

    private void insertIntoIdentifiersTable(DatabaseConnectionPool dcp, Payload payload) throws Exception {
        Select select = new Select();
        select.setDatabaseConnectionPool(dcp).setTable("identifiers").addString("uri", payload.getIdentifier().toString());
        select.commit();
        if (!select.getResultSet().next()) {
            this.sqe.getLogger().message((Object)("Adding database record for identifier: " + payload.getIdentifier().toString()));
            Insert insert = new Insert();
            insert.setDatabaseConnectionPool(dcp).setTable("identifiers").addString("uri", payload.getIdentifier().toString());
            insert.commit();
        }
    }

    private void insertIntoPropertiesTable(DatabaseConnectionPool dcp, Payload payload) throws Exception {
        int table_properties_fk_identifier = -1;
        Select select_identifier = new Select();
        select_identifier.setDatabaseConnectionPool(dcp).setTable("identifiers").addString("uri", payload.getIdentifier().toString());
        select_identifier.commit();
        select_identifier.getResultSet().next();
        table_properties_fk_identifier = select_identifier.getResultSet().getInt("pk");
        if (this.table_properties_fk_reputation == -1) {
            Select select_reputation = new Select();
            select_reputation.setDatabaseConnectionPool(dcp).setTable("reputations").addString("uri", payload.getIdentifier().toString());
            select_reputation.commit();
            select_reputation.getResultSet().next();
            this.table_properties_fk_reputation = select_reputation.getResultSet().getInt("pk");
        }
        PropertyManagerPayload pmp = (PropertyManagerPayload)payload;
        Enumeration keys = pmp.getKeys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String value = pmp.getProperty(name).toString();
            Insert insert = new Insert();
            insert.setDatabaseConnectionPool(dcp).setTable("properties").addInteger("reputation", this.table_properties_fk_reputation).addInteger("identifier", table_properties_fk_identifier).addString("name", name).addString("value", value).addString("type", "string");
            insert.commit();
        }
    }

    public void commit() throws Exception {
        Select verify = new Select();
        verify.setDatabaseConnectionPool(this.dcp).setTable("reputations").addString("uri", this.reputation.getURI().toString());
        verify.commit();
        if (!verify.getResultSet().next()) {
            this.insertIntoReputationsTable(this.dcp);
            Enumeration payloads = this.reputation.getPayloads();
            while (payloads.hasMoreElements()) {
                Payload current = (Payload)payloads.nextElement();
                if (this.sqe.supports(current)) {
                    this.sqe.getLogger().message((Object)("Indexing payload: " + current.getTypeReference()));
                    this.insertIntoIdentifiersTable(this.dcp, current);
                    this.insertIntoPropertiesTable(this.dcp, current);
                    continue;
                }
                this.sqe.getLogger().warn((Object)("The given payload is not supported: " + current.getTypeReference()));
            }
        } else {
            this.sqe.getLogger().warn((Object)("The given reputation already is already indexed: " + this.reputation.getURI()));
        }
    }
}

