/*
 * Decompiled with CFR 0.152.
 */
package talon.util;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import talon.BaseComponent;
import talon.Component;
import talon.components.PropertyManager;
import talon.components.exceptions.RequiredPropertyException;
import talon.implementations.SimplePropertyManager;

public abstract class BasePropertyManager
extends BaseComponent
implements Component,
PropertyManager {
    private Hashtable props = new Hashtable();

    public Object getProperty(String name) {
        return this.props.get(name);
    }

    public Object getProperty(String name, Object _default) {
        Object value = (String)this.props.get(name);
        if (value == null) {
            value = _default;
        }
        return value;
    }

    public boolean getBoolean(String name) {
        String value = this.getString(name);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }

    public PropertyManager setBoolean(String name, boolean value) {
        if (value) {
            this.setProperty(name, "true");
        } else {
            this.setProperty(name, "false");
        }
        return this;
    }

    public PropertyManager setString(String name, String value) {
        this.setProperty(name, value);
        return this;
    }

    public String getString(String name) {
        return (String)this.getProperty(name);
    }

    public String getString(String _name, String _default) {
        String value = this.getString(_name);
        if (value == null) {
            return _default;
        }
        return value;
    }

    public Vector getVector(String name) {
        String prop;
        Vector<String> v = new Vector<String>();
        int i = 0;
        while ((prop = this.getString(name + "." + i)) != null) {
            v.addElement(prop);
            ++i;
        }
        return v;
    }

    public PropertyManager getGroup(String key) {
        Enumeration keys = this.getKeys();
        SimplePropertyManager result = new SimplePropertyManager();
        boolean noKeysFound = true;
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            if (name.indexOf(key) != 0) continue;
            noKeysFound = false;
            Object value = this.getProperty(name);
            name = name.substring(key.length() + 1, name.length());
            result.setProperty(name, value);
        }
        if (noKeysFound) {
            return null;
        }
        return result;
    }

    public PropertyManager setProperty(String name, Object value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("Name and value must not be null");
        }
        this.props.put(name, value);
        return this;
    }

    public Enumeration getKeys() {
        return this.props.keys();
    }

    public void setProperties(Properties props) {
        this.props = props;
    }

    public void require(String[] requirements) throws RequiredPropertyException {
        int i = 0;
        while (i < requirements.length) {
            if (!this.props.containsKey(requirements[i])) {
                throw new RequiredPropertyException("The required property for this component does not exist: " + requirements[i]);
            }
            ++i;
        }
    }

    public boolean containsKey(String key) {
        return this.props.containsKey(key);
    }

    public boolean contains(Object object) {
        return this.props.containsKey(object);
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream ps) {
        ps.println(this.getPrettyPrint());
    }

    private String getPrettyPrint() {
        Enumeration keys = this.getKeys();
        StringBuffer buff = new StringBuffer();
        buff.append("-- listing properties --\n");
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            Object value = this.getProperty(name);
            buff.append(name.toString() + " = " + value.toString() + "\n");
        }
        return buff.toString();
    }

    public int size() {
        return this.props.size();
    }

    public Integer getInteger(String _name) {
        return (Integer)this.getProperty(_name);
    }

    public Integer getInteger(String _name, Integer _default) {
        Integer result = this.getInteger(_name);
        if (result == null) {
            result = _default;
        }
        return result;
    }

    public PropertyManager setInteger(String _name, Integer _value) {
        this.setProperty(_name, _value);
        return this;
    }

    public PropertyManager setInteger(String _name, int _value) {
        return this.setInteger(_name, new Integer(_value));
    }

    public Long getLong(String _name) {
        return (Long)this.getProperty(_name);
    }

    public Long getLong(String _name, Long _default) {
        Long result = this.getLong(_name);
        if (result == null) {
            result = _default;
        }
        return result;
    }

    public PropertyManager setLong(String _name, Long _value) {
        this.setProperty(_name, _value);
        return this;
    }

    public PropertyManager setLong(String _name, long _value) {
        return this.setLong(_name, new Long(_value));
    }
}

