/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls.jxta;

import COM.claymoresystems.ptls.jxta.MessageElement;
import COM.claymoresystems.ptls.jxta.MimeMediaType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MessageElementImpl
extends MessageElement {
    private String name;
    private MimeMediaType type;
    private byte[] bytes;
    private int offset;
    private int len;
    private MessageElement sig;

    public MessageElementImpl(String string, MimeMediaType mimeMediaType, byte[] byArray, int n, int n2, MessageElement messageElement) {
        this.name = string;
        this.type = mimeMediaType;
        this.bytes = byArray;
        this.offset = n;
        this.len = n2;
        this.sig = messageElement;
    }

    public MessageElementImpl(String string, MimeMediaType mimeMediaType, InputStream inputStream, int n, MessageElement messageElement) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n < 0 ? 1024 : n);
        byte[] byArray = new byte[1024];
        this.name = string;
        this.type = mimeMediaType;
        int n2 = 0;
        while (n < 0 || n2 < n) {
            int n3 = n - n2;
            int n4 = n < 0 || n3 > 1024 ? 1024 : n3;
            int n5 = inputStream.read(byArray, 0, n4);
            if (n5 <= 0) break;
            byteArrayOutputStream.write(byArray, 0, n5);
            n2 += n5;
        }
        this.offset = 0;
        this.len = n2;
        this.bytes = byteArrayOutputStream.toByteArray();
        if (n < 0) {
            inputStream.close();
        }
    }

    public MessageElementImpl(String string, MimeMediaType mimeMediaType, InputStream inputStream, MessageElement messageElement) throws IOException {
        this(string, mimeMediaType, inputStream, -1, messageElement);
        inputStream.close();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.len;
    }

    public byte[] getBytesOffset() {
        return this.bytes;
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.bytes, this.offset, this.len);
    }

    public String getName() {
        return this.name;
    }

    public MimeMediaType getType() {
        return this.type;
    }

    public MessageElement getSignature() {
        return this.sig;
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MessageElement)) {
            return false;
        }
        MessageElement messageElement = (MessageElement)object;
        boolean bl = this.name == null ? messageElement.getName() != null : !this.name.equals(messageElement.getName());
        if (bl) {
            return false;
        }
        boolean bl2 = this.type == null ? messageElement.getType() != null : !this.type.equals(messageElement.getType());
        if (bl2) {
            return false;
        }
        if (this.len != messageElement.getLength()) {
            return false;
        }
        byte[] byArray = messageElement.getBytesOffset();
        int n = messageElement.getOffset();
        int n2 = 0;
        while (n2 < this.len) {
            if (this.bytes[this.offset + n2] != byArray[n++]) {
                return false;
            }
            ++n2;
        }
        return this.sig == null ? messageElement.getSignature() == null : this.sig.equals(messageElement.getSignature());
    }
}

