/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls.demo;

import COM.claymoresystems.cert.WrappedObject;
import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.crypto.EAYEncryptedPrivateKey;
import COM.claymoresystems.util.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import jxta.security.cipher.Cipher;
import jxta.security.cipher.Key;
import jxta.security.exceptions.CryptoException;
import jxta.security.hash.Hash;
import jxta.security.impl.cipher.KeyBuilder;
import jxta.security.impl.cipher.SecretKey;
import jxta.security.impl.crypto.JxtaCryptoSuite;
import jxta.security.impl.random.JRandom;
import jxta.security.util.URLBase64;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PeerCertsDemo {
    static final boolean demo = true;
    static final int RSABITS = 1024;
    private static final int NUM_BYTES = 128;

    public static IssuerInfo genPeerRootCert(String string) throws IOException {
        String string2 = "peerRoot.pem";
        System.out.println("Generating root cert ...");
        IssuerInfo issuerInfo = PeerCertsDemo.genCert(string2, string + "-CA", null);
        return issuerInfo;
    }

    public static void genPeerServiceCert(String string, IssuerInfo issuerInfo) throws IOException, CryptoException {
        String string2 = "peerService.pem";
        byte[] byArray = null;
        byArray = PeerCertsDemo.genPassPhrase("password");
        System.out.println("\nGenerating client cert ...");
        IssuerInfo issuerInfo2 = PeerCertsDemo.genCert(string2, string, issuerInfo);
        RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)issuerInfo2.subjectPkey;
        FileWriter fileWriter = new FileWriter(string2, true);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        EAYEncryptedPrivateKey.writePrivateKey(rSAPrivateCrtKey, byArray, bufferedWriter);
        bufferedWriter.flush();
        fileWriter.close();
    }

    private static SecureRandom seedSRN() throws CryptoException {
        byte[] byArray = new byte[128];
        JRandom jRandom = new JRandom();
        jRandom.nextBytes(byArray);
        return new SecureRandom(byArray);
    }

    public static byte[] genPassPhrase() throws IOException {
        String string = "phrase.pem";
        byte[] byArray = new byte[128];
        SecureRandom secureRandom = null;
        try {
            secureRandom = PeerCertsDemo.seedSRN();
        }
        catch (CryptoException cryptoException) {
            return null;
        }
        secureRandom.nextBytes(byArray);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byte[] byArray3 = null;
        try {
            JxtaCryptoSuite jxtaCryptoSuite = new JxtaCryptoSuite(4, null, 0, 0);
            Hash hash = jxtaCryptoSuite.getJxtaHash((byte)1);
            byte[] byArray4 = new byte[hash.getDigestLength()];
            int n = 0;
            while (n < 127) {
                hash.update(byArray, 0, byArray.length);
                ++n;
            }
            hash.doFinal(byArray, 0, byArray.length, byArray4, 0);
            byArray3 = URLBase64.encode((byte[])byArray4);
            FileWriter fileWriter = new FileWriter(string);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            WrappedObject.writeHeader("PASSPHRASE", bufferedWriter);
            WrappedObject.writeObject(byArray3, "PASSPHRASE", bufferedWriter);
            fileWriter.close();
        }
        catch (CryptoException cryptoException) {
            throw new IOException("Could not generate passphrase");
        }
        return byArray3;
    }

    public static byte[] genPassPhrase(String string) throws IOException, CryptoException {
        String string2 = "phrase.pem";
        byte[] byArray = string.getBytes();
        byte[] byArray2 = URLBase64.encode((byte[])byArray);
        File file = File.createTempFile("yyj", null);
        FileWriter fileWriter = new FileWriter(file);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        WrappedObject.writeHeader("PASSPHRASE", bufferedWriter);
        WrappedObject.writeObject(byArray2, "PASSPHRASE", bufferedWriter);
        fileWriter.close();
        int n = (int)file.length();
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray3 = new byte[n];
        int n2 = fileInputStream.read(byArray3, 0, n);
        fileInputStream.close();
        file.delete();
        JxtaCryptoSuite jxtaCryptoSuite = new JxtaCryptoSuite(1, null, 0, 0);
        Cipher cipher = jxtaCryptoSuite.getJxtaCipher();
        SecretKey secretKey = (SecretKey)KeyBuilder.buildKey((byte)8, (short)128, (boolean)false);
        byte[] byArray4 = string.getBytes();
        byte[] byArray5 = new byte[16];
        int n3 = 0;
        int n4 = 0;
        while (n3 < byArray5.length) {
            byArray5[n3] = byArray4[n4++];
            if (n4 == byArray4.length) {
                n4 = 0;
            }
            ++n3;
        }
        System.out.println("RC4 key = " + new String(byArray5));
        secretKey.setKey(byArray5, 0);
        byte[] byArray6 = new byte[n];
        cipher.init((Key)secretKey, (byte)1);
        cipher.doFinal(byArray3, 0, n, byArray6, 0);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        fileOutputStream.write(byArray6, 0, n);
        fileOutputStream.close();
        String string3 = new String(byArray2);
        System.out.println("Passphrase = " + string3);
        return byArray2;
    }

    private static void insertCertText(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        FileWriter fileWriter = new FileWriter(string, true);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        try {
            byte[] byArray;
            while ((byArray = WrappedObject.loadObject(bufferedReader, "CERTIFICATE", null)) != null) {
                X509Cert x509Cert = new X509Cert(byArray);
                bufferedWriter.write("Serial Number: " + x509Cert.getSerial().toString() + "\n");
                bufferedWriter.write("Issuer : " + x509Cert.getIssuerName().getNameString() + "\n");
                bufferedWriter.write("Validity\n");
                bufferedWriter.write("\t Not Before: " + x509Cert.getValidityNotBefore().toString() + "\n");
                bufferedWriter.write("\t Not After : " + x509Cert.getValidityNotAfter().toString() + "\n");
                bufferedWriter.write("Subject: " + x509Cert.getSubjectName().getNameString() + "\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        bufferedWriter.flush();
        fileWriter.close();
    }

    public static IssuerInfo genCert(String string, String string2, IssuerInfo issuerInfo) throws IOException {
        try {
            SecureRandom secureRandom = PeerCertsDemo.seedSRN();
            Security.addProvider((Provider)new BouncyCastleProvider());
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
            keyPairGenerator.initialize(1024, secureRandom);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            Hashtable hashtable = new Hashtable();
            hashtable.put(X509Name.C, "US");
            hashtable.put(X509Name.O, "www.jxta.org");
            hashtable.put(X509Name.L, "SF");
            byte[] byArray = new byte[10];
            secureRandom.nextBytes(byArray);
            String string3 = jxta.security.util.Util.hexEncode((byte[])byArray);
            hashtable.put(X509Name.OU, string3);
            hashtable.put(X509Name.CN, string2);
            Date date = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(1, 10);
            Date date2 = calendar.getTime();
            Hashtable hashtable2 = null;
            PrivateKey privateKey2 = null;
            String string4 = null;
            if (issuerInfo == null) {
                hashtable2 = hashtable;
                privateKey2 = privateKey;
                string4 = "\nRoot Cert:";
            } else {
                hashtable2 = issuerInfo.issuer;
                privateKey2 = issuerInfo.rootKey;
                string4 = "\nClient Cert:";
            }
            X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
            x509V3CertificateGenerator.setSerialNumber(BigInteger.valueOf(1L));
            x509V3CertificateGenerator.setIssuerDN((X509Name)new X509Principal(hashtable2));
            x509V3CertificateGenerator.setNotBefore(date);
            x509V3CertificateGenerator.setNotAfter(date2);
            x509V3CertificateGenerator.setSubjectDN((X509Name)new X509Principal(hashtable));
            x509V3CertificateGenerator.setPublicKey(publicKey);
            x509V3CertificateGenerator.setSignatureAlgorithm("SHA1withRSA");
            X509Certificate x509Certificate = x509V3CertificateGenerator.generateX509Certificate(privateKey2);
            FileWriter fileWriter = new FileWriter(string);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(x509Certificate.toString());
            bufferedWriter.flush();
            byte[] byArray2 = x509Certificate.getEncoded();
            Util.xdump(string4, byArray2);
            WrappedObject.writeHeader("CERTIFICATE", bufferedWriter);
            WrappedObject.writeObject(byArray2, "CERTIFICATE", bufferedWriter);
            fileWriter.close();
            IssuerInfo issuerInfo2 = new IssuerInfo();
            issuerInfo2.issuer = hashtable2;
            issuerInfo2.rootKey = privateKey2;
            issuerInfo2.subjectPkey = privateKey;
            return issuerInfo2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("genCert: " + noSuchAlgorithmException.getMessage());
        }
        catch (SignatureException signatureException) {
            System.out.println("genCert: " + signatureException.getMessage());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            System.out.println("genCert: " + certificateEncodingException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            System.out.println("genCert: " + invalidKeyException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            System.out.println("genCert: " + noSuchProviderException.getMessage());
        }
        catch (CertificateException certificateException) {
            System.out.println("genCert: " + certificateException.getMessage());
        }
        catch (CryptoException cryptoException) {
            System.out.println("genCert: " + cryptoException.getMessage());
        }
        throw new IOException("Could not generate certificate");
    }

    public static void main(String[] stringArray) throws Exception, CryptoException {
        System.out.println("PeerCertsDemo: Using RSA Key size = 1024\n");
        IssuerInfo issuerInfo = PeerCertsDemo.genPeerRootCert("Test");
        PeerCertsDemo.genPeerServiceCert("Test", issuerInfo);
    }

    private static class IssuerInfo {
        PrivateKey rootKey;
        Hashtable issuer;
        PrivateKey subjectPkey;

        private IssuerInfo() {
        }
    }
}

