/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLCipherState;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLHandshake;
import COM.claymoresystems.ptls.SSLMAC;
import COM.claymoresystems.util.Util;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class SSLv3MAC
extends SSLMAC {
    SSLv3MAC() {
    }

    public static byte[] calcMAC(SSLCipherState sSLCipherState, int n, int n2, long l, byte[] byArray) {
        try {
            int n3 = sSLCipherState.cipher_suite.getDigestOutputLength() == 16 ? 48 : 40;
            SSLDebug.debug(8, "MAC Key", sSLCipherState.mac_key);
            MessageDigest messageDigest = MessageDigest.getInstance(sSLCipherState.cipher_suite.getDigestAlg());
            byte[] byArray2 = new byte[]{(byte)n};
            messageDigest.update(sSLCipherState.mac_key);
            int n4 = 0;
            while (n4 < n3) {
                messageDigest.update(SSLHandshake.pad_1);
                ++n4;
            }
            byte[] byArray3 = Util.toBytes(l);
            SSLDebug.debug(8, "Sequence", byArray3);
            messageDigest.update(byArray3);
            messageDigest.update(byArray2);
            SSLDebug.debug(8, "Content type", byArray2);
            byArray3 = Util.toBytes(byArray.length, 2);
            SSLDebug.debug(8, "Length", byArray3);
            messageDigest.update(byArray3);
            SSLDebug.debug(8, "Data", byArray);
            messageDigest.update(byArray);
            byArray3 = messageDigest.digest();
            messageDigest.update(sSLCipherState.mac_key);
            int n5 = 0;
            while (n5 < n3) {
                messageDigest.update(SSLHandshake.pad_2);
                ++n5;
            }
            messageDigest.update(byArray3);
            byArray3 = messageDigest.digest();
            SSLDebug.debug(8, "Computed SSLv3 MAC", byArray3);
            return byArray3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("Missing algorithm. This shouldn't happen");
        }
    }
}

