/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLAlert;
import COM.claymoresystems.ptls.SSLAlertX;
import COM.claymoresystems.ptls.SSLCaughtAlertException;
import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLInputStream;
import COM.claymoresystems.ptls.SSLRecord;
import java.io.ByteArrayInputStream;
import java.io.IOException;

class SSLRecordReader {
    SSLConn conn;
    SSLInputStream[] streams = new SSLInputStream[]{new SSLInputStream(this), new SSLInputStream(this)};

    public SSLRecordReader(SSLConn sSLConn) {
        this.conn = sSLConn;
        this.conn.sock_in_hp = this.streams[0];
        this.conn.sock_in_data = this.streams[1];
    }

    public int readRecord() throws IOException {
        if (this.conn.recvdClose) {
            return -1;
        }
        SSLRecord sSLRecord = new SSLRecord(this.conn);
        sSLRecord.decode(this.conn, this.conn.sock_in);
        int n = sSLRecord.type.value;
        switch (n) {
            case 20: {
                this.conn.hs.recvChangeCipherSpecs();
                break;
            }
            case 21: {
                this.processAlert(sSLRecord.data.value);
                break;
            }
            case 22: {
                if (sSLRecord.data.value[0] == 0) {
                    this.conn.processHelloRequest();
                    break;
                }
            }
            case 23: {
                this.streams[n - 22].write(sSLRecord);
                SSLDebug.debug(1, "Read a new record type " + n + "length" + sSLRecord.data.value.length);
                break;
            }
            default: {
                throw new IOException("Bad record type" + n);
            }
        }
        return 0;
    }

    public void processAlert(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SSLAlert sSLAlert = new SSLAlert();
        sSLAlert.decode(this.conn, byteArrayInputStream);
        SSLAlertX sSLAlertX = new SSLAlertX(sSLAlert.description.value, sSLAlert.level.value);
        if (sSLAlertX.fatalP()) {
            this.conn.recvdClose = true;
            this.conn.makeUnresumable();
        }
        if (sSLAlert.description.value != SSLAlertX.TLS_ALERT_CLOSE_NOTIFY) {
            throw new SSLCaughtAlertException(sSLAlertX);
        }
        this.conn.recvdClose = true;
    }
}

