/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLAlertX;
import COM.claymoresystems.ptls.SSLCipherState;
import COM.claymoresystems.ptls.SSLCipherSuite;
import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLMAC;
import COM.claymoresystems.ptls.SSLPDU;
import COM.claymoresystems.ptls.SSLopaque;
import COM.claymoresystems.ptls.SSLuint16;
import COM.claymoresystems.ptls.SSLuint8;
import COM.claymoresystems.util.Bench;
import cryptix.util.core.ArrayUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class SSLRecord
extends SSLPDU {
    SSLuint8 type = new SSLuint8();
    SSLuint16 version = new SSLuint16();
    SSLopaque data = new SSLopaque(-65535);
    public static final int SSL_CT_CHANGE_CIPHER_SPEC = 20;
    public static final int SSL_CT_ALERT = 21;
    public static final int SSL_CT_HANDSHAKE = 22;
    public static final int SSL_CT_APPLICATION_DATA = 23;

    public SSLRecord(SSLConn sSLConn, int n, byte[] byArray) {
        this.type.value = n;
        this.version.value = sSLConn.ssl_version;
        this.data.value = byArray;
    }

    public SSLRecord(SSLConn sSLConn) {
    }

    public int encode(SSLConn sSLConn, OutputStream outputStream) throws Error, IOException {
        int n = 0;
        Bench.start(1);
        n = this.type.encode(sSLConn, outputStream);
        n += this.version.encode(sSLConn, outputStream);
        if (sSLConn.write_cipher_state != null) {
            int n2 = this.data.value.length;
            int n3 = 0;
            SSLDebug.debug(8, "Encoding record");
            SSLCipherSuite sSLCipherSuite = sSLConn.write_cipher_state.cipher_suite;
            n2 += sSLCipherSuite.getDigestOutputLength();
            SSLDebug.debug(8, "Encrypting: plain text", this.data.value);
            if (sSLCipherSuite.blockCipherP()) {
                if ((n3 = 8 - ++n2 % 8) == 8) {
                    n3 = 0;
                }
                n2 += n3;
            }
            Bench.start(5);
            byte[] byArray = this.calcMac(sSLConn, sSLConn.write_cipher_state, sSLConn.write_sequence_num++, this.data.value);
            Bench.end(5);
            SSLDebug.debug(8, "Encoding MAC", byArray);
            byte[] byArray2 = new byte[n2];
            Bench.start(6);
            System.arraycopy(this.data.value, 0, byArray2, 0, this.data.value.length);
            System.arraycopy(byArray, 0, byArray2, this.data.value.length, byArray.length);
            if (sSLCipherSuite.blockCipherP()) {
                int n4 = 0;
                while (n4 < n3 + 1) {
                    byArray2[n4 + byArray.length + this.data.value.length] = (byte)n3;
                    ++n4;
                }
            }
            Bench.end(6);
            Bench.start(3);
            this.data.value = sSLConn.write_cipher_state.cipher != null ? sSLConn.write_cipher_state.cipher.update(byArray2) : byArray2;
            Bench.end(3);
            SSLDebug.debug(8, "Encrypting: cipher text", this.data.value);
        }
        Bench.end(1);
        return n += this.data.encode(sSLConn, outputStream);
    }

    public int decode(SSLConn sSLConn, InputStream inputStream) throws IOException, Error {
        int n = 0;
        try {
            n = this.type.decode(sSLConn, inputStream);
            n += this.version.decode(sSLConn, inputStream);
            n += this.data.decode(sSLConn, inputStream);
            if (sSLConn.read_cipher_state != null) {
                int n2;
                SSLCipherSuite sSLCipherSuite = sSLConn.read_cipher_state.cipher_suite;
                SSLDebug.debug(8, "Decoding record", this.data.value);
                SSLDebug.debug(8, "Ciphertext", this.data.value);
                byte[] byArray = sSLConn.read_cipher_state.cipher != null ? sSLConn.read_cipher_state.cipher.update(this.data.value) : this.data.value;
                SSLDebug.debug(8, "Plaintext", byArray);
                if (sSLCipherSuite.blockCipherP()) {
                    n2 = byArray.length;
                    byte by = byArray[n2 - 1];
                    if (by < 0) {
                        SSLDebug.debug(8, "Negative pad");
                        sSLConn.alert(SSLAlertX.TLS_ALERT_BAD_RECORD_MAC);
                    }
                    if (by > n2) {
                        SSLDebug.debug(8, "Pad longer than plaintext");
                        sSLConn.alert(SSLAlertX.TLS_ALERT_BAD_RECORD_MAC);
                    }
                    n2 -= by + 1;
                } else {
                    n2 = byArray.length;
                }
                int n3 = sSLConn.read_cipher_state.cipher_suite.getDigestOutputLength();
                if (n2 < n3) {
                    SSLDebug.debug(8, "MAC too long for record--garbage");
                    sSLConn.alert(SSLAlertX.TLS_ALERT_BAD_RECORD_MAC);
                }
                byte[] byArray2 = new byte[n2 - n3];
                System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                byte[] byArray3 = this.calcMac(sSLConn, sSLConn.read_cipher_state, sSLConn.read_sequence_num++, byArray2);
                SSLDebug.debug(8, "Computed MAC", byArray3);
                if (n3 != byArray3.length) {
                    throw new InternalError("Inconsistent digest lengths");
                }
                byte[] byArray4 = new byte[byArray3.length];
                System.arraycopy(byArray, n2 - byArray4.length, byArray4, 0, byArray4.length);
                SSLDebug.debug(8, "Message MAC", byArray4);
                if (!ArrayUtil.areEqual((byte[])byArray4, (byte[])byArray3)) {
                    sSLConn.alert(SSLAlertX.TLS_ALERT_BAD_RECORD_MAC);
                }
                this.data.value = new byte[n2 -= byArray4.length];
                System.arraycopy(byArray, 0, this.data.value, 0, n2);
            }
        }
        catch (IOException iOException) {
            sSLConn.makeUnresumable();
            throw iOException;
        }
        return n;
    }

    public void send(SSLConn sSLConn) throws Error, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.data.value.length + 30);
        this.encode(sSLConn, byteArrayOutputStream);
        byteArrayOutputStream.writeTo(sSLConn.sock_out);
    }

    public byte[] calcMac(SSLConn sSLConn, SSLCipherState sSLCipherState, long l, byte[] byArray) {
        return SSLMAC.calcMAC(sSLConn, sSLCipherState, this.type.value, l, byArray);
    }
}

