/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.document.Element;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;

public abstract class PeerAdvertisement
extends Advertisement
implements Cloneable {
    private PeerID pid = null;
    private PeerGroupID gid = null;
    private String name = null;
    private String description = null;
    private String debugLevel = null;
    private Hashtable serviceParams = new Hashtable();

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void impossible;
            PeerAdvertisement result = (PeerAdvertisement)super.clone();
            result.serviceParams = (Hashtable)this.serviceParams.clone();
            return impossible;
        }
        catch (CloneNotSupportedException impossible) {
            return null;
        }
    }

    public static String getAdvertisementType() {
        return "jxta:PA";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PeerID getPeerID() {
        return this.pid == null ? null : (PeerID)this.pid.clone();
    }

    public void setPeerID(PeerID pid) {
        this.pid = pid == null ? null : (PeerID)pid.clone();
    }

    public PeerGroupID getPeerGroupID() {
        return this.gid == null ? null : (PeerGroupID)this.gid.clone();
    }

    public void setPeerGroupID(PeerGroupID gid) {
        this.gid = gid == null ? null : (PeerGroupID)gid.clone();
    }

    public ID getID() {
        String peer;
        if (this.gid == null || this.pid == null) {
            return null;
        }
        if (this.gid.equals(PeerGroupID.defaultNetPeerGroupID) || this.gid.equals(PeerGroupID.worldPeerGroupID)) {
            peer = this.pid.getUniqueValue().toString();
        } else {
            String grp = this.gid.getUniqueValue().toString();
            grp = grp.substring(0, grp.length() - 2);
            peer = this.pid.getUniqueValue().toString();
            peer = grp + peer.substring(grp.length());
        }
        try {
            return IDFactory.fromURL(new URL("urn", "", "jxta:" + peer));
        }
        catch (MalformedURLException iDontMakeMistakes) {
        }
        catch (UnknownServiceException unknownServiceException) {
            // empty catch block
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(String debugLevel) {
        this.debugLevel = debugLevel;
    }

    public void setServiceParams(Hashtable params) {
        if (params == null) {
            this.serviceParams = new Hashtable();
            return;
        }
        Hashtable<Object, StructuredDocument> copy = new Hashtable<Object, StructuredDocument>();
        Enumeration keys = params.keys();
        while (keys.hasMoreElements()) {
            ID key = (ID)keys.nextElement();
            Element e = (Element)params.get(key);
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(e);
            copy.put(key.clone(), newDoc);
        }
        this.serviceParams = copy;
    }

    public Hashtable getServiceParams() {
        Hashtable<Object, StructuredDocument> copy = new Hashtable<Object, StructuredDocument>();
        Enumeration keys = this.serviceParams.keys();
        while (keys.hasMoreElements()) {
            ID key = (ID)keys.nextElement();
            Element e = (Element)this.serviceParams.get(key);
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(e);
            copy.put(key.clone(), newDoc);
        }
        return copy;
    }

    public void putServiceParam(ID key, Element param) {
        if (param == null) {
            this.serviceParams.remove(key);
            return;
        }
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        this.serviceParams.put(key.clone(), newDoc);
    }

    public StructuredDocument getServiceParam(ID key) {
        Element param = (Element)this.serviceParams.get(key);
        if (param == null) {
            return null;
        }
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        return newDoc;
    }

    public StructuredDocument removeServiceParam(ID key) {
        Element param = (Element)this.serviceParams.remove(key);
        if (param == null) {
            return null;
        }
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        return newDoc;
    }
}

