/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.peergroup;

import net.jxta.exception.JxtaError;
import net.jxta.exception.PeerGroupException;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ModuleImplAdvertisement;

public class PeerGroupFactory {
    private static Class stdPeerGroupClass;
    private static Class platformClass;

    public static void setStdPeerGroupClass(Class c) {
        stdPeerGroupClass = c;
    }

    public static void setPlatformClass(Class c) {
        platformClass = c;
    }

    public static PeerGroup newPeerGroup() {
        try {
            return (PeerGroup)stdPeerGroupClass.newInstance();
        }
        catch (Exception e) {
            throw new JxtaError("No valid Standard PeerGroup class");
        }
    }

    public static PeerGroup newPlatform() {
        PeerGroup plat = null;
        try {
            plat = (PeerGroup)platformClass.newInstance();
        }
        catch (Exception e) {
            throw new JxtaError("No valid Platform class");
        }
        try {
            plat.init(null, null, null);
        }
        catch (Exception e) {
            throw new JxtaError("Platform.init failed");
        }
        return plat;
    }

    public static PeerGroup newNetPeerGroup(PeerGroup pg) throws PeerGroupException {
        try {
            ModuleImplAdvertisement netPgImplAdv = pg.getAllPurposePeerGroupImplAdvertisement();
            netPgImplAdv.setModuleSpecID(PeerGroup.refNetPeerGroupSpecID);
            netPgImplAdv.setCode("net.jxta.impl.peergroup.ShadowPeerGroup");
            netPgImplAdv.setDescription("Default NetPeerGroup reference implementation.");
            PeerGroupID pgId = PeerGroupID.defaultNetPeerGroupID;
            PeerGroup newPg = pg.newGroup(pgId, netPgImplAdv, "NetPeerGroup", "NetPeerGroup by default");
            return newPg;
        }
        catch (Exception e) {
            throw new PeerGroupException(e.getMessage());
        }
    }

    public static PeerGroup newNetPeerGroup() throws PeerGroupException {
        try {
            PeerGroupFactory.setPlatformClass(Class.forName("net.jxta.impl.peergroup.Platform"));
            PeerGroupFactory.setStdPeerGroupClass(Class.forName("net.jxta.impl.peergroup.StdPeerGroup"));
        }
        catch (ClassNotFoundException e) {
            throw new PeerGroupException("Unable to find class :" + e.getMessage());
        }
        PeerGroup platformGroup = PeerGroupFactory.newPlatform();
        PeerGroup npg = PeerGroupFactory.newNetPeerGroup(platformGroup);
        return npg;
    }
}

