/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.xml;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jxta.impl.xml.XmlParser;

public class BinaryXmlParser {
    public void parse(InputStream in, byte[] buf, XmlParser.ParserCallback cb, AtomTable atomTable) throws IOException, XmlParser.Exception {
        DataInputStream din = new DataInputStream(in);
        byte[] attrName = null;
        block9: while (true) {
            switch (din.read()) {
                case 1: {
                    int id = din.readInt();
                    int len = din.readInt();
                    byte[] str = new byte[len];
                    din.readFully(str);
                    atomTable.intern(str);
                    break;
                }
                case 2: {
                    int id = din.readInt();
                    byte[] tag = atomTable.getAtom(id);
                    cb.startTag(tag, 0, tag.length);
                    break;
                }
                case 3: {
                    int id = din.readInt();
                    attrName = atomTable.getAtom(id);
                    break;
                }
                case 4: {
                    int id = din.readInt();
                    byte[] attrValue = atomTable.getAtom(id);
                    cb.attribute(attrName, 0, attrName.length, attrValue, 0, attrValue.length);
                    break;
                }
                case 5: {
                    int len = din.readInt();
                    while (true) {
                        if (len <= 0) continue block9;
                        int n = Math.min(len, buf.length);
                        n = din.read(buf, 0, n);
                        cb.chars(buf, 0, n);
                        len -= n;
                    }
                }
                case 6: {
                    int id = din.readInt();
                    byte[] tag = atomTable.getAtom(id);
                    cb.endTag(tag, 0, tag.length);
                    break;
                }
                case 7: {
                    return;
                }
            }
        }
    }

    public static class AtomTable {
        byte[][] atoms;
        int maxAtoms;
        int maxSize;
        int pos;
        int size;

        public AtomTable(int maxAtoms, int maxSize) {
            this.maxAtoms = maxAtoms;
            this.maxSize = maxSize;
            this.atoms = new byte[maxAtoms / 4][];
        }

        byte[] getAtom(int id) {
            if (id < this.atoms.length) {
                return this.atoms[id];
            }
            return null;
        }

        int intern(byte[] atom) {
            if (this.pos == this.maxAtoms) {
                this.pos = 0;
            }
            if ((this.size += atom.length) > this.maxSize) {
                this.pos = 0;
            }
            if (this.pos == this.atoms.length) {
                int newSize = Math.min(this.maxAtoms, 2 * this.atoms.length);
                byte[][] newAtoms = new byte[newSize][];
                System.arraycopy(this.atoms, 0, newAtoms, 0, this.atoms.length);
                this.atoms = newAtoms;
                this.pos = 0;
            }
            int id = this.pos++;
            this.atoms[id] = atom;
            return id;
        }
    }
}

