/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import net.jxta.impl.util.PendingAction;
import net.jxta.impl.util.SchedulerPriorityQueue;

public class SchedulerService
implements Runnable {
    volatile boolean done = false;
    SchedulerPriorityQueue heap = new SchedulerPriorityQueue(1024, 2);

    public synchronized Object scheduleAction(Action action, long time) {
        PendingAction el = new PendingAction(action, System.currentTimeMillis() + time);
        this.heap.put(el);
        if (this.heap.top() == el) {
            this.notify();
        }
        return el;
    }

    public synchronized void cancelAction(Object pendingAction) {
        PendingAction el = (PendingAction)pendingAction;
        el.cancel();
        if (this.heap.top() == el) {
            this.notify();
        }
    }

    public void run() {
        while (!this.done) {
            PendingAction e = this.getNextEvent();
            if (e == null || this.done) break;
            try {
                e.perform(this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private synchronized PendingAction getNextEvent() {
        if (this.done) {
            return null;
        }
        PendingAction el = (PendingAction)this.heap.top();
        long timeout = el == null ? Long.MAX_VALUE : el.time - System.currentTimeMillis();
        try {
            while (!this.done) {
                if (timeout > 0L) {
                    this.wait(timeout);
                }
                if (!this.done) {
                    if (el != this.heap.top()) {
                        el = (PendingAction)this.heap.top();
                        timeout = el.time - System.currentTimeMillis();
                        continue;
                    }
                    this.heap.pop();
                    return el;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            this.done = true;
        }
        return null;
    }

    public static interface Action {
        public void perform(SchedulerService var1);
    }
}

