/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import net.jxta.id.ID;
import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.IDFormat;
import net.jxta.impl.id.UUID.PeerGroupID;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;

public final class CodatID
extends net.jxta.codat.CodatID {
    static final int hashSize = 20;
    static final int groupIdOffset = 0;
    static final int idOffset = 16;
    static final int codatHashOffset = 32;
    static final int padOffset = 52;
    static final int padSize = 11;
    protected IDBytes id;

    private CodatID() {
        this.id = new IDBytes();
        this.id.bytes[63] = 1;
    }

    CodatID(IDBytes id) {
        this.id = id;
    }

    public CodatID(PeerGroupID groupID) {
        this();
        UUID groupUUID = new UUID(groupID.id.bytesIntoLong(0), groupID.id.bytesIntoLong(8));
        UUID idUUID = UUIDFactory.newUUID();
        this.id.longIntoBytes(0, groupUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, groupUUID.getLeastSignificantBits());
        this.id.longIntoBytes(16, idUUID.getMostSignificantBits());
        this.id.longIntoBytes(24, idUUID.getLeastSignificantBits());
    }

    public CodatID(PeerGroupID groupID, InputStream in) throws IOException {
        this(groupID);
        int nextByte;
        MessageDigest dig = null;
        try {
            dig = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException caught) {
            dig = null;
        }
        if (dig == null) {
            throw new ProviderException("SHA1 digest algorithm found");
        }
        dig.reset();
        while ((nextByte = in.read()) != -1) {
            dig.update((byte)nextByte);
        }
        in.close();
        try {
            byte[] result = dig.digest();
            int eachByte = 0;
            while (eachByte < 20) {
                this.id.bytes[eachByte + 32] = result[eachByte];
                ++eachByte;
            }
        }
        catch (Exception e) {
            throw new IOException("Digest algorithm could not complete");
        }
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof String) {
            return target.equals(this.toString());
        }
        if (target instanceof CodatID) {
            return this.id.equals(((CodatID)target).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        return this.getIDFormat() + "-" + (String)this.id.getUniqueValue();
    }

    public URL getURL() {
        return IDFormat.getURL((String)this.getUniqueValue());
    }

    public ID getPeerGroupID() {
        UUID groupUUID = new UUID(this.id.bytesIntoLong(0), this.id.bytesIntoLong(8));
        PeerGroupID groupID = new PeerGroupID(groupUUID);
        return IDFormat.translateToWellKnown(groupID);
    }

    public boolean isStatic() {
        int eachHashByte = 32;
        while (eachHashByte < 52) {
            if (0 != this.id.bytes[eachHashByte]) {
                return true;
            }
            ++eachHashByte;
        }
        return false;
    }
}

