/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jxta.document.MimeMediaType;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.endpoint.servlethttp.HttpUtil;
import net.jxta.impl.endpoint.servlethttp.QueryString;
import net.jxta.impl.relay.RelayLease;
import net.jxta.impl.relay.RelayLeaseException;
import net.jxta.impl.relay.RelayServer;
import net.jxta.impl.util.BoundedQueue;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpRelayServlet
extends HttpServlet {
    private static final int BLOCK_WAIT_TIMEOUT = 60000;
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$servlethttp$HttpRelayServlet == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpRelayServlet = HttpRelayServlet.class$("net.jxta.impl.endpoint.servlethttp.HttpRelayServlet")) : class$net$jxta$impl$endpoint$servlethttp$HttpRelayServlet).getName());
    RelayServer relay = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpRelayServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.relay = (RelayServer)this.getServletContext().getAttribute("relayServer");
            if (this.relay == null) {
                throw new ServletException("Servlet Context did not contain 'relayServer'");
            }
        }
        catch (ClassCastException e) {
            throw new ServletException("'relayServer' attribute was not of the proper type in the Servlet Context");
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String command = req.getHeader("x-jxta-command");
        String clientPeerId = req.getHeader("x-jxta-client");
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("GET received command = " + command));
            LOG.debug((Object)("  clientPeerId = " + clientPeerId));
            LOG.debug((Object)("  request length = " + req.getContentLength()));
        }
        if ("obtainLease".equals(command)) {
            RelayLease lease;
            block32: {
                if (clientPeerId == null) {
                    PeerID peerId = IDFactory.newPeerID(PeerGroupID.worldPeerGroupID);
                    clientPeerId = peerId.getUniqueValue().toString();
                }
                res.setHeader("x-jxta-relay", this.relay.getPeerID().getUniqueValue().toString());
                res.setHeader("x-jxta-client", clientPeerId);
                String leaseId = this.relay.getLeaseId(clientPeerId);
                lease = null;
                if (leaseId == null) {
                    lease = this.relay.issueNewLease(clientPeerId);
                } else {
                    try {
                        lease = this.relay.renewLease(leaseId);
                    }
                    catch (RelayLeaseException e) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) break block32;
                        LOG.debug((Object)("Lease not renewed; lease exception: " + e));
                    }
                }
            }
            if (lease != null) {
                res.setHeader("x-jxta-lease", Long.toString(lease.getLeaseLength()));
            }
            res.setStatus(200);
            res.setContentLength(0);
        } else if ("releaseLease".equals(command)) {
            String leaseId;
            if (clientPeerId == null && (leaseId = this.relay.getLeaseId(clientPeerId)) == null) {
                this.relay.removeLease(leaseId);
            }
            res.setStatus(200);
            res.setContentLength(0);
        } else if ("poll".equals(command)) {
            BoundedQueue queue;
            RelayLease lease;
            String leaseId;
            long timeout;
            block33: {
                timeout = -1L;
                try {
                    timeout = Long.parseLong(req.getHeader("x-jxta-timeout"));
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)"Could not parse timeout header", (Throwable)e);
                }
                LOG.debug((Object)("  timeout = " + timeout));
                if (clientPeerId == null) {
                    PeerID peerId = IDFactory.newPeerID(PeerGroupID.worldPeerGroupID);
                    clientPeerId = peerId.getUniqueValue().toString();
                }
                res.setHeader("x-jxta-relay", this.relay.getPeerID().getUniqueValue().toString());
                res.setHeader("x-jxta-client", clientPeerId);
                leaseId = this.relay.getLeaseId(clientPeerId);
                lease = null;
                if (leaseId == null) {
                    lease = this.relay.issueNewLease(clientPeerId);
                } else {
                    try {
                        lease = this.relay.renewLease(leaseId);
                    }
                    catch (RelayLeaseException e) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) break block33;
                        LOG.debug((Object)("Lease not renewed; lease exception: " + e));
                    }
                }
            }
            if (lease != null) {
                res.setHeader("x-jxta-lease", Long.toString(lease.getLeaseLength()));
            }
            if ((queue = this.relay.getOutboundMessageQueueByPeerId(clientPeerId)) != null) {
                MessageImpl msg;
                block34: {
                    msg = null;
                    try {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("trying to dequeue message for client " + clientPeerId));
                        }
                        msg = (MessageImpl)queue.dequeue(timeout);
                    }
                    catch (InterruptedException e) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) break block34;
                        LOG.debug((Object)"No message dequeued; sending blank 200");
                    }
                }
                if (msg != null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Relay sending message back for lease " + leaseId));
                    }
                    this.sendMessage(res, msg);
                } else {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Relay dequeued no msg, sending OK for client " + clientPeerId));
                    }
                    res.setStatus(200);
                    res.setContentLength(0);
                }
            } else {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("No queue associate with lease (probably an invalid lease for client): " + clientPeerId));
                }
                res.sendError(400, "Invalid lease specified");
            }
        } else {
            res.sendError(400, "Invalid command specified");
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block7: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"POST received");
                LOG.debug((Object)("  request length = " + req.getContentLength()));
            }
            String queryString = null;
            try {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"  try to read querystring");
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)req.getInputStream()));
                queryString = reader.readLine();
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"  done reading querystring");
                }
                if (queryString != null) {
                    this.processCommand(queryString, res);
                } else {
                    res.sendError(400, "Problem reading request");
                }
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block7;
                LOG.debug((Object)("Exception reading client request: " + e));
            }
        }
    }

    private void processCommand(String queryString, HttpServletResponse res) throws IOException {
        HashMap map = QueryString.parse(queryString);
        Object[] arr = map.keySet().toArray();
        String command = (String)map.get("command");
        if (command == null) {
            throw new IOException("query string did not contain any commands ");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("   command: " + command));
        }
        if (command.equals("block")) {
            this.processBlock(map, res);
        }
        if (command.equals("poll")) {
            this.processPoll(map, res);
        }
        if (command.equals("obtainLease")) {
            this.processObtainLease(map, res);
        }
        if (command.equals("renewLease")) {
            this.processRenewLease(map, res);
        }
    }

    private void processObtainLease(HashMap map, HttpServletResponse res) throws IOException {
        String clientPeerId = (String)map.get("peerId");
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Client trying to obtain lease: " + clientPeerId));
        }
        if (clientPeerId == null) {
            PeerID peerId = IDFactory.newPeerID(PeerGroupID.worldPeerGroupID);
            clientPeerId = peerId.getUniqueValue().toString();
        }
        RelayLease lease = this.relay.issueNewLease(clientPeerId);
        QueryString qs = this.toQueryString(lease);
        qs.add("peerId", this.relay.getPeerID().toString());
        qs.add("clientPeerId", clientPeerId);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Granting lease to client: " + clientPeerId));
        }
        this.sendOK(res, qs.toString());
    }

    private void processRenewLease(HashMap map, HttpServletResponse res) throws IOException {
        String leaseId = (String)map.get("leaseId");
        if (leaseId == null) {
            throw new IOException("query string did not contain a leaseId ");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Renewing lease; old lease id: " + leaseId));
        }
        if (leaseId != null) {
            try {
                RelayLease lease = this.relay.renewLease(leaseId);
                QueryString qs = this.toQueryString(lease);
                qs.add("peerId", this.relay.getPeerID().toString());
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Renewed lease; response=" + qs.toString()));
                }
                this.sendOK(res, qs.toString());
            }
            catch (RelayLeaseException e) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Lease not renewed; lease exception: " + e));
                }
                this.sendBadRequest(res, e.getMessage());
            }
        } else {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Lease not renewed; leaseId not specified");
            }
            this.sendBadRequest(res, "leaseId not specified");
        }
    }

    private void processBlock(HashMap map, HttpServletResponse res) throws IOException {
        String leaseId = (String)map.get("leaseId");
        if (leaseId == null) {
            throw new IOException("query string did not contain a leaseId ");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("processBlock() for lease " + leaseId));
        }
        if (leaseId != null) {
            BoundedQueue queue = this.relay.getOutboundMessageQueueByLeaseId(leaseId);
            if (queue != null) {
                MessageImpl msg = null;
                try {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("trying to dequeue message for lease " + leaseId));
                    }
                    msg = (MessageImpl)queue.dequeue(60000L);
                }
                catch (InterruptedException e) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"No message dequeued; sending blank 200");
                    }
                    this.sendOK(res);
                }
                if (msg != null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Relay sending message back for lease " + leaseId));
                    }
                    this.sendMessage(res, msg);
                } else {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Relay dequeued no msg, sending OK for lease " + leaseId));
                    }
                    this.sendOK(res);
                }
            } else {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("No queue associate with lease (probably an invalid lease): " + leaseId));
                }
                this.sendBadRequest(res, "Invalid lease specified");
            }
        } else {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"No lease specified");
            }
            this.sendBadRequest(res, "No lease specified");
        }
    }

    private void processPoll(HashMap map, HttpServletResponse res) throws IOException {
        String leaseId = (String)map.get("leaseId");
        if (leaseId == null) {
            throw new IOException("query string did not contain a leaseId ");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("processBlock() for lease " + leaseId));
        }
        if (leaseId != null) {
            BoundedQueue queue = this.relay.getOutboundMessageQueueByLeaseId(leaseId);
            if (queue != null) {
                MessageImpl msg = null;
                try {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("trying to dequeue message for lease " + leaseId));
                    }
                    msg = (MessageImpl)queue.dequeue(-1L);
                }
                catch (InterruptedException e) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"No message dequeued; sending blank 200");
                    }
                    this.sendOK(res);
                }
                if (msg != null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Relay sending message back for lease " + leaseId));
                    }
                    this.sendMessage(res, msg);
                } else {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Relay dequeued no msg, sending OK for lease " + leaseId));
                    }
                    this.sendOK(res);
                }
            } else {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("No queue associate with lease (probably an invalid lease): " + leaseId));
                }
                this.sendBadRequest(res, "Invalid lease specified");
            }
        } else {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"No lease specified");
            }
            this.sendBadRequest(res, "No lease specified");
        }
    }

    private void sendBadRequest(HttpServletResponse res, String msg) throws IOException {
        res.sendError(400, msg);
    }

    private void sendMessage(HttpServletResponse res, MessageImpl msg) throws IOException {
        res.setStatus(200);
        ByteArrayOutputStream tmpOut = new ByteArrayOutputStream();
        MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("application/x-jxta-msg")).writeMessage(tmpOut, msg);
        res.setContentLength(tmpOut.size());
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("sendMessage() preparing; content-length = " + tmpOut.size()));
        }
        ByteArrayInputStream in = new ByteArrayInputStream(tmpOut.toByteArray());
        ServletOutputStream out = res.getOutputStream();
        HttpUtil.transfer(in, (OutputStream)out);
        out.flush();
        out.close();
    }

    private void sendOK(HttpServletResponse res, String body) throws IOException {
        res.setStatus(200);
        byte[] buf = (body + "\r\n").getBytes();
        res.setContentLength(buf.length);
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream());
        ((OutputStream)out).write(buf);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
    }

    private void sendOK(HttpServletResponse res) throws IOException {
        res.setStatus(200);
        res.setContentLength(0);
    }

    private QueryString toQueryString(RelayLease lease) {
        QueryString query = new QueryString();
        query.add("leaseLength", Integer.toString(lease.getLeaseLength()));
        query.add("leaseId", lease.getLeaseId());
        return query;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

