/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.endpoint.http.HttpTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpServerMessenger
implements EndpointMessenger {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$http$HttpServerMessenger == null ? (class$net$jxta$impl$endpoint$http$HttpServerMessenger = HttpServerMessenger.class$("net.jxta.impl.endpoint.http.HttpServerMessenger")) : class$net$jxta$impl$endpoint$http$HttpServerMessenger).getName());
    private EndpointAddress srcAddress = null;
    private EndpointAddress dstAddress = null;
    private HttpTransport proto = null;
    private String clientId = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$http$HttpServerMessenger;

    public HttpServerMessenger(EndpointAddress destAddr, HttpTransport tpt) throws IOException {
        if (destAddr == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"destination address is null");
            }
            throw new IllegalArgumentException("destination address is null");
        }
        this.proto = tpt;
        this.dstAddress = (EndpointAddress)destAddr.clone();
        this.srcAddress = this.proto.getPublicAddress();
        this.clientId = destAddr.getProtocolAddress().substring("JxtaHttpClient".length());
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"Creating object for:");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("    client = " + this.clientId));
        }
    }

    public void sendMessage(Message message) throws IOException {
        message.setSourceAddress(this.srcAddress);
        message.setDestinationAddress(this.dstAddress);
        Vector<byte[]> msgBuffers = new Vector<byte[]>();
        int msgSize = 0;
        try {
            byte[] nextBuffer;
            int readLength;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("text/xml")).writeMessage(baos, message);
            baos.close();
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            int bufferSize = 4096;
            while ((readLength = inputStream.read(nextBuffer = new byte[4096])) != -1) {
                if (readLength == 0) continue;
                if (readLength < 4096) {
                    byte[] anotherBuffer = new byte[readLength];
                    System.arraycopy(nextBuffer, 0, anotherBuffer, 0, readLength);
                    nextBuffer = anotherBuffer;
                }
                msgSize += nextBuffer.length;
                msgBuffers.addElement(nextBuffer);
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"HTTP - send - cannot read outgoing message", (Throwable)e);
            }
            throw new IOException("HTTP - send - cannot read outgoing message");
        }
        this.proto.server.sendMessageToClient(this.clientId, msgBuffers, msgSize);
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

