/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Vector;
import net.jxta.impl.endpoint.http.HttpMessage;
import net.jxta.impl.endpoint.http.HttpTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

class HttpServer
extends Thread {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$http$HttpServer == null ? (class$net$jxta$impl$endpoint$http$HttpServer = HttpServer.class$("net.jxta.impl.endpoint.http.HttpServer")) : class$net$jxta$impl$endpoint$http$HttpServer).getName());
    public static final int MaxCnxBacklog = 50;
    private HttpTransport owner;
    private UnicastThreadPool unicastPool;
    private ServerSocket serverSocket;
    private HashMap clientConnections;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$http$HttpServer;

    public HttpServer(ThreadGroup inGroup, HttpTransport owner, InetAddress usingInterface, int serverSocketPort) {
        block6: {
            super(inGroup, null, "Server Listener");
            this.owner = null;
            this.unicastPool = null;
            this.clientConnections = new HashMap();
            this.owner = owner;
            this.unicastPool = new UnicastThreadPool();
            this.unicastPool.createThreads();
            try {
                this.serverSocket = new ServerSocket(serverSocketPort, 50, usingInterface);
            }
            catch (BindException e0) {
                if (LOG.isEnabledFor(Priority.FATAL)) {
                    LOG.fatal((Object)("[1] Cannot bind ServerSocket on port: " + serverSocketPort + " because port is in use or disallowed."));
                }
            }
            catch (IOException e1) {
                if (LOG.isEnabledFor(Priority.FATAL)) {
                    LOG.fatal((Object)("[1] Canot create ServerSocket on port " + serverSocketPort), (Throwable)e1);
                }
            }
            catch (SecurityException e2) {
                if (!LOG.isEnabledFor(Priority.FATAL)) break block6;
                LOG.fatal((Object)("[1] Canot create ServerSocket on port " + serverSocketPort), (Throwable)e2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Server is ready to receive request");
            }
            while (true) {
                try {
                    while (true) {
                        Socket inputSocket;
                        IncomingUnicastThread willUse;
                        block15: {
                            if (null == (willUse = this.unicastPool.getIncomingThread(0L))) {
                                continue;
                            }
                            inputSocket = this.serverSocket.accept();
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)(inputSocket.getInetAddress().getHostAddress() + ":" + inputSocket.getPort() + " connected on " + willUse.getName()));
                            }
                            try {
                                inputSocket.setSoLinger(true, 30000);
                                inputSocket.setSoTimeout(30000);
                            }
                            catch (Exception e) {
                                if (!LOG.isEnabledFor(Priority.DEBUG)) break block15;
                                LOG.debug((Object)"setting socket options failed ", (Throwable)e);
                            }
                        }
                        IncomingUnicastThread incomingUnicastThread = willUse;
                        synchronized (incomingUnicastThread) {
                            willUse.setSocket(inputSocket);
                            willUse.notify();
                        }
                    }
                }
                catch (IOException e1) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)("[1] ServerSocket.accept() on port " + this.serverSocket.getLocalPort() + " has failed."), (Throwable)e1);
                }
                catch (SecurityException e2) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)("[2] ServerSocket.accept() on port " + this.serverSocket.getLocalPort() + " has failed."), (Throwable)e2);
                }
            }
        }
        catch (Throwable all) {
            if (LOG.isEnabledFor(Priority.FATAL)) {
                LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
            }
            return;
        }
    }

    synchronized boolean addClientConnection(String clientId, Socket socket, InputStream is, OutputStream os) {
        ClientConnection old;
        ClientConnection client = new ClientConnection(clientId, socket, is, os);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Adding new client connection for " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort() + (null != is ? " I " : "   ") + (null != os ? " O " : "   ")));
        }
        if (null != (old = this.clientConnections.put(clientId, client))) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Closing previous connection to client");
            }
            old.close();
        }
        return null == old;
    }

    synchronized ClientConnection getClientConnection(String clientId) {
        ClientConnection result = (ClientConnection)this.clientConnections.remove(clientId);
        return result;
    }

    void sendMessageToClient(String clientId, Vector buffers, long len) {
        block10: {
            ClientConnection client;
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"sendMessageToClient");
            }
            if ((client = this.getClientConnection(clientId)) != null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"  Using client connection");
                }
                String docstart = "<Code>" + Integer.toString(4) + "</" + "Code" + ">" + "<" + "Msg" + ">\n";
                String docend = "</Msg>";
                try {
                    buffers.insertElementAt(docstart.getBytes(), 0);
                    buffers.addElement(docend.getBytes());
                }
                catch (Exception ex) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"sendMessageToClient failed ", (Throwable)ex);
                    }
                    return;
                }
                client.sendToClient(buffers, len + (long)docstart.length() + (long)docend.length());
            } else {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("   Storing into the spooler for " + clientId));
                }
                try {
                    String dn = this.owner.HttpSpool + File.separatorChar + clientId;
                    String fn = HttpTransport.cm.createTmpName(dn);
                    HttpMessage httpMsg = new HttpMessage(dn, fn, buffers);
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block10;
                    LOG.warn((Object)"sendMessageToClient: failed to spool message", (Throwable)e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ClientConnection {
        private String clientId = null;
        public Socket inputSocket = null;
        public InputStream inputStream = null;
        public OutputStream outputStream = null;

        ClientConnection(String clientId, Socket inputSocket, InputStream inputStream, OutputStream outputStream) {
            this.clientId = clientId;
            this.inputSocket = inputSocket;
            this.inputStream = inputStream;
            this.outputStream = outputStream;
        }

        public void sendToClient(Vector buffers, long len) {
            block13: {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"sendToClient begins");
                }
                if (this.outputStream == null && this.inputSocket != null) {
                    try {
                        this.outputStream = this.inputSocket.getOutputStream();
                    }
                    catch (IOException e) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) break block13;
                        LOG.debug((Object)"failed to get outputstream for socket", (Throwable)e);
                    }
                }
            }
            if (this.outputStream == null) {
                String dn = ((HttpServer)HttpServer.this).owner.HttpSpool + File.separatorChar + this.clientId;
                HttpServer.this.owner;
                String fn = HttpTransport.cm.createTmpName(dn);
                try {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"sendToClient: spooling message ");
                    }
                    Vector<ByteArrayInputStream> streamParts = new Vector<ByteArrayInputStream>();
                    int i = 0;
                    while (i < buffers.size()) {
                        streamParts.addElement(new ByteArrayInputStream((byte[])buffers.elementAt(i)));
                        ++i;
                    }
                    SequenceInputStream combined = new SequenceInputStream(streamParts.elements());
                    HttpServer.this.owner;
                    HttpTransport.cm.saveBytes(dn, fn, combined);
                }
                catch (Exception e) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"sendToClient failed spooling a message", (Throwable)e);
                    }
                }
            } else {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Sending response on waiting socket to " + this.inputSocket.getInetAddress().getHostAddress() + ":" + this.inputSocket.getPort()));
                }
                HttpTransport.sendResponse(this.outputStream, buffers, len);
                this.close();
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"sendToClient finished");
            }
        }

        public void close() {
            HttpTransport.closeSocket(this.inputSocket, this.inputStream, this.outputStream);
            this.clientId = null;
            this.inputSocket = null;
            this.inputStream = null;
            this.outputStream = null;
        }

        protected void finalize() {
            this.close();
        }
    }

    class IncomingUnicastThread
    extends Thread {
        HttpTransport tp = null;
        Socket socket = null;

        private IncomingUnicastThread(String name) {
            super(HttpServer.this.getThreadGroup(), null, "incoming unicast " + name);
        }

        void setSocket(Socket theSocket) {
            this.socket = theSocket;
        }

        public void run() {
            block8: {
                try {
                    IncomingUnicastThread incomingUnicastThread = this;
                    synchronized (incomingUnicastThread) {
                        while (true) {
                            HttpServer.this.unicastPool.availableThread(this);
                            try {
                                this.wait();
                            }
                            catch (InterruptedException woken) {
                                Thread.interrupted();
                            }
                            if (null == this.socket) break;
                            HttpServer.this.owner.runReceive(this.socket);
                            this.socket = null;
                        }
                    }
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor(Priority.FATAL)) break block8;
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
            }
            HttpServer.this.unicastPool.threadDied(this);
        }
    }

    class UnicastThreadPool {
        public static final int DefaultNbOfUnicastThreads = 5;
        public static final int MaxNbOfUnicastThreads = 25;
        private volatile int unicastThreads = 0;
        private volatile int unicastThreadNumber = 0;
        private Vector threadPool = new Vector(25);

        public void createThreads() {
            this.createThreads(5);
        }

        public void createThreads(int initialNumber) {
            initialNumber = Math.min(initialNumber, 25);
            int i = 1;
            while (i <= initialNumber) {
                this.newIncomingThread();
                ++i;
            }
        }

        private void newIncomingThread() {
            Vector vector = this.threadPool;
            synchronized (vector) {
                ++this.unicastThreads;
                new IncomingUnicastThread(Integer.toString(++this.unicastThreadNumber)).start();
            }
        }

        IncomingUnicastThread getIncomingThread(long timeOut) throws InterruptedException {
            IncomingUnicastThread willUse = null;
            long realTimeOut = System.currentTimeMillis() + timeOut;
            while (true) {
                Vector vector = this.threadPool;
                synchronized (vector) {
                    if (this.threadPool.size() > 0) {
                        willUse = (IncomingUnicastThread)this.threadPool.lastElement();
                        this.threadPool.removeElementAt(this.threadPool.size() - 1);
                        break;
                    }
                    if (this.unicastThreads < 25) {
                        this.newIncomingThread();
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("Made a new unicast thread (#" + this.unicastThreadNumber + " of " + this.unicastThreads + " total)"));
                        }
                    }
                    this.threadPool.wait(timeOut);
                    if (this.threadPool.size() > 0) {
                        willUse = (IncomingUnicastThread)this.threadPool.lastElement();
                        this.threadPool.removeElementAt(this.threadPool.size() - 1);
                        break;
                    }
                    if (0L != timeOut && (timeOut = realTimeOut - System.currentTimeMillis()) <= 0L) {
                        break;
                    }
                }
            }
            return willUse;
        }

        public void availableThread(IncomingUnicastThread theThread) {
            Vector vector = this.threadPool;
            synchronized (vector) {
                this.threadPool.addElement(theThread);
                this.threadPool.notify();
            }
        }

        public void threadDied(IncomingUnicastThread theThread) {
            Vector vector = this.threadPool;
            synchronized (vector) {
                --this.unicastThreads;
                this.threadPool.removeElement(theThread);
            }
        }
    }
}

