/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import net.jxta.impl.cm.PriorityQueue;

public class SchedulerService
implements Runnable {
    volatile boolean done = false;
    SchedulerPriorityQueue heap = new SchedulerPriorityQueue(1024, 2);

    public synchronized PendingAction scheduleAction(Action action, long timeout) {
        PendingAction el = null;
        if (timeout >= 0L) {
            el = new PendingAction(action, System.currentTimeMillis() + timeout);
            this.heap.put(el);
            if (this.heap.top() == el) {
                this.notify();
            }
        }
        return el;
    }

    private synchronized void doCancel(PendingAction pendingAction) {
        pendingAction.cancel();
        if (this.heap.top() == pendingAction) {
            this.notify();
        }
    }

    public void cancelAction(PendingAction pendingAction) {
        this.doCancel(pendingAction);
        pendingAction.noPerform();
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        while (!this.done) {
            PendingAction e = this.getNextEvent();
            if (this.done) break;
            try {
                e.perform(this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Thread.yield();
        }
    }

    private synchronized PendingAction getNextEvent() {
        if (this.done) {
            return null;
        }
        PendingAction el = (PendingAction)this.heap.top();
        long timeout = el == null ? Long.MAX_VALUE : el.time - System.currentTimeMillis();
        try {
            while (!this.done) {
                if (timeout > 0L) {
                    this.wait(timeout);
                }
                if (!this.done) {
                    if (el != this.heap.top()) {
                        el = (PendingAction)this.heap.top();
                        timeout = el.time - System.currentTimeMillis();
                        continue;
                    }
                    this.heap.pop();
                    el.nonCancelable();
                    return el;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            this.done = true;
        }
        return null;
    }

    public static interface Action {
        public void perform(SchedulerService var1);
    }

    class SchedulerPriorityQueue
    extends PriorityQueue {
        SchedulerPriorityQueue(int heapSize, int increase) {
            super.initialize(heapSize, increase);
        }

        protected boolean lessThan(Object o1, Object o2) {
            PendingAction a1 = (PendingAction)o1;
            PendingAction a2 = (PendingAction)o2;
            return a1.time < a2.time;
        }
    }

    public class PendingAction {
        Action action;
        boolean cancelable = true;
        long time;

        PendingAction(Action action, long time) {
            this.action = action;
            this.time = time;
        }

        public long getTime() {
            return this.time;
        }

        void perform(SchedulerService ss) {
            if (this.action != null) {
                PendingAction pendingAction;
                try {
                    this.action.perform(ss);
                    Object var3_2 = null;
                    pendingAction = this;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    PendingAction pendingAction2 = this;
                    synchronized (pendingAction2) {
                        this.action = null;
                        this.notifyAll();
                    }
                    throw throwable;
                }
                synchronized (pendingAction) {
                    this.action = null;
                    this.notifyAll();
                }
            }
        }

        void nonCancelable() {
            this.cancelable = false;
        }

        void cancel() {
            if (this.cancelable) {
                this.action = null;
            }
        }

        synchronized void noPerform() {
            try {
                while (this.action != null) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

