/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.document;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.MissingResourceException;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.util.ClassFactory;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public final class StructuredDocumentFactory
extends ClassFactory {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$document$StructuredDocumentFactory == null ? (class$net$jxta$document$StructuredDocumentFactory = StructuredDocumentFactory.class$("net.jxta.document.StructuredDocumentFactory")) : class$net$jxta$document$StructuredDocumentFactory).getName());
    private static StructuredDocumentFactory factory = new StructuredDocumentFactory();
    private Hashtable encodings = new Hashtable();
    private HashMap extToMime = new HashMap();
    private HashMap mimeToExt = new HashMap();
    private boolean loadedProperty = false;
    static /* synthetic */ Class class$net$jxta$document$StructuredDocumentFactory;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$net$jxta$document$StructuredDocumentFactory$Instantiator;

    private StructuredDocumentFactory() {
    }

    private boolean doLoadProperty() {
        try {
            return this.registerFromResources("net.jxta.impl.config", "StructuredDocumentInstanceTypes");
        }
        catch (MissingResourceException notFound) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"Could not find net.jxta.impl.config properties file!");
            }
            return false;
        }
    }

    protected Hashtable getAssocTable() {
        return this.encodings;
    }

    protected Class getClassForKey() {
        return class$java$lang$String == null ? (class$java$lang$String = StructuredDocumentFactory.class$("java.lang.String")) : class$java$lang$String;
    }

    protected Class getClassOfInstantiators() {
        return class$net$jxta$document$StructuredDocumentFactory$Instantiator == null ? (class$net$jxta$document$StructuredDocumentFactory$Instantiator = StructuredDocumentFactory.class$("net.jxta.document.StructuredDocumentFactory$Instantiator")) : class$net$jxta$document$StructuredDocumentFactory$Instantiator;
    }

    protected boolean registerAssoc(String className) {
        boolean registeredSomething;
        block3: {
            registeredSomething = false;
            try {
                Class<?> docClass = Class.forName(className);
                Instantiator instantiator = (Instantiator)docClass.getField("INSTANTIATOR").get(null);
                MimeMediaType[] mimeTypes = instantiator.getSupportedMimeTypes();
                int eachType = 0;
                while (eachType < mimeTypes.length) {
                    registeredSomething |= StructuredDocumentFactory.registerInstantiator(mimeTypes[eachType], instantiator);
                    ++eachType;
                }
            }
            catch (Exception all) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block3;
                LOG.warn((Object)("Failed to register '" + className + "'"), (Throwable)all);
            }
        }
        return registeredSomething;
    }

    public static String getFileExtensionForMimeType(MimeMediaType mimetype) {
        return (String)StructuredDocumentFactory.factory.mimeToExt.get(mimetype.getMimeMediaType());
    }

    public static MimeMediaType getMimeTypeForFileExtension(String extension) {
        MimeMediaType result = null;
        String fromMap = (String)StructuredDocumentFactory.factory.extToMime.get(extension);
        if (null != fromMap) {
            result = new MimeMediaType(fromMap);
        }
        return result;
    }

    public static boolean registerInstantiator(MimeMediaType mimetype, Instantiator instantiator) {
        boolean registered = factory.registerAssoc(mimetype.getMimeMediaType(), instantiator);
        if (registered) {
            Instantiator.ExtensionMapping[] extensions = instantiator.getSupportedFileExtensions();
            int eachExt = 0;
            while (eachExt < extensions.length) {
                if (null != extensions[eachExt].getMimeMediaType()) {
                    StructuredDocumentFactory.factory.extToMime.put(extensions[eachExt].getExtension(), extensions[eachExt].getMimeMediaType().getMimeMediaType());
                    StructuredDocumentFactory.factory.mimeToExt.put(extensions[eachExt].getMimeMediaType().getMimeMediaType(), extensions[eachExt].getExtension());
                }
                ++eachExt;
            }
        }
        return registered;
    }

    public static StructuredDocument newStructuredDocument(MimeMediaType mimetype, String doctype) {
        if (!StructuredDocumentFactory.factory.loadedProperty) {
            StructuredDocumentFactory.factory.loadedProperty = factory.doLoadProperty();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(mimetype.getMimeMediaType());
        return instantiator.newInstance(mimetype, doctype);
    }

    public static StructuredDocument newStructuredDocument(MimeMediaType mimetype, String doctype, String value) {
        if (!StructuredDocumentFactory.factory.loadedProperty) {
            StructuredDocumentFactory.factory.loadedProperty = factory.doLoadProperty();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(mimetype.getMimeMediaType());
        return instantiator.newInstance(mimetype, doctype, value);
    }

    public static StructuredDocument newStructuredDocument(MimeMediaType mimetype, InputStream stream) throws IOException {
        if (!StructuredDocumentFactory.factory.loadedProperty) {
            StructuredDocumentFactory.factory.loadedProperty = factory.doLoadProperty();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(mimetype.getMimeMediaType());
        return instantiator.newInstance(mimetype, stream);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Instantiator {
        public MimeMediaType[] getSupportedMimeTypes();

        public ExtensionMapping[] getSupportedFileExtensions();

        public StructuredDocument newInstance(MimeMediaType var1, String var2);

        public StructuredDocument newInstance(MimeMediaType var1, String var2, String var3);

        public StructuredDocument newInstance(MimeMediaType var1, InputStream var2) throws IOException;

        public static class ExtensionMapping {
            String extension;
            MimeMediaType mimetype;

            private ExtensionMapping() {
            }

            public ExtensionMapping(String extension, MimeMediaType mimetype) {
                this.extension = extension;
                this.mimetype = mimetype;
            }

            protected Object clone() {
                return this;
            }

            public boolean equals(Object target) {
                if (this == target) {
                    return true;
                }
                if (target instanceof ExtensionMapping) {
                    ExtensionMapping asMapping = (ExtensionMapping)target;
                    return this.extension.equals(asMapping.extension) && this.mimetype.equals(asMapping.mimetype);
                }
                return false;
            }

            public int hascode() {
                return this.extension.hashCode() ^ this.mimetype.hashCode();
            }

            public String toString() {
                return this.extension.toString() + " -> " + this.mimetype.toString();
            }

            public String getExtension() {
                return this.extension;
            }

            public MimeMediaType getMimeMediaType() {
                return this.mimetype;
            }
        }
    }
}

