<?xml version="1.0"?> 

<!--

$Id: mozilla.xsl,v 1.9 2002/01/30 07:19:19 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:dc="http://purl.org/metadata/dublin_core#"
                xmlns:dce="http://purl.org/dc/elements/1.1/" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:ocs="http://alchemy.openjava.org/ocs/directory#"
                xmlns:channels="http://schemas.openprivacy.org/content/syndication/channels"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:functions="xalan://org.openprivacy.reptile.extensions.Functions"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                extension-element-prefixes="functions"
                exclude-result-prefixes=""
                version="1.0">

    <xsl:output indent="yes"
                omit-xml-declaration="yes"/>                

    <!-- declare all parameters and provide default values -->
    <xsl:param name="reptile.home.location" select="''"/>
    <xsl:param name="reptile.current.location" select="''"/>
    <xsl:param name="reptile.current.sequence.name" select="''"/>
    <xsl:param name="reptile.syndication.channels.param.select-channel" select="''"/> 

    <xsl:template match="/channels:channels">

        <control:content>
    
            <dce:title>View channels</dce:title>
    
            <dce:description>Select channels</dce:description>
    
            <control:body>
    
            <div align="center">
    
            <p>
            Select a channel you wish to view:        
            </p>
    
            <form action="{$reptile.current.location}">
    
            <select name="reptile.syndication.channels.param.select-channel" size="5">
    
                <xsl:apply-templates select="./channels:list"/>
    
            </select>
    
            <br/>
    
            <input type="submit" value="View Channel"/>
    
            <input type="hidden" name="reptile.sequence.name" value="{$reptile.current.sequence.name}"/>
    
            </form>
    
            <br/>
            <hr/>
            
            <form action="{$reptile.current.location}">
    
            <table>
    
            <td>
            Search: 
            </td>
    
            <td>
            <input type="text" name="reptile.syndication.channels.param.select-channel"/>
            </td>
    
            <td>
            <input type="submit" value="Search"/>
            </td>
    
            </table>
    
            <input type="hidden" name="reptile.sequence.name" value="{$reptile.current.sequence.name}"/>
    
            </form>
    
            </div>
    
            <xsl:if test="$reptile.syndication.channels.param.select-channel != ''">
            
                 <br/>
            
                 <hr/>
    
                 <p>
                 Results for search: '<xsl:value-of select="$reptile.syndication.channels.param.select-channel"/>'
                 </p>
    
                 <xsl:apply-templates select="channels:search"/>
    
            </xsl:if>
    
            </control:body>

        </control:content>

    </xsl:template>

    <xsl:template match="channels:entry">

        <option>
            
        <xsl:attribute name="value">

            <xsl:value-of select="./dc:title"/>

        </xsl:attribute>
            
        <xsl:value-of select="./dc:title"/>

        </option>

    </xsl:template>

    <xsl:template match="channels:result">

        <p>
        
        Channel: 


        <link-producer:channel-management location="{ ./channels:location }" 
                                contentType="{ ./ocs:format }"
                                name="{ ./channels:location }" />

        <br/>
        Format: <xsl:value-of select="./ocs:format"/>

        </p>

    </xsl:template>


</xsl:stylesheet>

