<?xml version="1.0"?> 

<!--

$Id: rss-1.0.xsl,v 1.59 2002/02/27 08:50:53 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

This stylesheet is designed to render RSS 1.0 content.

http://groups.yahoo.com/group/rss-dev/files/namespace.html

http://groups.yahoo.com/group/rss-dev/files/specification.html

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:rss="http://purl.org/rss/1.0/"
                xmlns:im="http://purl.org/rss/1.0/item-images/" 
                xmlns:record="http://records.sourceforge.net/schemas/rss-meta-module/"
                xmlns:xhtml="http://www.w3.org/1999/xhtml" 
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:logo-producer="http://schemas.openprivacy.org/reptile/logo-producer"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:reputation="xalan://org.openprivacy.reptile.extensions.ReputationExtension"
                xmlns:elp="xalan://org.openprivacy.reptile.extensions.LinkProducer"
                xmlns:marks="xalan://org.openprivacy.reptile.extensions.Marks"
                xmlns:shown-count="xalan://org.openprivacy.reptile.extensions.ShownCount"
                xmlns:valid-item="xalan://org.openprivacy.reptile.extensions.ValidItem"
                xmlns:image="xalan://org.openprivacy.reptile.extensions.ImageExtension"
                xmlns:weblog="xalan://org.openprivacy.reptile.extensions.Weblog"
                xmlns:article="xalan://org.openprivacy.reptile.extensions.om.ArticleExtension"
                xmlns:escape="xalan://org.openprivacy.reptile.extensions.EscapeExtension"
                xmlns:meta-update="xalan://org.openprivacy.reptile.metaupdate.extensions.MetaUpdateExtension"
                xmlns:setting-extension="xalan://org.openprivacy.reptile.extensions.om.SettingExtension"
                extension-element-prefixes="marks shown-count valid-item image reputation elp weblog article escape meta-update setting-extension"
                exclude-result-prefixes="rdf dc rss im record xhtml"
                version="1.0">

    <xsl:output indent="yes" 
                encoding="ISO-8859-1"
                omit-xml-declaration="yes"/>                

    <xsl:param name="reptile.home.location" select="''"/>

    <xsl:param name="reptile.content.location" select="''"/>
    <xsl:param name="reptile.content.type" select="''"/>

    <xsl:template match="/rdf:RDF">

        <meta-update:channel location="{$reptile.content.location}"
                             site="{rss:channel/rss:link}"
                             contentType="{$reptile.content.type}"
                             title="{rss:channel/rss:title}"
                             description="{rss:channel/rss:description}"/>

        <control:content help="channel">
            
            <control:link><xsl:value-of select="./rss:channel/rss:link"/></control:link>
            
            <dc:title><xsl:value-of select="./rss:channel/rss:title"/></dc:title>
            
            <dc:description><xsl:value-of select="./rss:channel/rss:description"/></dc:description>
            
            <control:body>

                <!-- We need a way to reset the reptile.link everytime we view a
                page.  This is kind of a kludge but it works. -->
                <script language="javascript">

                    setCookie( 'reptile.link', '' );
                    
                </script>
                
                <xsl:apply-templates select="./rss:channel/rss:image"/>

                <form action="{$reptile.home.location}"
                      method="post"
                      id="form_{$reptile.content.location}">

                    <xsl:apply-templates select="./rss:item"/>

                </form>
                
                <xsl:apply-templates select="./rss:textinput"/>

            </control:body>
            
            <control:shownCount><xsl:value-of select="shown-count:get()"/></control:shownCount>

            <control:feature name="urn:reptile/channel/feature/read-marks"/>
                
        </control:content>

    </xsl:template>

    <xsl:template match="/rdf:RDF/rss:channel/rss:image">

        <meta-update:image channel="{$reptile.content.location}"
                           site="{../rss:link}"
                           url="{rss:url}"
                           title="{rss:title}"
                           description="{rss:description}"/>

        <!-- <a href="{./rss:link}" alt="{./rss:title}" target="setting-extension:value( 'reptile.setting.href-target' )"> -->
        
        <img src="{image:link( ./rss:url )}"
             alt="{./rss:title}"
             align="right"
             border="0"
             hspace="10"
             vspace="10"/>

            <!-- A lot of companies (CNN) don't give correct values for
                 image height and width. We are not going to use it.  -->

    </xsl:template>

    <xsl:template match="/rdf:RDF/rss:item/im:image">

        <img src="{.}" align="right" hspace="10" vspace="10"/>
        
    </xsl:template>

    <!-- handle RSS items -->
    <xsl:template match="/rdf:RDF/rss:item">

        <!-- go ahead and do a meta-update here.  doesn't take long -->
        
        <meta-update:article location="{rss:link}"
                             title="{rss:title}"
                             description="{rss:description}"
                             channel="{$reptile.content.location}"/>

        <xsl:variable name="location">

            <xsl:value-of select="./rss:link"/>

        </xsl:variable>

        <xsl:if test="valid-item:isValid( ./rss:link, ./rss:title ) and
                      ( marks:isRead( string( $location ) ) = false or
                      setting-extension:test( 'reptile.setting.channel.handle-read-links', 'normal-face' ) )">

            <shown-count:increment/>

            <table cellspacing="0" cellpadding="0">

                <tr>
            
                    <td valign="middle" align="center">

                        <link-producer:favicon site="{rss:link}" 
                                               contentType="asdf" 
                                               location="{rss:link}"
                                               name="{ escape:attributes( ./dc:title ) }"/>
                    </td>

                    <td valign="middle" width="100%">

                        <a href="{rss:link}" target="setting-extension:value( 'reptile.setting.href-target' )">

                            <!-- determine if this item should be the unread class or the read class -->
                            
                            <xsl:choose>

                                <xsl:when test="marks:isRead( string( $location ) )">
                                    
                                    <xsl:attribute name="class">reptile-read-item</xsl:attribute>
                                    
                                </xsl:when>

                                <xsl:otherwise>

                                    <xsl:attribute name="class">reptile-unread-item</xsl:attribute>

                                </xsl:otherwise>
                                
                            </xsl:choose>                                     

                            <xsl:value-of select="./rss:title"/>
                            
                        </a>

                    </td>

                </tr>

                <tr>

                    <td valign="middle" align="center">

                        <input type="radio" 
                               class="reptile-rss-item" 
                               name="reptile.link"
                               value="{rss:link}"
                               onClick="setCookie( 'reptile.link', this.value )"/>
                    </td>            

                    <td class="reptile-rss-timestamp">

                        <xsl:value-of select="article:getDateFound( rss:link )"/>

                    </td>                    

                </tr>

            </table>

            <xsl:choose>

                <xsl:when test="string-length( ./rss:description ) > 0">

                    <p class="reptile-rss-paragraph">

                    <!-- OK.  how could we do this.  Here we have the problem of -->
                    
                    <xsl:value-of select="./rss:description"/>

                    </p>
                    
                </xsl:when>

                <xsl:otherwise>

                    <br/>

                </xsl:otherwise>

            </xsl:choose>

            <xsl:apply-templates select="dc:subject"/>

            <xsl:apply-templates select="rss:comment"/>
            
        </xsl:if>

    </xsl:template>

    <xsl:template match="rss:comment">

        <p class="reptile-rss-comment">

            <xsl:value-of select="."/>
        
        </p>

    </xsl:template>

    <xsl:template match="/rdf:RDF/rss:item/dc:subject">

<!--         <b>Subject: </b> <xsl:value-of select="."/> -->
<!--         <br/> -->

    </xsl:template>    

    <!-- RSS forms -->
    <xsl:template match="rss:textinput">

        <div align="center">
    
        <form action="{./rss:link}" method="get">

        <b>
        <xsl:value-of select="./rss:description"/>
        </b>        

        <table>

        <td>

        <input type="text" name="{./rss:name}"/>

        </td>

        <td>

        <input type="submit" name="Search"/>

        </td>

        </table>
        
        </form>

        </div>

    </xsl:template>    

    <xsl:template name="get-reputation">

        <xsl:param name="identifier"/>

        <elp:newLink/>
                  
        <elp:value name="reptile.sequence.name" value="urn:reputation-management"/>

        <elp:value name="identifier" value="{$identifier}"/>

        <tr>

            <td align="center" valign="middle">

                <img src="/reptile/images/reputation.png" border="0"/>

            </td>            

            <td nowrap="true" valign="middle">

                <a href="{elp:getLink()}">Reputation: </a>

                <xsl:value-of select="reputation:getReputation( string( $identifier ) )"/>

            </td>

        </tr>

    </xsl:template>

    <xsl:template match="/rdf:RDF/rss:channel"/>
    <xsl:template match="/rdf:RDF/rss:item/rss:title"/>

</xsl:stylesheet>
