<?xml version="1.0"?> 

<!--

$Id: search-uplevel.xsl,v 1.4 2001/12/17 10:06:47 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

This stylesheet is designed to render reptile search search-results into an RSS 1.0
format.

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:rss="http://purl.org/rss/1.0/"
                xmlns:search-results="http://schemas.openprivacy.org/reptile/search-results"
                version="1.0">

    <xsl:output indent="yes" 
                encoding="ISO-8859-1"
                omit-xml-declaration="yes"/>                

    <xsl:param name="reptile.search.query" select="''"/>

    <xsl:template match="search-results:results">

        <rdf:RDF>

            <rss:channel>

                <rss:image rdf:about="/reptile/images/search.png">

                    <rss:title>Search results.</rss:title>

                    <rss:url>/reptile/images/search.png</rss:url>
                    
                </rss:image>

                <rss:title>Search found <xsl:value-of select="@found"/> 
                           results for '<xsl:value-of select="$reptile.search.query"/>' 
                           within <xsl:value-of select="@total"/> articles.
                           </rss:title>

            </rss:channel>

            <xsl:apply-templates/>
            
        </rdf:RDF>

    </xsl:template>

    <xsl:template match="search-results:entry">

        <rss:item>

            <rss:title><xsl:value-of select="dc:title"/></rss:title>
    
            <rss:link><xsl:value-of select="search-results:link/@location"/></rss:link>

            <dc:date><xsl:value-of select="search-results:link/@date-found"/></dc:date>
    
            <rss:description><xsl:value-of select="dc:description"/></rss:description>

        </rss:item>

    </xsl:template>

    <!-- should we provide textinput for another search -->

<!--     <xsl:template match="textinput"> -->

<!--         <uplevel:textinput rdf:about="{link}"> -->

<!--             <uplevel:title><xsl:value-of select="title"/></uplevel:title> -->

<!--             <uplevel:link><xsl:value-of select="link"/></uplevel:link> -->

<!--             <uplevel:name><xsl:value-of select="name"/></uplevel:name> -->

<!--             <uplevel:description><xsl:value-of select="description"/></uplevel:description> -->

<!--             <xsl:apply-templates/> -->

<!--         </uplevel:textinput> -->

<!--     </xsl:template>     -->

</xsl:stylesheet>