/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.panther.implementations.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.panther.event.ProxyEventManager;
import org.openprivacy.panther.implementations.CacheConstructor;
import org.openprivacy.panther.implementations.CacheNode;
import org.openprivacy.panther.implementations.PantherProxyEntry;
import org.openprivacy.panther.implementations.ProxyEntryManager;
import org.openprivacy.panther.implementations.UpdateManager;
import org.openprivacy.panther.implementations.memory.MemoryCache;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import talon.Assert;
import talon.util.Log;
import talon.util.StringUtils;
import talon.util.net.URI;

public class UpdateHandler
extends DefaultHandler {
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private PrintWriter out = new PrintWriter(this.bos);
    private String updateLocation = "";
    private String mimeType = "text/xml";
    private boolean updated = false;
    private String content = "";
    private String datfile = "";
    private long lastModified = 0L;
    private long minCachedInterval = 600000L;
    private boolean download = false;
    private String currentNamespace = "";
    private String currentElement = "";
    private String currentLocation = "";
    private ProxyEntry entry = null;

    public UpdateHandler(String updateLocation, boolean download) throws Exception {
        this.download = download;
        CacheNode node = CacheConstructor.construct(updateLocation);
        this.updateLocation = updateLocation;
        if (download) {
            this.content = this.getContent();
        }
        XMLReader xmlr = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        xmlr.setContentHandler(this);
        node.require();
        if (download) {
            this.datfile = node.getDirectory() + "/" + System.currentTimeMillis() + ".dat";
        } else {
            ProxyEntry entry = ProxyEntryManager.getInstance().get(updateLocation);
            Assert.assert((entry != null ? 1 : 0) != 0, (String)("Could not find an entry for this location: " + updateLocation));
            this.datfile = entry.getFile().getAbsolutePath();
            this.minCachedInterval = entry.getMinCachedInterval();
        }
        UpdateManager updateManager = UpdateManager.getInstance();
        synchronized (updateManager) {
            if (download) {
                FileOutputStream datos = new FileOutputStream(this.datfile);
                datos.write(this.content.getBytes());
                datos.flush();
                datos.close();
            }
            String nodePath = node.getPath();
            Assert.assert((Object)nodePath, (String)"A node path was not specified");
            xmlr.parse(nodePath);
            this.out.flush();
            this.bos.flush();
            node.setIsNew(false);
            FileOutputStream fos = new FileOutputStream(node.getPath());
            fos.write(this.bos.toByteArray());
            fos.flush();
            fos.close();
        }
        this.entry = new PantherProxyEntry(new URI(updateLocation), this.datfile, this.lastModified, this.minCachedInterval, this.mimeType);
        ProxyEntryManager.getInstance().set(updateLocation, this.entry);
        if (download) {
            ProxyEventManager.getInstance().fireUpdated(this.entry);
        }
    }

    public UpdateHandler(String updateLocation) throws Exception {
        this(updateLocation, true);
    }

    public void startElement(String uri, String local, String raw, Attributes attrs) {
        this.currentNamespace = uri;
        this.currentElement = local;
        if (uri.equals("http://schemas.openprivacy.org/panther/cache") && local.equals("entry") && attrs.getValue("location") != null) {
            String location;
            this.currentLocation = location = attrs.getValue("location");
            if (location.equals(this.updateLocation)) {
                String attr_lastModified;
                new File(attrs.getValue("filename")).delete();
                if (!this.download && (attr_lastModified = attrs.getValue("lastModified")) != null) {
                    this.lastModified = Long.valueOf(attr_lastModified);
                }
                return;
            }
        }
        this.out.print('<');
        this.out.print(raw);
        if (attrs != null) {
            int len = attrs.getLength();
            int i = 0;
            while (i < len) {
                this.out.print(' ');
                this.out.print(attrs.getQName(i));
                this.out.print("=\"");
                this.out.print(this.normalize(attrs.getValue(i)));
                this.out.print('\"');
                ++i;
            }
        }
        this.out.print(" xmlns=\"" + uri + "\"");
        this.out.println('>');
    }

    public void endElement(String uri, String local, String qName) {
        if (!this.updated && uri.equals("http://schemas.openprivacy.org/panther/cache") && local.equals("cache")) {
            String escapedLocation = StringUtils.replaceAll((String)this.updateLocation, (String)"&", (String)"&amp;");
            if (this.lastModified == 0L) {
                this.lastModified = System.currentTimeMillis();
            }
            this.out.println("<entry location=\"" + escapedLocation + "\" " + "lastModified=\"" + this.lastModified + "\" " + "mimeType=\"" + this.mimeType + "\" " + "minCachedInterval=\"" + this.minCachedInterval + "\" " + "filename=\"" + this.datfile + "\"/>");
        }
        if (!(this.currentNamespace.equals("http://schemas.openprivacy.org/panther/cache") && this.currentElement.equals("entry") && this.currentLocation.equals(this.updateLocation) && local.equals("entry"))) {
            this.out.println("</" + local + ">");
        }
    }

    private String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    private String getContent() throws IOException {
        Object url;
        String location = this.updateLocation;
        if (location.indexOf("?") != -1) {
            url = this.updateLocation.substring(0, this.updateLocation.indexOf("?"));
            String urlData = this.updateLocation.substring(this.updateLocation.indexOf("?") + 1, this.updateLocation.length());
            urlData = StringUtils.replaceAll((String)urlData, (String)" ", (String)"%20");
            location = (String)url + "?" + urlData;
        }
        url = new URL(location);
        URLConnection urlc = ((URL)url).openConnection();
        if (((URL)url).getProtocol().equals("http")) {
            HttpURLConnection hurlc = (HttpURLConnection)urlc;
            this.mimeType = hurlc.getContentType();
            if (hurlc.getResponseCode() != 200) {
                String message = hurlc.getResponseMessage();
                Log.error((Object)message);
                throw new IOException(message);
            }
        }
        InputStream is = urlc.getInputStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] data = new byte[200];
        int readCount = 0;
        while ((readCount = is.read(data)) > 0) {
            bos.write(data, 0, readCount);
        }
        is.close();
        bos.close();
        String content = bos.toString();
        MemoryCache.store(this.updateLocation, content);
        return content;
    }

    public ProxyEntry getProxyEntry() {
        return this.entry;
    }
}

