/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class Touch
extends Task {
    private File file;
    private long millis = -1L;
    private String dateTime;
    private Vector filesets = new Vector();
    private FileUtils fileUtils = FileUtils.newFileUtils();

    public void setFile(File file) {
        this.file = file;
    }

    public void setMillis(long l) {
        this.millis = l;
    }

    public void setDatetime(String string) {
        this.dateTime = string;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void execute() throws BuildException {
        if (this.file == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source - a file or a fileset.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Use a fileset to touch directories.");
        }
        if (this.dateTime != null) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.US);
            try {
                this.setMillis(dateFormat.parse(this.dateTime).getTime());
                if (this.millis < 0L) {
                    throw new BuildException("Date of " + this.dateTime + " results in negative milliseconds value relative to epoch (January 1, 1970, 00:00:00 GMT).");
                }
            }
            catch (ParseException parseException) {
                throw new BuildException(parseException.getMessage(), parseException, this.location);
            }
        }
        this.touch();
    }

    protected void touch() throws BuildException {
        if (this.file != null) {
            if (!this.file.exists()) {
                this.log("Creating " + this.file, 2);
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                    fileOutputStream.write(new byte[0]);
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    throw new BuildException("Could not create " + this.file, iOException, this.location);
                }
            }
            this.touch(this.file);
        }
        if (this.millis >= 0L) {
            if (Project.getJavaVersion() == "1.1") {
                this.log("modification time of files cannot be set in JDK 1.1", 1);
                return;
            }
        }
        int n = 0;
        while (n < this.filesets.size()) {
            FileSet fileSet = (FileSet)this.filesets.elementAt(n);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
            File file = fileSet.getDir(this.project);
            String[] stringArray = directoryScanner.getIncludedFiles();
            String[] stringArray2 = directoryScanner.getIncludedDirectories();
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.touch(new File(file, stringArray[n2]));
                ++n2;
            }
            int n3 = 0;
            while (n3 < stringArray2.length) {
                this.touch(new File(file, stringArray2[n3]));
                ++n3;
            }
            ++n;
        }
    }

    protected void touch(File file) throws BuildException {
        if (!file.canWrite()) {
            throw new BuildException("Can not change modification date of read-only file " + file);
        }
        if (Project.getJavaVersion() == "1.1") {
            return;
        }
        if (this.millis < 0L) {
            this.fileUtils.setFileLastModified(file, System.currentTimeMillis());
        } else {
            this.fileUtils.setFileLastModified(file, this.millis);
        }
    }
}

