/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import com.ibm.ivj.util.base.ExportCodeSpec;
import com.ibm.ivj.util.base.IvjException;
import com.ibm.ivj.util.base.Package;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ide.VAJUtil;
import org.apache.tools.ant.taskdefs.optional.ide.VAJWorkspaceScanner;
import org.apache.tools.ant.types.PatternSet;

public class VAJExport
extends Task {
    protected File destDir;
    protected boolean exportSources = true;
    protected boolean exportResources = true;
    protected boolean exportClasses = false;
    protected boolean exportDebugInfo = false;
    protected boolean useDefaultExcludes = true;
    protected PatternSet patternSet = new PatternSet();

    public PatternSet.NameEntry createExclude() {
        return this.patternSet.createExclude();
    }

    public PatternSet.NameEntry createInclude() {
        return this.patternSet.createInclude();
    }

    public void execute() throws BuildException {
        if (this.destDir == null) {
            throw new BuildException("destdir attribute must be set!");
        }
        VAJWorkspaceScanner ds = this.getWorkspaceScanner();
        Package[] packages = ds.getIncludedPackages();
        this.export(packages);
    }

    public void export(Package[] packages) {
        try {
            String dest = this.destDir.getAbsolutePath();
            this.log("Exporting " + packages.length + " package(s) to " + dest);
            int i = 0;
            while (i < packages.length) {
                this.log("    " + packages[i].getName(), 3);
                ++i;
            }
            ExportCodeSpec exportSpec = new ExportCodeSpec();
            exportSpec.setPackages(packages);
            exportSpec.includeJava(this.exportSources);
            exportSpec.includeClass(this.exportClasses);
            exportSpec.includeResources(this.exportResources);
            exportSpec.includeClassDebugInfo(this.exportDebugInfo);
            exportSpec.useSubdirectories(true);
            exportSpec.overwriteFiles(true);
            exportSpec.setExportDirectory(dest);
            VAJUtil.getWorkspace().exportData(exportSpec);
        }
        catch (IvjException ex) {
            throw VAJUtil.createBuildException("Exporting failed!", ex);
        }
    }

    protected VAJWorkspaceScanner getWorkspaceScanner() {
        VAJWorkspaceScanner scanner = new VAJWorkspaceScanner();
        scanner.setIncludes(this.patternSet.getIncludePatterns(this.getProject()));
        scanner.setExcludes(this.patternSet.getExcludePatterns(this.getProject()));
        if (this.useDefaultExcludes) {
            scanner.addDefaultExcludes();
        }
        scanner.scan();
        return scanner;
    }

    public void setDefaultexcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setExcludes(String excludes) {
        this.patternSet.setExcludes(excludes);
    }

    public void setExportClasses(boolean doExport) {
        this.exportClasses = doExport;
    }

    public void setExportDebugInfo(boolean doExport) {
        this.exportDebugInfo = doExport;
    }

    public void setExportResources(boolean doExport) {
        this.exportResources = doExport;
    }

    public void setExportSources(boolean doExport) {
        this.exportSources = doExport;
    }

    public void setIncludes(String includes) {
        this.patternSet.setIncludes(includes);
    }
}

