/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.ValveContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

final class StandardHostValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardHostValve/1.0";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    StandardHostValve() {
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext valveContext) throws IOException, ServletException {
        Session session;
        Manager manager;
        if (!(request.getRequest() instanceof HttpServletRequest) || !(response.getResponse() instanceof HttpServletResponse)) {
            return;
        }
        StandardHost host = (StandardHost)this.getContainer();
        Context context = (Context)host.map(request, true);
        if (context == null) {
            ((HttpServletResponse)response.getResponse()).sendError(500, sm.getString("standardHost.noContext"));
            return;
        }
        Thread.currentThread().setContextClassLoader(context.getLoader().getClassLoader());
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        String sessionId = hreq.getRequestedSessionId();
        if (sessionId != null && (manager = context.getManager()) != null && (session = manager.findSession(sessionId)) != null && session.isValid()) {
            session.access();
        }
        context.invoke(request, response);
    }
}

