/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.services.schedule.JobEntryPeer;
import org.apache.turbine.services.schedule.JobQueue;
import org.apache.turbine.services.schedule.ScheduleService;
import org.apache.turbine.services.schedule.WorkerThread;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.Criteria;

public class TurbineSchedulerService
extends TurbineBaseService
implements ScheduleService {
    protected JobQueue scheduleQueue = null;
    protected MainLoop mainLoop = null;
    protected Thread thread = null;

    public void init(ServletConfig config) throws InitializationException {
        try {
            if (TurbineResources.getBoolean("scheduler.enabled", false)) {
                this.scheduleQueue = new JobQueue();
                this.mainLoop = new MainLoop();
                Vector jobs = JobEntryPeer.doSelect(new Criteria());
                if (jobs != null && jobs.size() > 0) {
                    this.scheduleQueue.batchLoad(jobs);
                    this.restart();
                }
                this.setInit(true);
            } else {
                Log.info("TurbineSchedulerService was not started because scheduler.enabled is not 'true' in the TurbineResources.properties file.");
            }
        }
        catch (Exception e) {
            throw new InitializationException("TurbineSchedulerService failed to initialize", e);
        }
    }

    public void shutdown() {
        if (this.getThread() != null) {
            this.getThread().interrupt();
        }
    }

    public JobEntry getJob(int oid) throws Exception {
        JobEntry je = JobEntryPeer.getJob(oid);
        return this.scheduleQueue.getJob(je);
    }

    public void addJob(JobEntry je) throws Exception {
        try {
            je.save();
        }
        catch (Exception e) {
            Log.error("Problem saving new Scheduled Job: " + e);
        }
        this.scheduleQueue.add(je);
        this.restart();
    }

    public void removeJob(JobEntry je) throws Exception {
        try {
            Criteria c = new Criteria().add(JobEntryPeer.OID, je.getPrimaryKey());
            BasePeer.doDelete(c);
        }
        catch (Exception ouch) {
            Log.error("Problem removing Scheduled Job: " + ouch);
        }
        this.scheduleQueue.remove(je);
        this.restart();
    }

    public void updateJob(JobEntry je) throws Exception {
        try {
            je.calcRunTime();
            je.save();
        }
        catch (Exception e) {
            Log.error("Problem updating Scheduled Job: " + e);
        }
        this.scheduleQueue.modify(je);
        this.restart();
    }

    public Vector listJobs() {
        return this.scheduleQueue.list();
    }

    public synchronized Thread getThread() {
        return this.thread;
    }

    private synchronized void clearThread() {
        this.thread = null;
    }

    public synchronized void restart() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this.mainLoop, "SchedulerService");
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            this.notify();
        }
    }

    private synchronized JobEntry nextJob() throws Exception {
        try {
            while (!Thread.interrupted()) {
                JobEntry je = this.scheduleQueue.getNext();
                if (je == null) {
                    this.wait();
                    continue;
                }
                long now = System.currentTimeMillis();
                long when = je.getNextRuntime();
                if (when > now) {
                    this.wait(when - now);
                    continue;
                }
                this.scheduleQueue.updateQueue(je);
                return je;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected class MainLoop
    implements Runnable {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    JobEntry je;
                    while ((je = TurbineSchedulerService.this.nextJob()) != null) {
                        WorkerThread wt = new WorkerThread(je);
                        Thread helper = new Thread(wt);
                        helper.start();
                    }
                    Object var2_5 = null;
                }
                catch (Exception e) {
                    Log.error("Error running a Scheduled Job: " + e);
                    Object var2_6 = null;
                    TurbineSchedulerService.this.clearThread();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var2_7 = null;
                TurbineSchedulerService.this.clearThread();
                throw throwable;
            }
            TurbineSchedulerService.this.clearThread();
        }

        MainLoop() {
        }
    }
}

