/*
 * Decompiled with CFR 0.152.
 */
package talon;

import talon.components.PropertyManager;
import talon.implementations.SimplePropertyManager;
import talon.references.TypeReferenceFactory;
import talon.util.net.URI;

public class ComponentHandle {
    public static final String DEPLOY_PROPERTY_INTERFACE = "talon_interface";
    public static final String DEPLOY_PROPERTY_IMPLEMENTATION = "talon_implementation";
    public static final String DEPLOY_PROPERTY_LIFETIME = "talon_lifetime";
    public static final String DEPLOY_PROPERTY_NAME = "talon_name";
    public static final String DEPLOY_PROPERTY_DESCRIPTION = "talon_description";
    public static final String LIFETIME_DEMAND = "demand";
    public static final String LIFETIME_SINGLETON = "singleton";
    private String _interface = null;
    private String _implementation = null;
    private String _lifetime = null;
    private String _description = null;
    private URI typeReference = null;
    private PropertyManager initProperties = new SimplePropertyManager();
    private String name = null;

    public ComponentHandle() {
    }

    public ComponentHandle(String _interface) {
        this._interface = _interface;
    }

    public ComponentHandle(String _interface, String _implementation) {
        this(_interface);
        this._implementation = _implementation;
    }

    public ComponentHandle(String _interface, String _classname, PropertyManager initProperties) {
        this(_interface, _classname);
        this.initProperties = initProperties;
    }

    public ComponentHandle(String name, String _interface, String _classname, PropertyManager initProperties) {
        this(_interface, _classname, initProperties);
        this.setName(name);
    }

    public ComponentHandle(Class clazz) {
        this.setImplementation(clazz.getName());
    }

    public String getInterface() {
        return this._interface;
    }

    public ComponentHandle setInterface(String _interface) {
        this._interface = _interface;
        return this;
    }

    public String getImplementation() {
        return this._implementation;
    }

    public ComponentHandle setImplementation(String _implementation) {
        this._implementation = _implementation;
        return this;
    }

    public ComponentHandle setImplementation(Class _implementation) {
        this.setImplementation(_implementation.getName());
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ComponentHandle setName(String name) {
        this.name = name;
        return this;
    }

    public String getLifetime() {
        return this._lifetime;
    }

    public ComponentHandle setLifetime(String _lifetime) {
        this._lifetime = _lifetime;
        return this;
    }

    public String getDescription() {
        return this._description;
    }

    public ComponentHandle setDescription(String _description) {
        this._description = _description;
        return this;
    }

    public PropertyManager getInitProperties() {
        return this.initProperties;
    }

    public ComponentHandle setInitProperties(PropertyManager initProperties) {
        this.initProperties = initProperties;
        return this;
    }

    public String toString() {
        return this.getTypeReference().toString();
    }

    public URI getTypeReference() {
        if (this.typeReference == null) {
            this.typeReference = TypeReferenceFactory.getTypeReference(this);
        }
        return this.typeReference;
    }

    public Object clone() {
        ComponentHandle handle = new ComponentHandle();
        handle.setName(this.getName());
        handle.setDescription(this.getDescription());
        handle.setLifetime(this.getLifetime());
        handle.setInitProperties(this.getInitProperties());
        handle.setInterface(this.getInterface());
        handle.setImplementation(this.getImplementation());
        return handle;
    }
}

