/*
 * Decompiled with CFR 0.152.
 */
package org.arrowhead.util.cli;

import java.text.ParseException;
import java.util.Vector;
import org.arrowhead.util.cli.CLOption;
import org.arrowhead.util.cli.CLOptionDescriptor;
import org.arrowhead.util.cli.ParserControl;

public final class CLArgsParser {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_REQUIRE_2ARGS = 1;
    private static final int STATE_REQUIRE_ARG = 2;
    private static final int STATE_OPTIONAL_ARG = 3;
    private static final int STATE_NO_OPTIONS = 4;
    private static final int STATE_OPTION_MODE = 5;
    protected static final int TOKEN_SEPERATOR = 0;
    protected static final int TOKEN_STRING = 1;
    protected static final char[] ARG2_SEPERATORS = new char[]{'\u0000', '=', '-'};
    protected static final char[] ARG_SEPERATORS = new char[]{'\u0000', '='};
    protected static final char[] NULL_SEPERATORS = new char[]{'\u0000'};
    protected final CLOptionDescriptor[] m_optionDescriptors;
    protected final Vector m_options;
    protected final ParserControl m_control;
    protected String m_errorMessage;
    protected String[] m_unparsedArgs = new String[0];
    protected char ch;
    protected String[] args;
    protected boolean isLong;
    protected int argIndex;
    protected int stringIndex;
    protected int stringLength;
    protected static final int INVALID = Integer.MAX_VALUE;
    protected int m_lastChar = Integer.MAX_VALUE;
    protected int m_lastOptionId;
    protected CLOption m_option;
    protected int m_state = 0;

    public String[] getUnparsedArgs() {
        return this.m_unparsedArgs;
    }

    public Vector getArguments() {
        return this.m_options;
    }

    private CLOptionDescriptor getDescriptorFor(int n) {
        int n2 = 0;
        while (n2 < this.m_optionDescriptors.length) {
            if (this.m_optionDescriptors[n2].getId() == n) {
                return this.m_optionDescriptors[n2];
            }
            ++n2;
        }
        return null;
    }

    private CLOptionDescriptor getDescriptorFor(String string) {
        int n = 0;
        while (n < this.m_optionDescriptors.length) {
            if (this.m_optionDescriptors[n].getName().equals(string)) {
                return this.m_optionDescriptors[n];
            }
            ++n;
        }
        return null;
    }

    public String getErrorString() {
        return this.m_errorMessage;
    }

    private int getStateFor(CLOptionDescriptor cLOptionDescriptor) {
        int n = cLOptionDescriptor.getFlags();
        if ((n & 0x10) == 16) {
            return 1;
        }
        if ((n & 2) == 2) {
            return 2;
        }
        if ((n & 4) == 4) {
            return 3;
        }
        return 0;
    }

    public CLArgsParser(String[] stringArray, CLOptionDescriptor[] cLOptionDescriptorArray, ParserControl parserControl) {
        this.m_optionDescriptors = cLOptionDescriptorArray;
        this.m_control = parserControl;
        this.m_options = new Vector();
        this.args = stringArray;
        try {
            this.parse();
            this.checkIncompatabilities(this.m_options);
        }
        catch (ParseException parseException) {
            this.m_errorMessage = parseException.getMessage();
        }
    }

    protected void checkIncompatabilities(Vector vector) throws ParseException {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            CLOption cLOption = (CLOption)vector.elementAt(n2);
            int n3 = cLOption.getId();
            CLOptionDescriptor cLOptionDescriptor = this.getDescriptorFor(n3);
            if (null != cLOptionDescriptor) {
                int[] nArray = cLOptionDescriptor.getIncompatble();
                this.checkIncompatable(vector, nArray, n2);
            }
            ++n2;
        }
    }

    protected void checkIncompatable(Vector vector, int[] nArray, int n) throws ParseException {
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            if (n != n3) {
                CLOption cLOption = (CLOption)vector.elementAt(n3);
                int n4 = cLOption.getId();
                CLOptionDescriptor cLOptionDescriptor = this.getDescriptorFor(n4);
                int n5 = 0;
                while (n5 < nArray.length) {
                    if (n4 == nArray[n5]) {
                        CLOption cLOption2 = (CLOption)vector.elementAt(n);
                        int n6 = cLOption2.getId();
                        String string = null;
                        string = n4 == n6 ? "Duplicate options for " + this.describeDualOption(n6) + " found." : "Incompatable options -" + this.describeDualOption(n4) + " and " + this.describeDualOption(n6) + " found.";
                        throw new ParseException(string, 0);
                    }
                    ++n5;
                }
            }
            ++n3;
        }
    }

    protected String describeDualOption(int n) {
        String string;
        CLOptionDescriptor cLOptionDescriptor = this.getDescriptorFor(n);
        if (null == cLOptionDescriptor) {
            return "<parameter>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (Character.isLetter((char)n)) {
            stringBuffer.append('-');
            stringBuffer.append((char)n);
            bl = true;
        }
        if (null != (string = cLOptionDescriptor.getName())) {
            if (bl) {
                stringBuffer.append('/');
            }
            stringBuffer.append("--");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public CLArgsParser(String[] stringArray, CLOptionDescriptor[] cLOptionDescriptorArray) {
        this(stringArray, cLOptionDescriptorArray, null);
    }

    protected String[] subArray(String[] stringArray, int n, int n2) {
        int n3 = stringArray.length - n;
        String[] stringArray2 = new String[n3];
        if (n3 > 1) {
            System.arraycopy(stringArray, n + 1, stringArray2, 1, n3 - 1);
        }
        stringArray2[0] = stringArray[n].substring(n2 - 1);
        return stringArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parse() throws ParseException {
        if (0 == this.args.length) {
            return;
        }
        this.stringLength = this.args[this.argIndex].length();
        while (true) {
            this.ch = this.peekAtChar();
            if (this.argIndex >= this.args.length) break;
            if (null != this.m_control && this.m_control.isFinished(this.m_lastOptionId)) {
                this.m_unparsedArgs = this.subArray(this.args, this.argIndex, this.stringIndex);
                return;
            }
            if (5 == this.m_state) {
                if ('\u0000' == this.ch) {
                    this.getChar();
                    this.m_state = 0;
                    continue;
                }
                this.parseShortOption();
                continue;
            }
            if (0 == this.m_state) {
                this.parseNormal();
                continue;
            }
            if (4 == this.m_state) {
                this.addOption(new CLOption(this.args[this.argIndex++]));
                continue;
            }
            if (3 == this.m_state && '-' == this.ch) {
                this.m_state = 0;
                this.addOption(this.m_option);
                continue;
            }
            this.parseArguments();
        }
        if (this.m_option == null) return;
        if (3 == this.m_state) {
            this.m_options.addElement(this.m_option);
            return;
        } else {
            if (2 == this.m_state) {
                CLOptionDescriptor cLOptionDescriptor = this.getDescriptorFor(this.m_option.getId());
                String string = "Missing argument to option " + this.getOptionDescription(cLOptionDescriptor);
                throw new ParseException(string, 0);
            }
            if (1 != this.m_state) throw new ParseException("IllegalState " + this.m_state + ": " + this.m_option, 0);
            if (1 == this.m_option.getArgumentCount()) {
                this.m_option.addArgument("");
                this.m_options.addElement(this.m_option);
                return;
            } else {
                CLOptionDescriptor cLOptionDescriptor = this.getDescriptorFor(this.m_option.getId());
                String string = "Missing argument to option " + this.getOptionDescription(cLOptionDescriptor);
                throw new ParseException(string, 0);
            }
        }
    }

    protected final String getOptionDescription(CLOptionDescriptor cLOptionDescriptor) {
        if (this.isLong) {
            return "--" + cLOptionDescriptor.getName();
        }
        return "-" + (char)cLOptionDescriptor.getId();
    }

    protected final char peekAtChar() {
        if (Integer.MAX_VALUE == this.m_lastChar) {
            this.m_lastChar = this.readChar();
        }
        return (char)this.m_lastChar;
    }

    protected final char getChar() {
        if (Integer.MAX_VALUE != this.m_lastChar) {
            char c = (char)this.m_lastChar;
            this.m_lastChar = Integer.MAX_VALUE;
            return c;
        }
        return this.readChar();
    }

    private final char readChar() {
        if (this.stringIndex >= this.stringLength) {
            ++this.argIndex;
            this.stringIndex = 0;
            this.stringLength = this.argIndex < this.args.length ? this.args[this.argIndex].length() : 0;
            return '\u0000';
        }
        if (this.argIndex >= this.args.length) {
            return '\u0000';
        }
        return this.args[this.argIndex].charAt(this.stringIndex++);
    }

    protected final Token nextToken(char[] cArray) {
        this.ch = this.getChar();
        if (this.isSeperator(this.ch, cArray)) {
            this.ch = this.getChar();
            return new Token(0, null);
        }
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.append(this.ch);
            this.ch = this.getChar();
        } while (!this.isSeperator(this.ch, cArray));
        return new Token(1, stringBuffer.toString());
    }

    private final boolean isSeperator(char c, char[] cArray) {
        int n = 0;
        while (n < cArray.length) {
            if (c == cArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void addOption(CLOption cLOption) {
        this.m_options.addElement(cLOption);
        this.m_lastOptionId = cLOption.getId();
        this.m_option = null;
    }

    protected void parseOption(CLOptionDescriptor cLOptionDescriptor, String string) throws ParseException {
        if (null == cLOptionDescriptor) {
            throw new ParseException("Unknown option " + string, 0);
        }
        this.m_state = this.getStateFor(cLOptionDescriptor);
        this.m_option = new CLOption(cLOptionDescriptor.getId());
        if (0 == this.m_state) {
            this.addOption(this.m_option);
        }
    }

    protected void parseShortOption() throws ParseException {
        this.ch = this.getChar();
        CLOptionDescriptor cLOptionDescriptor = this.getDescriptorFor(this.ch);
        this.isLong = false;
        this.parseOption(cLOptionDescriptor, "-" + this.ch);
        if (0 == this.m_state) {
            this.m_state = 5;
        }
    }

    protected boolean parseArguments() throws ParseException {
        if (2 == this.m_state) {
            if ('=' == this.ch || '\u0000' == this.ch) {
                this.getChar();
            }
            Token token = this.nextToken(NULL_SEPERATORS);
            this.m_option.addArgument(token.getValue());
            this.addOption(this.m_option);
            this.m_state = 0;
        } else if (1 == this.m_state) {
            if (0 == this.m_option.getArgumentCount()) {
                Token token = this.nextToken(ARG_SEPERATORS);
                if (0 == token.getType()) {
                    CLOptionDescriptor cLOptionDescriptor = this.getDescriptorFor(this.m_option.getId());
                    String string = "Unable to parse first argument for option " + this.getOptionDescription(cLOptionDescriptor);
                    throw new ParseException(string, 0);
                }
                this.m_option.addArgument(token.getValue());
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                this.ch = this.getChar();
                if ('-' == this.ch) {
                    this.m_lastChar = this.ch;
                }
                while (!this.isSeperator(this.ch, ARG2_SEPERATORS)) {
                    stringBuffer.append(this.ch);
                    this.ch = this.getChar();
                }
                String string = stringBuffer.toString();
                this.m_option.addArgument(string);
                this.addOption(this.m_option);
                this.m_option = null;
                this.m_state = 0;
            }
        }
        return true;
    }

    protected void parseNormal() throws ParseException {
        if ('-' != this.ch) {
            String string = this.nextToken(NULL_SEPERATORS).getValue();
            this.addOption(new CLOption(string));
            this.m_state = 0;
        } else {
            this.getChar();
            if ('\u0000' == this.peekAtChar()) {
                throw new ParseException("Malformed option -", 0);
            }
            this.ch = this.peekAtChar();
            if ('-' != this.ch) {
                this.parseShortOption();
            } else {
                this.getChar();
                if ('\u0000' == this.peekAtChar()) {
                    this.getChar();
                    this.m_state = 4;
                } else {
                    String string = this.nextToken(ARG_SEPERATORS).getValue();
                    CLOptionDescriptor cLOptionDescriptor = this.getDescriptorFor(string);
                    this.isLong = true;
                    this.parseOption(cLOptionDescriptor, "--" + string);
                }
            }
        }
    }

    protected class Token {
        protected final int m_type;
        protected final String m_value;

        public Token(int n, String string) {
            this.m_type = n;
            this.m_value = string;
        }

        public String getValue() {
            return this.m_value;
        }

        public int getType() {
            return this.m_type;
        }

        public String toString() {
            return "" + this.m_type + ":" + this.m_value;
        }
    }
}

