/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.test.endpoint;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageElementEnumeration;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.endpoint.MessageWireFormat;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.util.StringEnumeration;

public class MessageTest
extends TestCase {
    MimeMediaType[] testTypes = new MimeMediaType[]{new MimeMediaType("text", "plain"), new MimeMediaType("text", "xml"), new MimeMediaType("pig-in-a", "poke")};

    public MessageTest(String string) {
        super(string);
    }

    public void testCreateElement() {
        try {
            MessageImpl messageImpl = new MessageImpl();
            Assert.assertTrue((messageImpl != null ? 1 : 0) != 0);
            MessageElement messageElement = this.createElement(messageImpl, 1, "ding");
            messageImpl.addElement(messageElement);
            Assert.assertTrue((boolean)messageElement.getName().equals("ding:elem1"));
            this.checkElement(messageElement);
        }
        catch (Exception exception) {
            Assert.fail((String)("Threw " + exception));
        }
    }

    public void testCreateElementFromStream() {
        try {
            MessageImpl messageImpl = new MessageImpl();
            byte[] byArray = new byte[]{1, 2, 3, 4};
            BAIS bAIS = new BAIS(byArray);
            MessageElement messageElement = messageImpl.newMessageElement("hi", null, bAIS);
            Assert.assertTrue((messageElement != null ? 1 : 0) != 0);
            Assert.assertTrue((bAIS.read() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)bAIS.isClosed());
            int n = 0;
            while (n < byArray.length) {
                Assert.assertTrue((messageElement.getBytesOffset()[n] == byArray[n] ? 1 : 0) != 0);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)exception.toString());
        }
    }

    public void testGetNames() {
        MessageImpl messageImpl = new MessageImpl();
        int n = 0;
        while (n < 40) {
            messageImpl.setBytes("el" + n, new byte[0]);
            StringEnumeration stringEnumeration = messageImpl.getNames();
            int n2 = n;
            while (n2 >= 0) {
                String string = stringEnumeration.nextString();
                Assert.assertEquals((Object)("el" + n2), (Object)string);
                --n2;
            }
            ++n;
        }
    }

    public void testWireFormatXML() {
        try {
            MessageImpl messageImpl = new MessageImpl();
            byte[] byArray = new byte[]{1, 2, 3, 4};
            BAIS bAIS = new BAIS(byArray);
            MessageElement messageElement = messageImpl.newMessageElement("hi", new MimeMediaType("application/octet-stream"), bAIS);
            Assert.assertTrue((messageElement != null ? 1 : 0) != 0);
            messageImpl.addElement(messageElement);
            String string = "This is &lt;text&gt; &amp; & <>";
            MessageElement messageElement2 = messageImpl.newMessageElement("a string", new MimeMediaType("text/plain"), string.getBytes());
            Assert.assertTrue((messageElement2 != null ? 1 : 0) != 0);
            messageImpl.addElement(messageElement2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.getXMLMessageFormat().writeMessage(byteArrayOutputStream, messageImpl);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            MessageImpl messageImpl2 = new MessageImpl();
            this.getXMLMessageFormat().readMessage(byteArrayInputStream, messageImpl2);
            Assert.assertTrue((boolean)messageImpl.equals(messageImpl2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)exception.toString());
        }
    }

    public void testCreateElementFromStreamWithLength() {
        try {
            MessageImpl messageImpl = new MessageImpl();
            byte[] byArray = new byte[]{1, 2, 3, 4};
            BAIS bAIS = new BAIS(byArray);
            MessageElement messageElement = messageImpl.newMessageElement("hi", null, bAIS, byArray.length - 1);
            Assert.assertTrue((messageElement != null ? 1 : 0) != 0);
            Assert.assertTrue((bAIS.read() == 4 ? 1 : 0) != 0);
            Assert.assertTrue((!bAIS.isClosed() ? 1 : 0) != 0);
            int n = 0;
            while (n < byArray.length - 1) {
                Assert.assertTrue((messageElement.getBytesOffset()[n] == byArray[n] ? 1 : 0) != 0);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)exception.toString());
        }
    }

    public void testPush() {
        byte[] byArray = new byte[]{5, 6, 7, 8, 9, 10, 44};
        try {
            int n = 0;
            while (n < 2) {
                Object object;
                Object object2;
                MessageImpl messageImpl = new MessageImpl();
                Assert.assertTrue((messageImpl != null ? 1 : 0) != 0);
                if (n == 0) {
                    messageImpl.setBytes("n:abc", byArray);
                } else {
                    object2 = new ByteArrayInputStream(byArray);
                    object = messageImpl.newMessageElement("n:abc", new MimeMediaType("text/xml"), (InputStream)object2);
                }
                object2 = messageImpl.getElement("n:abc");
                Assert.assertTrue((boolean)((MessageElement)object2).getName().equals("n:abc"));
                Assert.assertTrue((((MessageElement)object2).getType() == null ? 1 : 0) != 0);
                Assert.assertTrue((((MessageElement)object2).getOffset() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((((MessageElement)object2).getLength() == byArray.length ? 1 : 0) != 0);
                object = ((MessageElement)object2).getBytesOffset();
                Assert.assertTrue((((Object)object).length == byArray.length ? 1 : 0) != 0);
                int n2 = 0;
                while (n2 < byArray.length) {
                    Assert.assertTrue((byArray[n2] == object[n2] ? 1 : 0) != 0);
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Assert.fail((String)exception.toString());
        }
    }

    public void testPop() {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 45};
        try {
            int n = 0;
            while (n < 2) {
                byte[] byArray2;
                MessageImpl messageImpl = new MessageImpl();
                MimeMediaType mimeMediaType = new MimeMediaType("this", "that");
                MessageElement messageElement = messageImpl.newMessageElement("myspace:yourplace", mimeMediaType, byArray);
                messageImpl.addElement(messageElement);
                if (n == 0) {
                    byArray2 = messageImpl.getBytes("myspace:yourplace");
                } else {
                    InputStream inputStream = messageImpl.getElement("myspace:yourplace").getStream();
                    DataInputStream dataInputStream = new DataInputStream(inputStream);
                    byArray2 = new byte[inputStream.available()];
                    dataInputStream.readFully(byArray2);
                }
                Assert.assertTrue((byArray2.length == byArray.length ? 1 : 0) != 0);
                int n2 = 0;
                while (n2 < byArray.length) {
                    Assert.assertTrue((byArray[n2] == byArray2[n2] ? 1 : 0) != 0);
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Assert.fail((String)exception.toString());
        }
    }

    public void testMessageGetElements() {
        Vector<MessageElement> vector = new Vector<MessageElement>();
        MessageImpl messageImpl = new MessageImpl();
        Assert.assertTrue((messageImpl != null ? 1 : 0) != 0);
        int n = 0;
        while (n < 30) {
            MessageElement messageElement = this.createElement(messageImpl, n);
            messageImpl.addElement(messageElement);
            vector.addElement(messageElement);
            this.checkElements(messageImpl, vector);
            ++n;
        }
    }

    public void testEqualsElement() {
        MessageImpl messageImpl = new MessageImpl();
        int n = 0;
        while (n < 100) {
            MessageElement messageElement = this.createElement(messageImpl, n);
            MessageElement messageElement2 = this.createElement(messageImpl, n);
            Assert.assertTrue((boolean)messageElement.equals(messageElement2));
            ++n;
        }
    }

    public void testNotEqualsElement() {
        MessageElement messageElement = null;
        MessageImpl messageImpl = new MessageImpl();
        int n = 0;
        while (n < 100) {
            MessageElement messageElement2 = this.createElement(messageImpl, n);
            if (messageElement != null) {
                Assert.assertTrue((!messageElement2.equals(messageElement) ? 1 : 0) != 0);
            }
            messageElement = messageElement2;
            ++n;
        }
    }

    public void testClone() {
        MessageImpl messageImpl = new MessageImpl();
        int n = 0;
        while (n < 100) {
            MessageElement messageElement;
            MessageElement messageElement2 = this.createElement(messageImpl, n);
            Assert.assertTrue((messageElement2 == (messageElement = (MessageElement)messageElement2.clone()) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)messageElement2.equals(messageElement));
            ++n;
        }
    }

    public void testRemoveElement() {
        try {
            MessageImpl messageImpl = new MessageImpl();
            MessageElement messageElement = this.createElement(messageImpl, 1);
            messageImpl.addElement(messageElement);
            messageImpl.removeElement(messageElement);
            MessageImpl messageImpl2 = new MessageImpl();
            Assert.assertTrue((boolean)messageImpl.equals(messageImpl2));
            messageImpl = new MessageImpl();
            messageElement = this.createElement(messageImpl, 1);
            messageImpl.addElement(messageElement);
            MessageElement messageElement2 = this.createElement(messageImpl, 2);
            messageImpl.addElement(messageElement2);
            messageImpl2 = new MessageImpl();
            Assert.assertTrue((!messageImpl.equals(messageImpl2) ? 1 : 0) != 0);
            MessageElement messageElement3 = this.createElement(messageImpl, 2);
            messageImpl2.addElement(messageElement3);
            Assert.assertTrue((!messageImpl.equals(messageImpl2) ? 1 : 0) != 0);
            messageImpl.removeElement(messageElement);
            Assert.assertTrue((boolean)messageImpl.equals(messageImpl2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)exception.toString());
        }
    }

    public void testWireFormatNoElements() {
        try {
            MessageImpl messageImpl = new MessageImpl();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.getBinaryMessageFormat().writeMessage(byteArrayOutputStream, messageImpl);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Assert.assertTrue((String)"Incorrect message magic[0]", (byArray[0] == 106 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect message magic[1]", (byArray[1] == 120 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect message magic[2]", (byArray[2] == 109 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect message magic[3]", (byArray[3] == 103 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect message version", (byArray[4] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[5] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[6] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[7] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[8] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((byArray.length == 9 ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)("Threw " + exception));
        }
    }

    public void testFormatOneElement() {
        try {
            int n = 0;
            MessageImpl messageImpl = new MessageImpl();
            MessageElement messageElement = this.createElement(messageImpl, 1);
            messageImpl.addElement(messageElement);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.getBinaryMessageFormat().writeMessage(byteArrayOutputStream, messageImpl);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Assert.assertTrue((String)"Incorrect message magic[0]", (byArray[n++] == 106 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect message magic[1]", (byArray[n++] == 120 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect message magic[2]", (byArray[n++] == 109 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect message magic[3]", (byArray[n++] == 103 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect message version", (byArray[n++] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[n++] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[n++] == 1 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[n++] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[n++] == 4 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[n++] == 100 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[n++] == 105 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[n++] == 110 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[n++] == 103 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[n++] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[n++] == 1 ? 1 : 0) != 0);
            n = this.checkWireElement(byArray, n, 1, 2);
            Assert.assertTrue((byArray.length == n ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)("Threw " + exception));
        }
    }

    public void testWireFormatManyElementsSameNamespace() {
        try {
            Vector<MessageElement> vector = new Vector<MessageElement>();
            boolean bl = false;
            MessageImpl messageImpl = new MessageImpl();
            int n = 0;
            while (n < 40) {
                MessageElement messageElement = this.createElement(messageImpl, n);
                messageImpl.addElement(messageElement);
                vector.addElement(messageElement);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.getBinaryMessageFormat().writeMessage(byteArrayOutputStream, messageImpl);
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.checkWireMessage(byArray, vector, true);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)("Threw " + exception));
        }
    }

    public void testWireFormatManyElementsManyNamespace() {
        try {
            Vector<MessageElement> vector = new Vector<MessageElement>();
            boolean bl = false;
            MessageImpl messageImpl = new MessageImpl();
            int n = 0;
            while (n < 40) {
                MessageElement messageElement = this.createElement(messageImpl, n, "namespace" + n % 4);
                messageImpl.addElement(messageElement);
                vector.addElement(messageElement);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.getBinaryMessageFormat().writeMessage(byteArrayOutputStream, messageImpl);
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.checkWireMessage(byArray, vector, false);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)("Threw " + exception));
        }
    }

    public void testMessageRead() {
        try {
            MessageImpl messageImpl = new MessageImpl();
            int n = 0;
            while (n < 30) {
                MessageElement messageElement = this.createElement(messageImpl, n, "space" + n % 3);
                messageImpl.addElement(messageElement);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.getBinaryMessageFormat().writeMessage(byteArrayOutputStream, messageImpl);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                MessageImpl messageImpl2 = new MessageImpl();
                this.getBinaryMessageFormat().readMessage(byteArrayInputStream, messageImpl2);
                Assert.assertTrue((boolean)messageImpl.equals(messageImpl2));
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail();
        }
    }

    MessageElement createElement(Message message, int n) {
        return this.createElement(message, n, "ding");
    }

    MessageElement createElement(Message message, int n, String string) {
        MimeMediaType mimeMediaType = this.testTypes[n % this.testTypes.length];
        int n2 = new Random().nextInt(2);
        int n3 = n + 10;
        int n4 = n3 + n2;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        while (n5 < n3) {
            byArray[n5 + n2] = (byte)n5;
            ++n5;
        }
        MessageElement messageElement = string == null ? message.newMessageElement("elem" + n, mimeMediaType, byArray, n2, n3) : message.newMessageElement(string + ":elem" + n, mimeMediaType, byArray, n2, n3);
        return messageElement;
    }

    void checkElements(Message message, Vector vector) {
        MessageElementEnumeration messageElementEnumeration = message.getElements();
        int n = 0;
        while (messageElementEnumeration.hasMoreElements()) {
            MessageElement messageElement = (MessageElement)messageElementEnumeration.nextElement();
            if (!this.referenceIsIn(messageElement, vector)) {
                Assert.fail((String)("Unexpected element, " + messageElement.getName() + ", found in message"));
            }
            this.checkElement(messageElement);
            ++n;
        }
        Assert.assertTrue((vector.size() == n ? 1 : 0) != 0);
    }

    void checkElement(MessageElement messageElement) {
        String string = messageElement.getName();
        String[] stringArray = MessageElement.parseName(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Assert.assertTrue((boolean)string2.equals("ding"));
        Assert.assertTrue((boolean)string3.substring(0, 4).equals("elem"));
        int n = 0;
        try {
            n = Integer.parseInt(string3.substring(4));
        }
        catch (NumberFormatException numberFormatException) {
            Assert.fail((String)"Element name does not end with integer string");
        }
        int n2 = n + 10;
        Assert.assertTrue((boolean)messageElement.getType().equals(this.testTypes[n % this.testTypes.length]));
        Assert.assertTrue((n2 == messageElement.getLength() ? 1 : 0) != 0);
        try {
            InputStream inputStream = messageElement.getStream();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = inputStream.read();
                Assert.assertTrue((String)("Entry " + n3 + " is " + n4 + " expected " + n3), (n4 == n3 ? 1 : 0) != 0);
                ++n3;
            }
            Assert.assertTrue((inputStream.read() == -1 ? 1 : 0) != 0);
            byte[] byArray = messageElement.getBytesOffset();
            int n5 = messageElement.getOffset();
            int n6 = 0;
            while (n6 < n2) {
                byte by = byArray[n6 + n5];
                Assert.assertTrue((String)("Entry " + n6 + " is " + by + " expected " + n6), (by == n6 ? 1 : 0) != 0);
                ++n6;
            }
        }
        catch (Exception exception) {
            Assert.fail((String)("Threw " + exception));
        }
    }

    void checkWireMessage(byte[] byArray, Vector vector, boolean bl) {
        String string;
        int n;
        int n2 = 0;
        vector = (Vector)vector.clone();
        int n3 = vector.size();
        Assert.assertTrue((String)"Incorrect message magic[0]", (byArray[n2++] == 106 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect message magic[1]", (byArray[n2++] == 120 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect message magic[2]", (byArray[n2++] == 109 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect message magic[3]", (byArray[n2++] == 103 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect message version", (byArray[n2++] == 0 ? 1 : 0) != 0);
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int n4 = bl ? 1 : (n3 < 4 ? n3 : 4);
        Assert.assertTrue((byArray[n2++] == n4 >> 8 ? 1 : 0) != 0);
        Assert.assertTrue((byArray[n2++] == (n4 & 0xFF) ? 1 : 0) != 0);
        if (bl) {
            Assert.assertTrue((byArray[n2++] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[n2++] == 4 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[n2++] == 100 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[n2++] == 105 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[n2++] == 110 ? 1 : 0) != 0);
            Assert.assertTrue((byArray[n2++] == 103 ? 1 : 0) != 0);
        } else {
            n = 0;
            while (n < n4) {
                string = this.getWireString(byArray, n2);
                n2 = this.skipWireString(byArray, n2);
                hashtable.put(string, new Integer(n + 2));
                ++n;
            }
        }
        Assert.assertTrue((String)("Wrong element count at index " + n2), (byArray[n2++] == n3 >> 8 ? 1 : 0) != 0);
        Assert.assertTrue((byArray[n2++] == (n3 & 0xFF) ? 1 : 0) != 0);
        n = 1;
        while (n <= n3) {
            Object object;
            String string2;
            int n5;
            string = this.getWireString(byArray, n2 + 6);
            int n6 = Integer.parseInt(string.substring(4));
            if (bl) {
                n5 = 2;
                string2 = "ding";
            } else {
                string2 = "namespace" + n6 % 4;
                object = (Integer)hashtable.get(string2);
                n5 = (Integer)object;
            }
            object = this.removeElement(vector, string2 + ":" + string);
            if (object == null) {
                Assert.fail((String)("Unexpected element at index " + n2 + " named " + string));
            }
            n2 = this.checkWireElement(byArray, n2, n6, n5);
            ++n;
        }
        Assert.assertTrue((vector.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((byArray.length == n2 ? 1 : 0) != 0);
    }

    int checkWireElement(byte[] byArray, int n, int n2, int n3) {
        Assert.assertTrue((String)"Incorrect element magic[0]", (byArray[n++] == 106 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect element magic[1]", (byArray[n++] == 120 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect element magic[2]", (byArray[n++] == 101 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect element magic[3]", (byArray[n++] == 108 ? 1 : 0) != 0);
        Assert.assertTrue((String)("namespace id=" + byArray[n]), (byArray[n++] == n3 ? 1 : 0) != 0);
        Assert.assertTrue((byArray[n++] == 1 ? 1 : 0) != 0);
        String string = "elem" + n2;
        n = this.checkWireString(byArray, n, "elem" + n2);
        n = this.checkWireString(byArray, n, this.testTypes[n2 % this.testTypes.length].toString());
        int n4 = n2 + 10;
        Assert.assertTrue((byArray[n++] == (n4 >> 24 & 0xFF) ? 1 : 0) != 0);
        Assert.assertTrue((byArray[n++] == (n4 >> 16 & 0xFF) ? 1 : 0) != 0);
        Assert.assertTrue((byArray[n++] == (n4 >> 8 & 0xFF) ? 1 : 0) != 0);
        Assert.assertTrue((String)("at byte " + n), (byArray[n++] == (n4 >> 0 & 0xFF) ? 1 : 0) != 0);
        int n5 = 0;
        while (n5 < n4) {
            Assert.assertTrue((byArray[n++] == n5 ? 1 : 0) != 0);
            ++n5;
        }
        return n;
    }

    int checkWireString(byte[] byArray, int n, String string) {
        byte[] byArray2 = string.getBytes();
        int n2 = byArray2.length;
        Assert.assertTrue((byArray[n++] == n2 >> 8 ? 1 : 0) != 0);
        Assert.assertTrue((byArray[n++] == (n2 & 0xFF) ? 1 : 0) != 0);
        int n3 = 0;
        while (n3 < n2) {
            Assert.assertTrue((String)("string wrong at byte " + n3), (byArray[n++] == byArray2[n3] ? 1 : 0) != 0);
            ++n3;
        }
        return n;
    }

    String getWireString(byte[] byArray, int n) {
        int n2 = (byArray[n] << 8) + byArray[n + 1];
        Assert.assertTrue((String)("Name too long: " + n2), (n2 < 50 ? 1 : 0) != 0);
        try {
            return new String(byArray, n + 2, n2, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Assert.fail((String)unsupportedEncodingException.toString());
            return null;
        }
    }

    int skipWireString(byte[] byArray, int n) {
        int n2 = (byArray[n] << 8) + byArray[n + 1];
        Assert.assertTrue((String)("Name too long: " + n2), (n2 < 50 ? 1 : 0) != 0);
        return n + 2 + n2;
    }

    void printMessage(String string, Message message) {
        System.out.println(string + ":");
        MessageElementEnumeration messageElementEnumeration = message.getElements();
        while (messageElementEnumeration.hasMoreElements()) {
            MessageElement messageElement = (MessageElement)messageElementEnumeration.nextElement();
            this.printElement(messageElement);
        }
    }

    void printElement(MessageElement messageElement) {
        System.out.println(" name: " + messageElement.getName());
        MimeMediaType mimeMediaType = messageElement.getType();
        if (mimeMediaType != null) {
            System.out.println(" type: " + mimeMediaType);
        }
        if (mimeMediaType != null && mimeMediaType.getType().equals("text")) {
            System.out.println(" value: " + new String(messageElement.getBytesOffset(), messageElement.getOffset(), messageElement.getLength()));
        } else {
            byte[] byArray = messageElement.getBytesOffset();
            int n = messageElement.getOffset() + messageElement.getLength();
            int n2 = 0;
            int n3 = messageElement.getOffset();
            while (n3 < n) {
                if (n2 == 0) {
                    System.out.print(" value: " + byArray[n3]);
                    ++n2;
                } else {
                    System.out.print(" " + byArray[n3]);
                    ++n2;
                }
                if (n2 == 20) {
                    System.out.println("");
                    n2 = 0;
                }
                ++n3;
            }
            if (n2 != 0) {
                System.out.println("");
            }
        }
        System.out.println("");
    }

    void dumpBytes(byte[] byArray) {
        System.out.println("length = " + byArray.length);
        int n = 0;
        while (n < byArray.length) {
            System.out.print("b[" + n + "]=" + byArray[n] + " 0x" + Integer.toHexString(byArray[n]));
            char c = (char)byArray[n];
            if (c < ' ') {
                System.out.println();
            } else {
                System.out.println(" '" + c + "'");
            }
            ++n;
        }
    }

    boolean referenceIsIn(MessageElement messageElement, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement() != messageElement) continue;
            return true;
        }
        return false;
    }

    MessageElement removeElement(Vector vector, String string) {
        int n = 0;
        while (n < vector.size()) {
            MessageElement messageElement = (MessageElement)vector.get(n);
            if (messageElement.getName().equals(string)) {
                vector.remove(n);
                return messageElement;
            }
            ++n;
        }
        return null;
    }

    MessageWireFormat getXMLMessageFormat() {
        MimeMediaType mimeMediaType = new MimeMediaType("text/xml");
        return MessageWireFormatFactory.newMessageWireFormat(mimeMediaType);
    }

    MessageWireFormat getBinaryMessageFormat() {
        MimeMediaType mimeMediaType = new MimeMediaType("application/x-jxta-msg");
        return MessageWireFormatFactory.newMessageWireFormat(mimeMediaType);
    }

    public static void main(String[] stringArray) {
        new TestRunner();
        TestRunner.main((String[])new String[]{"net.jxta.test.endpoint.MessageTest"});
    }

    static class BAIS
    extends ByteArrayInputStream {
        boolean closed = false;

        public BAIS(byte[] byArray) {
            super(byArray);
        }

        public void close() throws IOException {
            this.closed = true;
            super.close();
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

