/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.test.cm;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class ExpirationList {
    Hashtable table = new Hashtable();
    static final int SCHEDULE = 1;
    static final int CANCEL = 2;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.out.println("Usage: java net.jxta.test.cm.ExpirationList db_file");
        } else {
            File file = new File(stringArray[0]);
            ExpirationList expirationList = new ExpirationList();
            expirationList.readList(file);
            expirationList.printList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void readList(File file) throws IOException {
        DataInputStream dataInputStream = null;
        try {
            try {
                dataInputStream = new DataInputStream(new FileInputStream(file));
                this.readList(dataInputStream);
            }
            catch (EOFException eOFException) {
                Object var5_4 = null;
                if (dataInputStream == null) return;
                dataInputStream.close();
                return;
            }
            Object var5_3 = null;
            if (dataInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (dataInputStream == null) throw throwable;
            dataInputStream.close();
            throw throwable;
        }
        dataInputStream.close();
    }

    void readList(DataInputStream dataInputStream) throws IOException {
        boolean bl = false;
        while (true) {
            int n = dataInputStream.readInt();
            File file = new File(dataInputStream.readUTF());
            long l = dataInputStream.readLong();
            long l2 = dataInputStream.readLong();
            if (!file.exists()) continue;
            switch (n) {
                case 1: {
                    if (l <= System.currentTimeMillis()) break;
                    this.table.put(file, new Entry(file, l, l2));
                    break;
                }
                case 2: {
                    this.table.remove(file);
                }
            }
        }
    }

    public void printList() {
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            Entry entry = (Entry)enumeration.nextElement();
            System.out.println(entry);
        }
    }

    class Entry {
        File file;
        long timeInMyCache;
        long timeForOthers;

        Entry(File file, long l, long l2) {
            this.file = file;
            this.timeInMyCache = l;
            this.timeForOthers = l2;
        }

        public String toString() {
            return "" + this.file + " " + this.timeInMyCache + " " + this.timeForOthers;
        }
    }
}

