/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.document.Element;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.id.ID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.ModuleSpecID;

public abstract class PeerGroupAdvertisement
extends Advertisement
implements Cloneable {
    private PeerGroupID gid = null;
    private ModuleSpecID specId = null;
    private String name = null;
    private String description = null;
    private Hashtable serviceParams = new Hashtable();

    public static String getAdvertisementType() {
        return "jxta:PGA";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ModuleSpecID getModuleSpecID() {
        return this.specId == null ? null : (ModuleSpecID)this.specId.clone();
    }

    public void setModuleSpecID(ModuleSpecID moduleSpecID) {
        this.specId = moduleSpecID == null ? null : (ModuleSpecID)moduleSpecID.clone();
    }

    public PeerGroupID getPeerGroupID() {
        return this.gid == null ? null : (PeerGroupID)this.gid.clone();
    }

    public void setPeerGroupID(PeerGroupID peerGroupID) {
        this.gid = peerGroupID == null ? null : (PeerGroupID)peerGroupID.clone();
    }

    public ID getID() {
        return this.gid == null ? null : (ID)this.gid.clone();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setServiceParams(Hashtable hashtable) {
        if (hashtable == null) {
            this.serviceParams = new Hashtable();
            return;
        }
        Hashtable<Object, StructuredDocument> hashtable2 = new Hashtable<Object, StructuredDocument>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ID iD = (ID)enumeration.nextElement();
            Element element = (Element)hashtable.get(iD);
            StructuredDocument structuredDocument = StructuredDocumentUtils.copyAsDocument(element);
            hashtable2.put(iD.clone(), structuredDocument);
        }
        this.serviceParams = hashtable2;
    }

    public Hashtable getServiceParams() {
        Hashtable<Object, StructuredDocument> hashtable = new Hashtable<Object, StructuredDocument>();
        Enumeration enumeration = this.serviceParams.keys();
        while (enumeration.hasMoreElements()) {
            ID iD = (ID)enumeration.nextElement();
            Element element = (Element)this.serviceParams.get(iD);
            StructuredDocument structuredDocument = StructuredDocumentUtils.copyAsDocument(element);
            hashtable.put(iD.clone(), structuredDocument);
        }
        return hashtable;
    }

    public void putServiceParam(ID iD, Element element) {
        if (element == null) {
            this.serviceParams.remove(iD);
            return;
        }
        StructuredDocument structuredDocument = StructuredDocumentUtils.copyAsDocument(element);
        this.serviceParams.put(iD.clone(), structuredDocument);
    }

    public StructuredDocument getServiceParam(ID iD) {
        Element element = (Element)this.serviceParams.get(iD);
        if (element == null) {
            return null;
        }
        StructuredDocument structuredDocument = StructuredDocumentUtils.copyAsDocument(element);
        return structuredDocument;
    }

    public StructuredDocument removeServiceParam(ID iD) {
        Element element = (Element)this.serviceParams.remove(iD);
        if (element == null) {
            return null;
        }
        StructuredDocument structuredDocument = StructuredDocumentUtils.copyAsDocument(element);
        return structuredDocument;
    }
}

