/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.xml;

import java.io.IOException;
import java.io.InputStream;

public class XmlParser {
    static final int NO_TAG = 0;
    static final int PARSING_TAG = 1;
    static final int EAT_TAG = 2;
    static final int EAT_TOKEN = 3;
    static final int NONE = 0;
    static final int NAME = 1;
    static final int VALUE_START_QUOTE = 2;
    static final int VALUE = 3;
    static final int VALUE_END_QUOTE = 4;
    static final byte[] space = new byte[]{32};

    static void callStartTag(byte[] byArray, int n, int n2, ParserCallback parserCallback) throws Exception {
        int n3 = n + 1;
        int n4 = n + n2;
        while (n3 < n4) {
            if (Character.isWhitespace((char)byArray[n3]) || byArray[n3] == 62) break;
            ++n3;
        }
        parserCallback.startTag(byArray, n + 1, n3 - n - 1);
    }

    public static String getTagName(byte[] byArray, int n, int n2) {
        int n3 = n + 1;
        int n4 = n + n2;
        while (n3 < n4) {
            if (Character.isWhitespace((char)byArray[n3]) || byArray[n3] == 62) break;
            ++n3;
        }
        return new String(byArray, n + 1, n3 - n - 1);
    }

    public static String getAttributeValue(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = XmlParser.indexOf(byArray, byArray2, n, n2);
        int n4 = 0;
        if (n3 == -1) {
            return null;
        }
        if (byArray2[n3 += byArray.length + 2] == 34 || byArray2[n3] == 39) {
            ++n3;
        }
        int n5 = n3;
        while (n5 < n + n2) {
            if (byArray2[n5] == 39 || byArray2[n5] == 34 || byArray2[n5] == 62 || Character.isWhitespace((char)byArray2[n5])) {
                n4 = n5 - n3;
                break;
            }
            ++n5;
        }
        return new String(byArray2, n3, n4);
    }

    public static int getIntAttribute(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4 = XmlParser.indexOf(byArray, byArray2, n, n2);
        boolean bl = false;
        int n5 = 0;
        if (n4 == -1) {
            return n3;
        }
        if (byArray2[n4 += byArray.length + 2] == 34 || byArray2[n4] == 39) {
            ++n4;
        }
        int n6 = n4;
        while (n6 < n + n2) {
            if (byArray2[n6] == 39 || byArray2[n6] == 34 || byArray2[n6] == 62 || Character.isWhitespace((char)byArray2[n6])) break;
            if (byArray2[n6] > 57 || byArray2[n6] < 48) {
                return n3;
            }
            n5 = n5 * 10 + (byArray2[n6] - 48);
            ++n6;
        }
        return n5;
    }

    public static long parse(InputStream inputStream, byte[] byArray, ParserCallback parserCallback) throws IOException, Exception {
        int n;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = -1;
        boolean bl3 = false;
        boolean bl4 = false;
        long l = 0L;
        while ((n = inputStream.read(byArray, n5, byArray.length - n5)) > 0) {
            int n8 = n5 + n;
            l += (long)n;
            int n9 = n5;
            while (n9 < n8) {
                block0 : switch (n2) {
                    case 3: {
                        switch (byArray[n9]) {
                            case 9: 
                            case 10: 
                            case 13: 
                            case 32: {
                                n6 = n9;
                                n2 = 0;
                                break;
                            }
                            case 60: {
                                n2 = 1;
                                n4 = n9;
                                bl = false;
                                bl2 = false;
                            }
                        }
                        n3 = n9 + 1;
                        break;
                    }
                    case 0: {
                        switch (byArray[n9]) {
                            case 9: 
                            case 10: 
                            case 13: 
                            case 32: {
                                if (!bl4) break;
                                throw new Exception("Bare & found.");
                            }
                            case 60: {
                                if (bl4) {
                                    throw new Exception("Bare & found.");
                                }
                                if (n3 != n9) {
                                    parserCallback.chars(byArray, n3, n9 - n3);
                                }
                                n2 = 1;
                                n4 = n9;
                                bl = false;
                                break;
                            }
                            case 38: {
                                if (bl4) {
                                    throw new Exception("Unescaped & found.");
                                }
                                bl4 = true;
                                break;
                            }
                            case 59: {
                                if (!bl4) break;
                                bl4 = false;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (byArray[n9]) {
                            case 32: {
                                if (n7 == 60) {
                                    throw new Exception("Unescaped < in char data.");
                                }
                                if (!bl3 || !bl4) break block0;
                                throw new Exception("Bare & found in attribute value.");
                            }
                            case 34: 
                            case 39: {
                                if (!bl3 && n7 == 61) {
                                    bl3 = true;
                                    break block0;
                                }
                                if (!bl3) break block0;
                                if (bl4) {
                                    throw new Exception("Invalid use of & in attribute value.");
                                }
                                bl3 = false;
                                break block0;
                            }
                            case 60: {
                                if (bl3) {
                                    throw new Exception("Unescaped " + (char)byArray[n9] + " character found in " + " attribute value.");
                                }
                            }
                            case 47: {
                                if (n9 == n4 + 1) {
                                    bl = true;
                                    break block0;
                                }
                                bl2 = true;
                                break block0;
                            }
                            case 62: {
                                if (bl3) {
                                    throw new Exception("Attribute value must be terminated by a ' or \".");
                                }
                                if (bl2 || !bl) {
                                    XmlParser.callStartTag(byArray, n4, n9 - n4 + 1, parserCallback);
                                    XmlParser.iterateAttributes(byArray, n4, n9 - n4 + 1, parserCallback);
                                }
                                if (bl2) {
                                    parserCallback.endTag(byArray, n4 + 1, n9 - n4 - 3);
                                } else if (bl) {
                                    parserCallback.endTag(byArray, n4 + 2, n9 - n4 - 2);
                                }
                                n2 = 0;
                                n3 = n9 + 1;
                                n6 = n9 + 1;
                                break block0;
                            }
                            case 38: {
                                if (!bl3) break block0;
                                if (bl4) {
                                    throw new Exception("Invalid & usage.");
                                }
                                bl4 = true;
                                break block0;
                            }
                            case 59: {
                                if (!bl4) break block0;
                                bl4 = false;
                                break block0;
                            }
                        }
                        if (n7 == 61) {
                            throw new Exception("Attribute values must be quoted and the quotes must immediately follow the = sign.");
                        }
                        if (!bl2) break;
                        bl2 = false;
                        break;
                    }
                    case 2: {
                        if (byArray[n9] != 62) break;
                        n2 = 0;
                        n3 = n9 + 1;
                        n6 = n9 + 1;
                    }
                }
                n7 = byArray[n9];
                ++n9;
            }
            switch (n2) {
                case 0: {
                    if (n3 < n8) {
                        if (n6 - n3 > 0) {
                            parserCallback.chars(byArray, n3, n6 - n3);
                        }
                        if (n8 - n6 < byArray.length) {
                            System.arraycopy(byArray, n6, byArray, 0, n8 - n6);
                            n5 = n8 - n6;
                        } else {
                            n2 = 3;
                            n5 = 0;
                        }
                    }
                    n3 = 0;
                    n6 = 0;
                    n3 = 0;
                    break;
                }
                case 1: {
                    if (n4 > n8 / 2) {
                        System.arraycopy(byArray, n4, byArray, 0, n8 - n4);
                        n5 = n8 - n4;
                        n4 = 0;
                        break;
                    }
                    n2 = 2;
                    n4 = 0;
                    n5 = 0;
                }
            }
        }
        return l;
    }

    static void iterateAttributes(byte[] byArray, int n, int n2, ParserCallback parserCallback) throws Exception {
        int n3 = n + n2;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n < n3) {
            if (Character.isWhitespace((char)byArray[n]) || byArray[n] == 62) break;
            ++n;
        }
        int n8 = n;
        while (n8 < n3) {
            switch (n4) {
                case 0: {
                    if (Character.isWhitespace((char)byArray[n8])) break;
                    n4 = 1;
                    n5 = n8;
                    break;
                }
                case 1: {
                    if (byArray[n8] != 61) break;
                    n6 = n8 - n5;
                    n4 = 2;
                    break;
                }
                case 2: {
                    if (byArray[n8] != 39 && byArray[n8] != 34) {
                        throw new Exception("Invalid attribute value encoding.");
                    }
                    n4 = 3;
                    n7 = n8;
                    break;
                }
                case 3: {
                    if (!Character.isWhitespace((char)byArray[n8]) && byArray[n8] != 39 && byArray[n8] != 34 && byArray[n8] != 62) break;
                    parserCallback.attribute(byArray, n5, n6, byArray, n7 + 1, n8 - n7 - 1);
                    n4 = 4;
                    break;
                }
                case 4: {
                    n4 = 0;
                }
            }
            ++n8;
        }
    }

    public static boolean startsWith(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (byArray.length <= n2) {
            int n3 = 0;
            while (n3 < byArray.length) {
                if (Character.toUpperCase((char)byArray2[n3 + n]) != byArray[n3]) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) throws IOException, Exception {
        XmlParser xmlParser = new XmlParser();
        ParserCallback parserCallback = new ParserCallback(){

            public void startTag(byte[] byArray, int n, int n2) {
                System.out.println("Start: " + new String(byArray, n, n2));
            }

            public void attribute(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
            }

            public void chars(byte[] byArray, int n, int n2) {
                System.out.println("Chars: ." + new String(byArray, n, n2) + ".");
            }

            public void endTag(byte[] byArray, int n, int n2) {
                System.out.println("End: " + new String(byArray, n, n2));
            }
        };
        byte[] byArray = new byte[64];
        InputStream inputStream = System.in;
        XmlParser.parse(inputStream, byArray, parserCallback);
    }

    private static int indexOf(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            int n4 = 0;
            while (n4 < byArray.length) {
                if (Character.toUpperCase((char)byArray2[n3 + n4]) != byArray[n4]) break;
                ++n4;
            }
            if (n4 == byArray.length) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static interface ParserCallback {
        public void startTag(byte[] var1, int var2, int var3) throws Exception;

        public void attribute(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6) throws Exception;

        public void chars(byte[] var1, int var2, int var3) throws Exception;

        public void endTag(byte[] var1, int var2, int var3) throws Exception;
    }

    public static class Exception
    extends java.lang.Exception {
        java.lang.Exception nested;

        public Exception(String string) {
            super(string);
        }

        public Exception(String string, java.lang.Exception exception) {
            super(string);
            this.nested = exception;
        }

        public java.lang.Exception getNestedException() {
            return this.nested;
        }
    }
}

