/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import net.jxta.endpoint.Message;
import net.jxta.impl.util.PriorityQueue;

class IncomingMessageQueue
extends PriorityQueue {
    int capacity;
    int total;
    long nextExpected;

    IncomingMessageQueue(int n) {
        this.initialize(n, 2);
        this.capacity = n;
    }

    protected boolean lessThan(Object object, Object object2) {
        return ((IncomingMessage)object).seq < ((IncomingMessage)object2).seq;
    }

    public synchronized void put(Message message, long l) {
        this.put(new IncomingMessage(message, l));
        ++this.total;
        this.notifyAll();
    }

    public synchronized long popUntilBreakInSequence(long l) {
        while (this.top() != null) {
            IncomingMessage incomingMessage = (IncomingMessage)this.top();
            if (l + 1L != incomingMessage.seq) break;
            l = incomingMessage.seq;
            this.pop();
        }
        return l;
    }

    public synchronized Message pop(long l) throws InterruptedException {
        IncomingMessage incomingMessage;
        long l2 = System.currentTimeMillis();
        while (true) {
            if (this.top() != null) {
                long l3 = l - (System.currentTimeMillis() - l2);
                if (l3 > 0L) {
                    this.wait(l3);
                    continue;
                }
            }
            if ((incomingMessage = (IncomingMessage)this.top()) == null) {
                return null;
            }
            if (incomingMessage.seq == this.nextExpected) break;
        }
        this.pop();
        --this.total;
        this.nextExpected = incomingMessage.seq + 1L;
        return incomingMessage.msg;
    }

    public int getFreeSlots() {
        return this.capacity - this.total;
    }

    class IncomingMessage {
        Message msg;
        long seq;

        IncomingMessage(Message message, long l) {
            this.msg = message;
            this.seq = l;
        }
    }
}

