/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.resolver;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.id.ID;
import net.jxta.peer.PeerID;
import net.jxta.protocol.PeerAdvertisement;

public class AdvertisementCache {
    private static final int INITIAL_ENTRY = 1024;
    private int maxSize = 5120;
    private int entry = 0;
    private Hashtable cache = new Hashtable(1024);

    private synchronized void storeAdvertisement(PeerAdvertisement peerAdvertisement) throws IOException {
        PeerID peerID = peerAdvertisement.getPeerID();
        if (this.entry <= this.maxSize) {
            if (this.cache.containsKey(peerID.toString())) {
                this.cache.put(peerID.toString(), peerAdvertisement);
                ++this.entry;
            }
        } else {
            throw new IOException("Reached maxSize " + this.maxSize);
        }
    }

    public synchronized void remove(String string) {
        this.cache.remove(string);
    }

    public synchronized Enumeration iterate() {
        return this.cache.keys();
    }

    public ID get(String string) {
        return (ID)this.cache.get(string);
    }

    public synchronized void flush() {
        this.cache.clear();
    }

    public synchronized void checkPoint(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(this.cache);
        objectOutputStream.flush();
        fileOutputStream.close();
    }

    public synchronized void initialize(String string) throws ClassNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        try {
            this.cache = (Hashtable)objectInputStream.readObject();
            fileInputStream.close();
            this.cache.clear();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
    }

    public synchronized Advertisement readAdvertisement(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            Advertisement advertisement = AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), fileInputStream);
            return advertisement;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }
}

