/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.PeerGroupAdvertisement;

public class PeerGroupAdv
extends PeerGroupAdvertisement {
    private static final String nameTag = "Name";
    private static final String gidTag = "GID";
    private static final String descTag = "Desc";
    private static final String msidTag = "MSID";
    private static final String svcTag = "Svc";
    private static final String mcidTag = "MCID";
    private static final String paramTag = "Parm";
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public PeerGroupAdv() {
    }

    public PeerGroupAdv(Element element) {
        this.initialize(element);
    }

    public void initialize(Element element) {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = PeerGroupAdv.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(element)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement textElement = (TextElement)element;
        if (!textElement.getName().equals(PeerGroupAdvertisement.getAdvertisementType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + textElement.getName());
        }
        this.setDescription(null);
        this.setName(null);
        this.setModuleSpecID(null);
        this.setPeerGroupID(null);
        Enumeration enumeration = textElement.getChildren();
        while (enumeration.hasMoreElements()) {
            Object object;
            TextElement textElement2 = (TextElement)enumeration.nextElement();
            if (textElement2.getName().equals(nameTag)) {
                this.setName(textElement2.getTextValue());
                continue;
            }
            if (textElement2.getName().equals(descTag)) {
                this.setDescription(textElement2.getTextValue());
                continue;
            }
            if (textElement2.getName().equals(gidTag)) {
                try {
                    object = new URL(textElement2.getTextValue());
                    this.setPeerGroupID((PeerGroupID)IDFactory.fromURL((URL)object));
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException("Bad pipe ID in advertisement");
                }
                catch (UnknownServiceException unknownServiceException) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (textElement2.getName().equals(msidTag)) {
                try {
                    object = new URL(textElement2.getTextValue());
                    this.setModuleSpecID((ModuleSpecID)IDFactory.fromURL((URL)object));
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException("Bad pipe ID in advertisement");
                }
                catch (UnknownServiceException unknownServiceException) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (!textElement2.getName().equals(svcTag)) continue;
            object = textElement2.getChildren();
            String string = null;
            TextElement textElement3 = null;
            while (object.hasMoreElements()) {
                TextElement textElement4 = (TextElement)object.nextElement();
                if (textElement4.getName().equals(mcidTag)) {
                    string = textElement4.getTextValue();
                    continue;
                }
                if (!textElement4.getName().equals(paramTag)) continue;
                textElement3 = textElement4;
            }
            if (string == null || textElement3 == null) continue;
            try {
                this.putServiceParam(IDFactory.fromURL(new URL(string)), textElement3);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("Bad pipe ID in advertisement");
            }
            catch (UnknownServiceException unknownServiceException) {
                throw new IllegalArgumentException("Unusable ID in advertisement");
            }
        }
    }

    public Document getDocument(MimeMediaType mimeMediaType) {
        StructuredTextDocument structuredTextDocument = null;
        try {
            structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mimeMediaType, PeerGroupAdvertisement.getAdvertisementType());
        }
        catch (Throwable throwable) {
            return null;
        }
        Element element = structuredTextDocument.createElement(gidTag, this.getID().toString());
        structuredTextDocument.appendChild(element);
        element = structuredTextDocument.createElement(msidTag, this.getModuleSpecID().toString());
        structuredTextDocument.appendChild(element);
        element = structuredTextDocument.createElement(nameTag, this.getName());
        structuredTextDocument.appendChild(element);
        String string = this.getDescription();
        if (null != string) {
            element = structuredTextDocument.createElement(descTag, string);
            structuredTextDocument.appendChild(element);
        }
        Hashtable hashtable = this.getServiceParams();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ModuleClassID moduleClassID = (ModuleClassID)enumeration.nextElement();
            TextElement textElement = structuredTextDocument.createElement(svcTag);
            structuredTextDocument.appendChild((Element)textElement);
            element = structuredTextDocument.createElement(mcidTag, moduleClassID.toString());
            textElement.appendChild(element);
            element = (Element)hashtable.get(moduleClassID);
            StructuredDocumentUtils.copyElements(structuredTextDocument, textElement, element);
        }
        return structuredTextDocument;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return PeerGroupAdvertisement.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new PeerGroupAdv();
        }

        public Advertisement newInstance(Element element) {
            return new PeerGroupAdv(element);
        }
    }
}

