/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleSpecAdvertisement;
import net.jxta.protocol.PipeAdvertisement;

public class ModuleSpecAdv
extends ModuleSpecAdvertisement {
    private static final String idTag = "MSID";
    private static final String nameTag = "Name";
    private static final String creatorTag = "Crtr";
    private static final String uriTag = "SURI";
    private static final String versTag = "Vers";
    private static final String descTag = "Desc";
    private static final String paramTag = "Parm";
    private static final String proxyIdTag = "Proxy";
    private static final String authIdTag = "Auth";
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public ModuleSpecAdv() {
    }

    public ModuleSpecAdv(Element element) {
        this.initialize(element);
    }

    public void initialize(Element element) {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = ModuleSpecAdv.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(element)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement textElement = (TextElement)element;
        if (!textElement.getName().equals(ModuleSpecAdvertisement.getAdvertisementType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + textElement.getName());
        }
        this.setDescription(null);
        this.setName(null);
        this.setModuleSpecID(null);
        this.setCreator(null);
        this.setSpecURI(null);
        this.setVersion(null);
        this.setDescription(null);
        this.setPipeAdvertisement(null);
        this.setProxySpecID(null);
        this.setAuthSpecID(null);
        this.setParam(null);
        Enumeration enumeration = textElement.getChildren();
        while (enumeration.hasMoreElements()) {
            Object object;
            TextElement textElement2 = (TextElement)enumeration.nextElement();
            String string = textElement2.getName();
            if (string.equals(nameTag)) {
                this.setName(textElement2.getTextValue());
                continue;
            }
            if (string.equals(descTag)) {
                this.setDescription(textElement2.getTextValue());
                continue;
            }
            if (string.equals(idTag)) {
                try {
                    object = new URL(textElement2.getTextValue());
                    this.setModuleSpecID((ModuleSpecID)IDFactory.fromURL((URL)object));
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException("Bad spec ID in advertisement");
                }
                catch (UnknownServiceException unknownServiceException) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (string.equals(creatorTag)) {
                this.setCreator(textElement2.getTextValue());
                continue;
            }
            if (string.equals(uriTag)) {
                this.setSpecURI(textElement2.getTextValue());
                continue;
            }
            if (string.equals(versTag)) {
                this.setVersion(textElement2.getTextValue());
                continue;
            }
            if (string.equals(paramTag)) {
                object = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(textElement.getRoot().getMimeType(), paramTag, textElement2.getTextValue());
                StructuredDocumentUtils.copyChildren((StructuredDocument)object, (Element)object, textElement2);
                this.setParam((StructuredDocument)object);
                continue;
            }
            if (string.equals(proxyIdTag)) {
                try {
                    object = new URL(textElement2.getTextValue());
                    this.setProxySpecID((ModuleSpecID)IDFactory.fromURL((URL)object));
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException("Bad proxy spec ID in advertisement");
                }
                catch (UnknownServiceException unknownServiceException) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (string.equals(authIdTag)) {
                try {
                    object = new URL(textElement2.getTextValue());
                    this.setAuthSpecID((ModuleSpecID)IDFactory.fromURL((URL)object));
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException("Bad authenticator spec ID in advertisement");
                }
                catch (UnknownServiceException unknownServiceException) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (!string.equals(PipeAdvertisement.getAdvertisementType())) continue;
            try {
                object = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(textElement2);
                this.setPipeAdvertisement((PipeAdvertisement)object);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Bad pipe advertisement in advertisement");
            }
        }
    }

    public Document getDocument(MimeMediaType mimeMediaType) {
        Object object;
        PipeAdvertisement pipeAdvertisement;
        StructuredTextDocument structuredTextDocument = null;
        try {
            structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mimeMediaType, ModuleSpecAdvertisement.getAdvertisementType());
        }
        catch (Throwable throwable) {
            return null;
        }
        Element element = structuredTextDocument.createElement(idTag, this.getModuleSpecID().toString());
        structuredTextDocument.appendChild(element);
        element = structuredTextDocument.createElement(nameTag, this.getName());
        structuredTextDocument.appendChild(element);
        element = structuredTextDocument.createElement(creatorTag, this.getCreator());
        structuredTextDocument.appendChild(element);
        element = structuredTextDocument.createElement(uriTag, this.getSpecURI());
        structuredTextDocument.appendChild(element);
        element = structuredTextDocument.createElement(versTag, this.getVersion());
        structuredTextDocument.appendChild(element);
        String string = this.getDescription();
        if (null != string) {
            element = structuredTextDocument.createElement(descTag, string);
            structuredTextDocument.appendChild(element);
        }
        if ((element = this.getParam()) != null) {
            StructuredDocumentUtils.copyElements(structuredTextDocument, structuredTextDocument, element);
        }
        if ((pipeAdvertisement = this.getPipeAdvertisement()) != null) {
            object = (StructuredTextDocument)pipeAdvertisement.getDocument(new MimeMediaType("text", "xml"));
            StructuredDocumentUtils.copyElements(structuredTextDocument, structuredTextDocument, (Element)object);
        }
        if ((object = this.getProxySpecID()) != null) {
            element = structuredTextDocument.createElement(proxyIdTag, ((ID)object).toString());
            structuredTextDocument.appendChild(element);
        }
        if ((object = this.getAuthSpecID()) != null) {
            element = structuredTextDocument.createElement(authIdTag, ((ID)object).toString());
            structuredTextDocument.appendChild(element);
        }
        return structuredTextDocument;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return ModuleSpecAdvertisement.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new ModuleSpecAdv();
        }

        public Advertisement newInstance(Element element) {
            return new ModuleSpecAdv(element);
        }
    }
}

