/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.protocol.DiscoveryQueryMsg;

public class DiscoveryQuery
extends DiscoveryQueryMsg {
    private static final String typeTag = "Type";
    private static final String peerAdvTag = "PeerAdv";
    private static final String thresholdTag = "Threshold";
    private static final String queryAttrTag = "Attr";
    private static final String queryValueTag = "Value";

    public DiscoveryQuery(InputStream inputStream) throws IOException {
        StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), inputStream);
        this.readIt(structuredTextDocument);
    }

    public DiscoveryQuery(TextElement textElement) {
        if (!DiscoveryQueryMsg.getAdvertisementType().equals(textElement.getName())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + textElement.getName());
        }
        this.readIt(textElement);
    }

    public void readIt(TextElement textElement) {
        Enumeration enumeration = textElement.getChildren();
        while (enumeration.hasMoreElements()) {
            TextElement textElement2 = (TextElement)enumeration.nextElement();
            if (textElement2.getName().equals(typeTag)) {
                this.type = Integer.parseInt(textElement2.getTextValue());
                continue;
            }
            if (textElement2.getName().equals(thresholdTag)) {
                this.setThreshold(Integer.parseInt(textElement2.getTextValue()));
                continue;
            }
            if (textElement2.getName().equals(peerAdvTag)) {
                this.setPeerAdv(textElement2.getTextValue());
                continue;
            }
            if (textElement2.getName().equals(queryAttrTag)) {
                this.setAttr(textElement2.getTextValue());
                continue;
            }
            if (!textElement2.getName().equals(queryValueTag)) continue;
            this.setValue(textElement2.getTextValue());
        }
    }

    public DiscoveryQuery(int n, String string, String string2, String string3, int n2) {
        this.setDiscoveryType(n);
        this.setThreshold(n2);
        this.setPeerAdv(string);
        this.setAttr(string2);
        this.setValue(string3);
    }

    public Document getDocument(MimeMediaType mimeMediaType) throws Exception {
        StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mimeMediaType, DiscoveryQueryMsg.getAdvertisementType());
        Element element = structuredTextDocument.createElement((Object)typeTag, (Object)Integer.toString(this.type));
        structuredTextDocument.appendChild(element);
        element = structuredTextDocument.createElement((Object)thresholdTag, (Object)Integer.toString(this.getThreshold()));
        structuredTextDocument.appendChild(element);
        element = structuredTextDocument.createElement((Object)peerAdvTag, (Object)this.getPeerAdv());
        structuredTextDocument.appendChild(element);
        String string = this.getAttr();
        if (null != string && string.length() > 0) {
            element = structuredTextDocument.createElement((Object)queryAttrTag, (Object)string);
            structuredTextDocument.appendChild(element);
            String string2 = this.getValue();
            if (null == string2 || 0 == string2.length()) {
                throw new IllegalStateException("Query value not initialized");
            }
            element = structuredTextDocument.createElement((Object)queryValueTag, (Object)string2);
            structuredTextDocument.appendChild(element);
        }
        return structuredTextDocument;
    }

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            StructuredTextDocument structuredTextDocument = (StructuredTextDocument)this.getDocument(new MimeMediaType("text/xml"));
            structuredTextDocument.sendToWriter(stringWriter);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

