/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.endpoint.EndpointReceiveQueue;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.pipe.WireHeader;
import net.jxta.impl.pipe.WireInputPipe;
import net.jxta.impl.pipe.WirePrivateOutputPipe;
import net.jxta.impl.pipe.WirePublicOutputPipe;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class WirePipe
implements EndpointListener {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$pipe$WirePipe == null ? (class$net$jxta$impl$pipe$WirePipe = WirePipe.class$("net.jxta.impl.pipe.WirePipe")) : class$net$jxta$impl$pipe$WirePipe).getName());
    private RefPeerGroup myGroup;
    private RendezVousService rendezvous;
    private String localPeerId;
    private Vector inputs;
    private Vector pipemsglisteners;
    private boolean valid;
    private String wireId;
    public static final String WireName = "jxta.service.wirepipe";
    public static final String WireKeywords = "WIRE";
    public static final String WirePrefix = "JxtaWire";
    public static final String WireVersion = "1.0";
    public static final String WireTagName = "JxtaWireHeader";
    public static final int DefaultTTL = 7;
    static /* synthetic */ Class class$net$jxta$impl$pipe$WirePipe;

    public WirePipe(PeerGroup peerGroup, PipeAdvertisement pipeAdvertisement) throws IllegalArgumentException {
        block4: {
            this.myGroup = null;
            this.rendezvous = null;
            this.localPeerId = null;
            this.inputs = null;
            this.pipemsglisteners = null;
            this.valid = false;
            this.wireId = null;
            if (!pipeAdvertisement.getType().equals("JxtaPropagate")) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Wrong PipeService type");
                }
                throw new IllegalArgumentException();
            }
            this.myGroup = (RefPeerGroup)peerGroup;
            this.wireId = pipeAdvertisement.getPipeID().toString();
            this.rendezvous = this.myGroup.getRendezVousService();
            try {
                this.rendezvous.addPropagateListener(WireName + this.wireId, this);
            }
            catch (Exception exception) {
                this.valid = false;
                if (!LOG.isEnabledFor(Priority.WARN)) break block4;
                LOG.warn((Object)"Cannot register EndpointService");
            }
        }
        this.inputs = new Vector();
        this.pipemsglisteners = new Vector();
        this.localPeerId = this.myGroup.getPeerID().toString();
        this.valid = true;
    }

    public InputPipe createInputPipe() throws IOException {
        if (!this.valid) {
            throw new IOException();
        }
        WireInputPipe wireInputPipe = new WireInputPipe(this);
        return wireInputPipe;
    }

    public InputPipe createInputPipe(PipeMsgListener pipeMsgListener) throws IOException {
        if (!this.valid) {
            throw new IOException();
        }
        WireInputPipe wireInputPipe = new WireInputPipe(this, pipeMsgListener);
        return wireInputPipe;
    }

    public synchronized void registerQueue(EndpointReceiveQueue endpointReceiveQueue) {
        this.inputs.addElement(endpointReceiveQueue);
    }

    public synchronized void forgetQueue(EndpointReceiveQueue endpointReceiveQueue) {
        this.inputs.removeElement(endpointReceiveQueue);
    }

    public synchronized void registerPipeMsgListener(PipeMsgListener pipeMsgListener) {
        this.pipemsglisteners.addElement(pipeMsgListener);
    }

    public synchronized void forgetPipeMsgListener(PipeMsgListener pipeMsgListener) {
        this.pipemsglisteners.removeElement(pipeMsgListener);
    }

    public OutputPipe createOutputPipe(long l) throws IOException {
        if (!this.valid) {
            throw new IOException();
        }
        WirePublicOutputPipe wirePublicOutputPipe = null;
        wirePublicOutputPipe = new WirePublicOutputPipe(this, this.wireId);
        return wirePublicOutputPipe;
    }

    public OutputPipe createOutputPipe(Enumeration enumeration, long l) throws IOException {
        if (!this.valid) {
            throw new IOException();
        }
        WirePrivateOutputPipe wirePrivateOutputPipe = null;
        wirePrivateOutputPipe = new WirePrivateOutputPipe(this, this.wireId, enumeration);
        return wirePrivateOutputPipe;
    }

    public void sendMessage(Message message, WireHeader wireHeader) throws IOException {
        message = this.localDemux(message);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"propagating message");
        }
        this.propagate(message, wireHeader);
    }

    public void processIncomingMessage(Message message, EndpointAddress endpointAddress, EndpointAddress endpointAddress2) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processIncominMessage starts");
        }
        WireHeader wireHeader = null;
        try {
            MessageElement messageElement = message.getElement(WireTagName);
            InputStream inputStream = messageElement.getStream();
            if (inputStream != null) {
                wireHeader = new WireHeader(inputStream);
                inputStream.close();
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"No JxtaWireHeader tag. Message is discarded");
            }
            return;
        }
        if (this.isLoopback(wireHeader)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Loopback detected - discard");
            }
            return;
        }
        if (!this.isAlive(wireHeader)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Dead on arrival - discard");
            }
            return;
        }
        message = this.localDemux(message);
        if (!this.isToBePropagated(wireHeader)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Max TTL reached - discard");
            }
            return;
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"repropagating message");
        }
        this.propagate(message, wireHeader);
    }

    private boolean isLoopback(WireHeader wireHeader) {
        Vector vector = wireHeader.getPeers();
        if (vector == null || vector.size() <= 0) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"isLoopback: No peers in header");
            }
            return true;
        }
        String string = null;
        int n = 0;
        while (n < vector.size()) {
            block8: {
                try {
                    string = (String)vector.elementAt(n);
                    if (string.equals(this.localPeerId)) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"isLoopback: local peer is in peers");
                        }
                        return true;
                    }
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block8;
                    LOG.warn((Object)("isLoopback failed with " + exception));
                }
            }
            ++n;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"isLoopback: this message is not a loopback");
        }
        return false;
    }

    private boolean isAlive(WireHeader wireHeader) {
        return true;
    }

    private boolean isToBePropagated(WireHeader wireHeader) {
        wireHeader.setTTL(wireHeader.getTTL() - 1);
        return wireHeader.getTTL() >= 1;
    }

    private synchronized Message localDemux(Message message) {
        Message message2 = null;
        int n = 0;
        while (n < this.inputs.size()) {
            block8: {
                try {
                    EndpointReceiveQueue endpointReceiveQueue = (EndpointReceiveQueue)this.inputs.elementAt(n);
                    if (endpointReceiveQueue != null) {
                        message2 = (Message)message.clone();
                        endpointReceiveQueue.push(message2);
                    }
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block8;
                    LOG.warn((Object)("localDemux failed with " + exception));
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.pipemsglisteners.size()) {
            block9: {
                try {
                    PipeMsgListener pipeMsgListener = (PipeMsgListener)this.pipemsglisteners.elementAt(n2);
                    if (pipeMsgListener != null) {
                        message2 = (Message)message.clone();
                        PipeMsgEvent pipeMsgEvent = new PipeMsgEvent(this, message2);
                        pipeMsgListener.pipeMsgEvent(pipeMsgEvent);
                    }
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block9;
                    LOG.warn((Object)("localDemux failed with " + exception));
                }
            }
            ++n2;
        }
        return message;
    }

    private void addLocalPeer(WireHeader wireHeader) {
        Vector<String> vector = wireHeader.getPeers();
        if (vector == null) {
            vector = new Vector<String>();
        }
        String string = null;
        int n = 0;
        while (n < vector.size()) {
            block6: {
                try {
                    string = (String)vector.elementAt(n);
                    if (string.equals(this.localPeerId)) {
                        return;
                    }
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block6;
                    LOG.warn((Object)("addLocalPeer failed with " + exception));
                }
            }
            ++n;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"Adding local peer id into the header");
        }
        vector.addElement(this.localPeerId);
        wireHeader.setPeers(vector);
    }

    private void propagate(Message message, WireHeader wireHeader) {
        block3: {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"propagate starts");
            }
            this.addLocalPeer(wireHeader);
            try {
                message.addElement(message.newMessageElement(WireTagName, null, wireHeader.getInputStream()));
                this.rendezvous.propagateInGroup(message, WireName, this.wireId, 7, null);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block3;
                LOG.warn((Object)("propagate failed with " + exception));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

