/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.exception.JxtaError;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.tls.JTlsUtil;
import net.jxta.impl.endpoint.tls.TlsConfig;
import net.jxta.impl.peergroup.ConfigDialog;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class Configurator {
    static String configName = "PlatformConfig";
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$peergroup$Configurator == null ? (class$net$jxta$impl$peergroup$Configurator = Configurator.class$("net.jxta.impl.peergroup.Configurator")) : class$net$jxta$impl$peergroup$Configurator).getName());
    PeerAdvertisement advertisement;
    static /* synthetic */ Class class$net$jxta$impl$peergroup$Configurator;

    public Configurator() {
        block11: {
            BufferedReader bufferedReader;
            this.advertisement = null;
            this.load();
            if (!this.fixAdvertisement()) {
                this.adjustLog4JPriority();
                this.checkPassword();
                this.configureTls();
                this.routerRdvMatch();
                return;
            }
            try {
                ConfigDialog configDialog = new ConfigDialog(this.advertisement);
                configDialog.untilDone();
                break block11;
            }
            catch (Throwable throwable) {
                if (throwable instanceof JxtaError) {
                    throw (JxtaError)throwable;
                }
                if (LOG.isEnabledFor(Priority.ERROR)) {
                    LOG.error((Object)"Could not initialize graphical config dialog", throwable);
                }
                bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                try {
                    while (bufferedReader.ready()) {
                        bufferedReader.readLine();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            System.out.println("The window-based configurator does not seem to be usable.");
            System.out.print("Do you want to stop and edit the current configuration ? [no]: ");
            String string = "no";
            try {
                string = bufferedReader.readLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ("yes".equalsIgnoreCase(string)) {
                this.save();
                System.out.println("Exiting; edit the file \"" + configName + "\", remove the file \"reconf\", and then" + ", launch JXTA again.");
                throw new JxtaError("Manual Configuration Requested");
            }
            this.save();
            this.routerRdvMatch();
            System.out.println("Using the current configuration.");
        }
        this.adjustLog4JPriority();
        this.checkPassword();
        this.configureTls();
        this.addRootCert();
        this.save();
        this.routerRdvMatch();
    }

    private void checkPassword() {
        String string = System.getProperty("net.jxta.tls.password");
        String string2 = System.getProperty("net.jxta.tls.principal");
        if (string != null && string2 != null) {
            return;
        }
        if (JTlsUtil.passwdExists()) {
            try {
                new PasswordDialog();
            }
            catch (Throwable throwable) {
                System.out.println("The window-based authenticator does not seem to be usable.");
                System.out.println("You must authenticate through the command-line.");
                throw new JxtaError("Could not authenticate.");
            }
        }
    }

    private void configureTls() {
        String string = this.advertisement.getName();
        String string2 = System.getProperty("net.jxta.tls.password");
        String string3 = System.getProperty("net.jxta.tls.principal");
        System.setProperty("net.jxta.tls.password", "");
        TlsConfig.init(string3, string2);
    }

    public void addRootCert() {
        StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
        String string = null;
        try {
            string = TlsConfig.getRootCert();
        }
        catch (IOException iOException) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)"Cannot get root cert, Exception = ", (Throwable)iOException);
            }
            return;
        }
        TextElement textElement = structuredTextDocument.createElement("RootCert", string);
        structuredTextDocument.appendChild((Element)textElement);
        this.advertisement.putServiceParam(PeerGroup.peerGroupClassID, structuredTextDocument);
    }

    private void routerRdvMatch() {
        try {
            Element element;
            Object object;
            Object object2;
            Object object3;
            boolean bl;
            Object object4;
            Vector<String> vector;
            Enumeration enumeration;
            block21: {
                enumeration = null;
                vector = new Vector<String>();
                try {
                    object4 = (TextElement)((Object)this.advertisement.getServiceParam(PeerGroup.rendezvousClassID));
                    if (object4 != null) {
                        enumeration = object4.getChildren("Rdv");
                        Enumeration enumeration2 = object4.getChildren("Addr");
                        while (enumeration2.hasMoreElements()) {
                            vector.addElement(((TextElement)enumeration2.nextElement()).getTextValue());
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object4 = null;
                bl = false;
                try {
                    object3 = this.advertisement.getServiceParam(PeerGroup.httpProtoClassID);
                    if (object3.getChildren("isOff").hasMoreElements()) {
                        bl = true;
                    }
                    if ((object2 = object3.getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
                        object3 = (Element)object2.nextElement();
                    } else {
                        object2 = object3.getChildren(HTTPAdv.getAdvertisementType());
                        if (object2.hasMoreElements()) {
                            object3 = (Element)object2.nextElement();
                        }
                    }
                    object4 = (HTTPAdv)AdvertisementFactory.newAdvertisement((TextElement)object3);
                }
                catch (Exception exception) {
                    object4 = new HTTPAdv();
                    ((TransportAdvertisement)object4).setProtocol("http");
                    ((HTTPAdv)object4).setPort("9700");
                    ((HTTPAdv)object4).setRouterEnabled(true);
                    ((HTTPAdv)object4).setProxyEnabled(false);
                    ((HTTPAdv)object4).setServerEnabled(false);
                    if (!LOG.isEnabledFor(Priority.WARN)) break block21;
                    LOG.warn((Object)"httpAdv has vanished");
                }
            }
            Vector vector2 = ((HTTPAdv)object4).getRouters();
            if (vector2 == null) {
                vector2 = new Vector();
            }
            object3 = new Vector();
            object2 = new Vector();
            int n = 0;
            PosRandom posRandom = new PosRandom();
            Enumeration enumeration3 = vector.elements();
            while (enumeration3.hasMoreElements()) {
                String string = (String)enumeration3.nextElement();
                if (string.startsWith("tcp://")) continue;
                string = string.substring(7);
                Enumeration enumeration4 = vector2.elements();
                boolean bl2 = true;
                if (((HTTPAdv)object4).getRouterEnabled()) {
                    bl2 = false;
                    while (enumeration4.hasMoreElements()) {
                        object = (String)enumeration4.nextElement();
                        if (!string.equals(object)) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (!bl2) continue;
                int n2 = posRandom.nextPos() % ++n;
                ((Vector)object3).insertElementAt(string, n2);
                ((Vector)object2).insertElementAt("http://" + string, n2);
            }
            int n3 = 0;
            int n4 = !bl ? n : 0;
            enumeration3 = vector.elements();
            while (enumeration3.hasMoreElements()) {
                String string = (String)enumeration3.nextElement();
                if (string.startsWith("http://")) continue;
                ((Vector)object2).insertElementAt(string, posRandom.nextPos() % ++n3 + n4);
            }
            if (((Vector)object3).size() == 0) {
                object3 = null;
            }
            ((HTTPAdv)object4).setRouters((Vector)object3);
            StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
            if (enumeration != null || enumeration.hasMoreElements()) {
                StructuredDocumentUtils.copyElements(structuredTextDocument, structuredTextDocument, (Element)enumeration.nextElement());
            }
            object = ((Vector)object2).elements();
            while (object.hasMoreElements()) {
                element = structuredTextDocument.createElement("Addr", (String)object.nextElement());
                structuredTextDocument.appendChild(element);
            }
            element = StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
            StructuredDocumentUtils.copyElements((StructuredDocument)element, element, (StructuredDocument)((HTTPAdv)object4).getDocument(new MimeMediaType("text", "xml")));
            if (bl) {
                element.appendChild(element.createElement("isOff"));
            }
            this.advertisement.putServiceParam(PeerGroup.httpProtoClassID, element);
            this.advertisement.putServiceParam(PeerGroup.rendezvousClassID, structuredTextDocument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PeerAdvertisement get() {
        return this.advertisement;
    }

    public void save() {
        this.saveTo(configName);
    }

    public void load() {
        this.loadFrom(configName);
    }

    public void setReconf() {
        block2: {
            try {
                File file = new File("reconf");
                new FileOutputStream(file).close();
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break block2;
                LOG.error((Object)"Could not create reconfig flag.");
                LOG.error((Object)"Create the file reconfig by hand before retrying.");
            }
        }
    }

    public void clearReconf() {
        block2: {
            try {
                File file = new File("reconf");
                file.delete();
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break block2;
                LOG.error((Object)"Could not remove reconfig flag.");
                LOG.error((Object)"Delete the file reconfig by hand before retrying.");
            }
        }
    }

    public boolean isReconf() {
        try {
            File file = new File("reconf");
            boolean bl = file.exists();
            if (bl && LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"Reconfig requested - 'reconf' file found");
            }
            return bl;
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)"Could not check reconfig flag.");
                LOG.error((Object)"Assuming it exists.");
            }
            return true;
        }
    }

    private void loadFrom(String string) {
        FileInputStream fileInputStream = null;
        File file = null;
        try {
            file = new File(string);
            fileInputStream = new FileInputStream(file);
            this.advertisement = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), fileInputStream);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Recovered " + string));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("No Existing " + string));
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("Failed to Recover " + string));
            }
            exception.printStackTrace();
            try {
                file.delete();
            }
            catch (Exception exception2) {
                if (LOG.isEnabledFor(Priority.FATAL)) {
                    LOG.fatal((Object)("Could not remove " + string + ". Removed it by hand before retrying"));
                }
                throw new JxtaError("Could not remove " + string + ". Removed it by hand before retrying");
            }
            this.advertisement = null;
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveTo(String string) {
        FileOutputStream fileOutputStream;
        block4: {
            fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(string);
                Document document = this.advertisement.getDocument(new MimeMediaType("text/xml"));
                document.sendToStream(fileOutputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!LOG.isEnabledFor(Priority.WARN)) break block4;
                LOG.warn((Object)("Could not save to " + string));
            }
        }
        try {
            fileOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String parseHttpProxyServer(String string) {
        if (string.indexOf(";") >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                if (!string2.startsWith("http=")) continue;
                return string2;
            }
        }
        return string;
    }

    private boolean fixAdvertisement() {
        block48: {
            try {
                int n;
                InetAddress[] inetAddressArray;
                String string;
                String string2;
                boolean bl;
                Object object;
                Object object2;
                boolean bl2 = this.isReconf();
                if (this.advertisement == null) {
                    bl2 = true;
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"Reconfig requested - no PeerAdvertisement");
                    }
                    this.advertisement = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(PeerAdvertisement.getAdvertisementType());
                    this.advertisement.setName("");
                    this.advertisement.setDescription("");
                    this.advertisement.setPeerID(IDFactory.newPeerID(PeerGroupID.worldPeerGroupID));
                }
                StructuredDocument structuredDocument = (StructuredTextDocument)this.advertisement.getServiceParam(PeerGroup.httpProtoClassID);
                StructuredDocument structuredDocument2 = (StructuredTextDocument)this.advertisement.getServiceParam(PeerGroup.tcpProtoClassID);
                HTTPAdv hTTPAdv = null;
                boolean bl3 = false;
                TCPAdv tCPAdv = null;
                boolean bl4 = false;
                if (structuredDocument != null) {
                    try {
                        block46: {
                            bl3 = structuredDocument.getChildren("isOff").hasMoreElements();
                            object2 = null;
                            object = structuredDocument.getChildren(TransportAdvertisement.getAdvertisementType());
                            if (object.hasMoreElements()) {
                                object2 = (Element)object.nextElement();
                            } else {
                                object = structuredDocument.getChildren(HTTPAdv.getAdvertisementType());
                                if (object.hasMoreElements()) {
                                    object2 = (Element)object.nextElement();
                                }
                            }
                            hTTPAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement((TextElement)object2);
                            bl = false;
                            try {
                                string2 = hTTPAdv.getInterfaceAddress();
                                if (string2 == null || string2.equals("")) break block46;
                                string = InetAddress.getLocalHost().getHostAddress();
                                inetAddressArray = InetAddress.getAllByName(string);
                                n = inetAddressArray.length;
                                while (n-- > 0) {
                                    if (!inetAddressArray[n].getHostAddress().equals(string2)) continue;
                                    bl = true;
                                    break;
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (!(bl || (string2 = hTTPAdv.getConfigMode()) != null && string2.equals("manual"))) {
                            bl2 = true;
                            if (LOG.isEnabledFor(Priority.INFO)) {
                                LOG.info((Object)"Reconfig requested - http set to manual config");
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (LOG.isEnabledFor(Priority.WARN)) {
                            LOG.warn((Object)"Reconfig requested - http advertisement corrupted", (Throwable)exception);
                        }
                        hTTPAdv = null;
                    }
                }
                if (hTTPAdv == null) {
                    bl2 = true;
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"Reconfig requested - http advertisement missing");
                    }
                    hTTPAdv = new HTTPAdv();
                    hTTPAdv.setProtocol("http");
                    hTTPAdv.setPort("9700");
                    hTTPAdv.setRouterEnabled(true);
                    hTTPAdv.setProxyEnabled(false);
                    hTTPAdv.setServerEnabled(false);
                }
                if (structuredDocument2 != null) {
                    try {
                        block47: {
                            bl4 = structuredDocument2.getChildren("isOff").hasMoreElements();
                            object2 = null;
                            object = structuredDocument2.getChildren(TransportAdvertisement.getAdvertisementType());
                            if (object.hasMoreElements()) {
                                object2 = (Element)object.nextElement();
                            } else {
                                object = structuredDocument2.getChildren(TCPAdv.getAdvertisementType());
                                if (object.hasMoreElements()) {
                                    object2 = (Element)object.nextElement();
                                }
                            }
                            tCPAdv = (TCPAdv)AdvertisementFactory.newAdvertisement((TextElement)object2);
                            bl = false;
                            try {
                                string2 = tCPAdv.getInterfaceAddress();
                                if (string2 == null || string2.equals("")) break block47;
                                string = InetAddress.getLocalHost().getHostAddress();
                                inetAddressArray = InetAddress.getAllByName(string);
                                n = inetAddressArray.length;
                                while (n-- > 0) {
                                    if (!inetAddressArray[n].getHostAddress().equals(string2)) continue;
                                    bl = true;
                                    break;
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (!(bl || (string2 = tCPAdv.getConfigMode()) != null && string2.equals("manual"))) {
                            bl2 = true;
                            if (LOG.isEnabledFor(Priority.INFO)) {
                                LOG.info((Object)"Reconfig requested - tcp set to manual config");
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (LOG.isEnabledFor(Priority.WARN)) {
                            LOG.warn((Object)"Reconfig requested - http advertisement corrupted", (Throwable)exception);
                        }
                        tCPAdv = null;
                    }
                }
                if (tCPAdv == null) {
                    bl2 = true;
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"Reconfig requested - tcp advertisement missing");
                    }
                    object2 = "9701";
                    object = System.getProperty("jxta.tcp.port");
                    if (object != null) {
                        object2 = object;
                    }
                    tCPAdv = new TCPAdv();
                    tCPAdv.setProtocol("TCP");
                    tCPAdv.setPort((String)object2);
                    tCPAdv.setMulticastAddr("224.0.1.85");
                    tCPAdv.setMulticastPort("1234");
                    tCPAdv.setMulticastSize("16384");
                    tCPAdv.setServer("");
                    tCPAdv.setInterfaceAddress("");
                }
                object2 = "";
                try {
                    object2 = InetAddress.getLocalHost().getHostName();
                }
                catch (Exception exception) {
                    object2 = "";
                }
                if (hTTPAdv.getServer() == null) {
                    hTTPAdv.setServer((String)object2 + ":9700");
                    hTTPAdv.setServerEnabled(false);
                }
                if ((object = System.getProperty("jxta.proxy")) != null) {
                    String string3 = this.parseHttpProxyServer((String)object);
                    if (string3 != null) {
                        hTTPAdv.setProxyEnabled(true);
                        hTTPAdv.setProxy(string3.substring(string3.indexOf("=") + 1));
                    }
                } else if (hTTPAdv.getProxy() == null) {
                    hTTPAdv.setProxy("myProxy.myDomain:8080");
                    hTTPAdv.setProxyEnabled(false);
                }
                if (hTTPAdv.getRouters() == null) {
                    Vector vector = new Vector();
                    hTTPAdv.setRouters(vector);
                }
                if (TlsConfig.willConfigureTls()) {
                    bl2 = true;
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"Reconfig requested - TLS wanted config");
                    }
                }
                if (!bl2) {
                    return false;
                }
                structuredDocument = StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
                StructuredDocumentUtils.copyElements(structuredDocument, structuredDocument, (StructuredDocument)hTTPAdv.getDocument(new MimeMediaType("text", "xml")));
                if (bl3) {
                    structuredDocument.appendChild(structuredDocument.createElement("isOff"));
                }
                this.advertisement.putServiceParam(PeerGroup.httpProtoClassID, structuredDocument);
                structuredDocument2 = StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
                StructuredDocumentUtils.copyElements(structuredDocument2, structuredDocument2, (StructuredDocument)tCPAdv.getDocument(new MimeMediaType("text", "xml")));
                if (bl4) {
                    structuredDocument2.appendChild(structuredDocument2.createElement("isOff"));
                }
                this.advertisement.putServiceParam(PeerGroup.tcpProtoClassID, structuredDocument2);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break block48;
                LOG.error((Object)"Trouble while fixing advertisement. Hope for the best.", (Throwable)exception);
            }
        }
        return true;
    }

    private void adjustLog4JPriority() {
        if (this.advertisement == null || this.advertisement.getDebugLevel() == null) {
            return;
        }
        String string = this.advertisement.getDebugLevel();
        if ("user default".equals(string)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"user default requested");
            }
            return;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Setting priority to [" + string + "] based on the user's configuration"));
        }
        Category category = Category.getInstance((String)"net.jxta");
        category.setPriority(Priority.toPriority((String)string));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PosRandom
    extends Random {
        PosRandom() {
        }

        public int nextPos() {
            return this.next(31);
        }
    }

    class PasswordDialog
    extends JFrame
    implements ActionListener {
        TextField principalField = new TextField("", 20);
        TextField passwordField = new TextField(20);
        private boolean principalDone = false;
        private boolean passwordDone = false;

        public PasswordDialog() {
            super("JXTA Secure Login");
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel("Secure Username: ");
            jPanel2.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            jPanel2.add((Component)jLabel, "West");
            jPanel2.add((Component)this.principalField, "East");
            JPanel jPanel3 = new JPanel(new BorderLayout());
            JLabel jLabel2 = new JLabel("Password: ");
            this.passwordField.setEchoChar('*');
            jPanel3.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            jPanel3.add((Component)jLabel2, "West");
            jPanel3.add((Component)this.passwordField, "East");
            this.principalField.addActionListener(this);
            this.passwordField.addActionListener(this);
            jPanel.add((Component)jPanel2, "North");
            jPanel.add((Component)jPanel3, "South");
            this.setContentPane(jPanel);
            Rectangle rectangle = this.getGraphicsConfiguration().getBounds();
            ((Component)this).setLocation(rectangle.x + rectangle.width / 2 - this.getSize().width / 2, rectangle.y + rectangle.height / 2 - this.getSize().height / 2);
            this.pack();
            ((Component)this).setVisible(true);
            this.untilDone();
            this.dispose();
        }

        private synchronized void untilDone() {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
            String string = this.passwordField.getText();
            String string2 = this.principalField.getText();
            if (string2.length() == 0 || !JTlsUtil.principalIsIssuer(string2)) {
                JOptionPane.showMessageDialog(this, "Invalid Secure Username. Try again.", "Error Message", 0);
                return;
            }
            System.setProperty("net.jxta.tls.principal", string2);
            if (string.length() == 0) {
                this.passwordField.requestFocus();
                return;
            }
            if (string.length() == 0 || !JTlsUtil.validPasswd(string)) {
                JOptionPane.showMessageDialog(this, "Invalid Password. Try again.", "Error Message", 0);
                return;
            }
            System.setProperty("net.jxta.tls.password", string);
            this.notifyAll();
        }
    }
}

