/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.index;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import net.jxta.impl.index.xpath.DocumentParserCallback;
import net.jxta.impl.index.xpath.Expression;
import net.jxta.impl.index.xpath.XPath;
import net.jxta.impl.xml.XmlParser;
import net.jxta.index.IndexService;

public class IndexServiceImpl
implements IndexService {
    static int totalSplitStrings;
    static int totalChars;
    static int totalInternedChars;
    static int totalSuffixChars;
    static HashMap internTable;
    String[] STRING_ARR = new String[0];

    static String intern(String string) {
        String string2 = (String)internTable.get(string);
        if (string2 == null) {
            internTable.put(string, string);
            string2 = string;
            totalInternedChars += string.length();
        }
        return string2;
    }

    public IndexService.Index getIndex(File file) throws IOException {
        return new ForwardIndex();
    }

    public IndexService.ReverseIndex getReverseIndex(File file) throws IOException {
        return new ReverseIndex();
    }

    public void printStats() {
        System.out.println("Split Strings:        " + totalSplitStrings);
        System.out.println("Total Chars:          " + totalChars);
        System.out.println("Total Interned Chars: " + totalInternedChars);
        System.out.println("Total Suffix Chars:   " + totalSuffixChars);
    }

    Expression.Clause getLogicalExpression(InputStream inputStream, byte[] byArray) throws IOException, IndexService.BadDocumentException {
        DocumentParserCallback documentParserCallback = new DocumentParserCallback();
        Expression.Clause clause = new Expression.Clause("and");
        Expression.Clause clause2 = new Expression.Clause("or");
        try {
            long l = System.currentTimeMillis();
            long l2 = XmlParser.parse(inputStream, byArray, documentParserCallback);
            long l3 = System.currentTimeMillis();
            TreeSet treeSet = documentParserCallback.getPaths();
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                clause2.addSubexpression(new Expression.Literal(new SplitString(string)));
            }
            clause.addSubexpression((Expression.LogicalExpression)clause2);
            return clause;
        }
        catch (XmlParser.Exception exception) {
            throw new IndexService.BadDocumentException("Unable to parse document.", exception);
        }
    }

    static {
        internTable = new HashMap();
    }

    class ReadWriteLock {
        boolean inWrite;
        int readers;

        ReadWriteLock() {
        }

        synchronized void enterWrite() throws IndexService.IndexException {
            while (this.inWrite) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IndexService.IndexException("Unable to acquire write lock.", interruptedException);
                }
            }
            this.inWrite = true;
            while (this.readers > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IndexService.IndexException("Unable to acquire write lock.", interruptedException);
                }
            }
        }

        synchronized void leaveWrite() {
            if (this.inWrite) {
                this.inWrite = false;
                this.notifyAll();
            }
        }

        synchronized void enterRead() throws IndexService.IndexException {
            while (this.inWrite) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IndexService.IndexException("Unable to acquire read lock.", interruptedException);
                }
            }
            ++this.readers;
        }

        synchronized void leaveRead() {
            if (--this.readers == 0) {
                this.notifyAll();
            }
        }
    }

    class PossibleMatch {
        String predicateId;
        int disjunctionCount;
        HashMap disjunctions;

        PossibleMatch(String string, int n) {
            this.predicateId = string;
            this.disjunctionCount = n;
        }

        boolean isMatch() {
            return this.disjunctionCount == 0;
        }

        void matchedClause() {
            --this.disjunctionCount;
        }

        void matchedClause(Integer n, Expression.Clause clause) {
            if (this.disjunctions == null) {
                this.disjunctions = new HashMap();
            }
            this.disjunctions.put(n, clause);
            --this.disjunctionCount;
        }
    }

    class Index {
        HashMap literalsTable = new HashMap();
        HashMap disjunctionInfoTable = new HashMap();
        HashMap predicateInfoTable = new HashMap();
        int nextDisjunctionId;

        Index() {
        }

        int getDisjunctionCount(String string) {
            PredicateInfo predicateInfo = (PredicateInfo)this.predicateInfoTable.get(string);
            return predicateInfo == null ? -1 : predicateInfo.disjunctionCount;
        }

        String getConjunctionId(Integer n) {
            DisjunctionInfo disjunctionInfo = (DisjunctionInfo)this.disjunctionInfoTable.get(n);
            return disjunctionInfo == null ? null : disjunctionInfo.predicateId;
        }

        int getLiteralCount(Integer n) {
            DisjunctionInfo disjunctionInfo = (DisjunctionInfo)this.disjunctionInfoTable.get(n);
            return disjunctionInfo.literalCount;
        }

        void add(String string, Expression.Clause clause) {
            Enumeration enumeration = clause.getSubexpressions();
            int n = this.nextDisjunctionId;
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                int n3 = 0;
                Expression.Clause clause2 = (Expression.Clause)enumeration.nextElement();
                Enumeration enumeration2 = clause2.getSubexpressions();
                Integer n4 = new Integer(this.nextDisjunctionId++);
                while (enumeration2.hasMoreElements()) {
                    Object object = ((Expression.Literal)enumeration2.nextElement()).getName();
                    this.literalsTablePut(object, n4);
                    ++n3;
                }
                this.disjunctionInfoTable.put(n4, new DisjunctionInfo(string, n3));
                ++n2;
            }
            this.predicateInfoTable.put(string, new PredicateInfo(n, n2));
        }

        void remove(String string, Expression.Clause clause) {
            Enumeration enumeration = clause.getSubexpressions();
            HashMap<String, PossibleMatch> hashMap = new HashMap<String, PossibleMatch>();
            TreeSet treeSet = new TreeSet();
            while (enumeration.hasMoreElements()) {
                Serializable serializable;
                Object object;
                int n = 0;
                Expression.Clause clause2 = (Expression.Clause)enumeration.nextElement();
                Enumeration enumeration2 = clause2.getSubexpressions();
                TreeSet treeSet2 = new TreeSet();
                while (enumeration2.hasMoreElements()) {
                    object = ((Expression.Literal)enumeration2.nextElement()).getName();
                    serializable = this.literalsTableGet(object, false);
                    if (serializable == null) {
                        return;
                    }
                    if (treeSet2.size() == 0) {
                        treeSet2.addAll(serializable);
                    } else {
                        treeSet2.retainAll((Collection<?>)((Object)serializable));
                    }
                    ++n;
                }
                object = treeSet2.iterator();
                while (object.hasNext()) {
                    serializable = (Integer)object.next();
                    String string2 = this.getConjunctionId((Integer)serializable);
                    if (!string.equals(string2) || this.getLiteralCount((Integer)serializable) != n) continue;
                    PossibleMatch possibleMatch = (PossibleMatch)hashMap.get(string2);
                    if (possibleMatch == null) {
                        possibleMatch = new PossibleMatch(string2, this.getDisjunctionCount(string2));
                        hashMap.put(string2, possibleMatch);
                    }
                    possibleMatch.matchedClause((Integer)serializable, clause2);
                    if (!possibleMatch.isMatch()) continue;
                    Iterator iterator = possibleMatch.disjunctions.keySet().iterator();
                    while (iterator.hasNext()) {
                        serializable = (Integer)iterator.next();
                        clause2 = (Expression.Clause)possibleMatch.disjunctions.get(serializable);
                        this.removeDisjunctionLiterals((Integer)serializable, clause2);
                        this.disjunctionInfoTable.remove(serializable);
                    }
                    this.predicateInfoTable.remove(string2);
                }
            }
        }

        void removeDisjunctionLiterals(Integer n, Expression.Clause clause) {
            Enumeration enumeration = clause.getSubexpressions();
            while (enumeration.hasMoreElements()) {
                Expression.Literal literal = (Expression.Literal)enumeration.nextElement();
                TreeSet treeSet = this.literalsTableGet(literal.getName(), false);
                treeSet.remove(n);
                if (treeSet.size() != 0) continue;
                this.literalsTable.remove(literal);
            }
        }

        void literalsTablePut(Object object, Integer n) {
            Object v = this.literalsTable.get(object);
            if (v == null) {
                this.literalsTable.put(object, n);
            } else if (v instanceof TreeSet) {
                ((TreeSet)v).add(n);
            } else {
                TreeSet<Object> treeSet = new TreeSet<Object>();
                treeSet.add(v);
                treeSet.add(n);
                this.literalsTable.put(object, treeSet);
            }
        }

        TreeSet literalsTableGet(Object object, boolean bl) {
            Object v = bl ? this.literalsTable.get(new SplitString((String)object)) : this.literalsTable.get(object);
            if (v == null || v instanceof TreeSet) {
                return (TreeSet)v;
            }
            TreeSet treeSet = new TreeSet();
            treeSet.add(v);
            return treeSet;
        }

        TreeSet query(Expression.LogicalExpression logicalExpression, boolean bl) {
            if (logicalExpression instanceof Expression.Literal) {
                return this.query((Expression.Literal)logicalExpression, bl);
            }
            return this.query((Expression.Clause)logicalExpression, bl);
        }

        void remove(Expression.Literal literal) {
        }

        TreeSet query(Expression.Literal literal, boolean bl) {
            TreeSet treeSet = this.literalsTableGet(literal.getName().toString(), bl);
            TreeSet<String> treeSet2 = new TreeSet<String>();
            if (treeSet != null) {
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    Integer n = (Integer)iterator.next();
                    String string = this.getConjunctionId(n);
                    if (string == null) continue;
                    treeSet2.add(string);
                }
            }
            return treeSet2;
        }

        TreeSet query(Expression.Clause clause, boolean bl) {
            Serializable serializable;
            Object object;
            Enumeration enumeration = clause.getSubexpressions();
            Object object2 = null;
            HashMap<String, PossibleMatch> hashMap = new HashMap<String, PossibleMatch>();
            TreeSet<String> treeSet = new TreeSet<String>();
            while (enumeration.hasMoreElements()) {
                Expression.Clause clause2 = (Expression.Clause)enumeration.nextElement();
                Enumeration enumeration2 = clause2.getSubexpressions();
                object = new TreeSet();
                while (enumeration2.hasMoreElements()) {
                    Expression.Literal literal = (Expression.Literal)enumeration2.nextElement();
                    serializable = this.literalsTableGet(literal.getName().toString(), bl);
                    if (serializable == null) continue;
                    ((TreeSet)object).addAll(serializable);
                }
                if (object2 == null) {
                    object2 = object;
                    continue;
                }
                ((AbstractCollection)object2).retainAll((Collection<?>)object);
            }
            object = ((TreeSet)object2).iterator();
            while (object.hasNext()) {
                serializable = (Integer)object.next();
                String string = this.getConjunctionId((Integer)serializable);
                PossibleMatch possibleMatch = null;
                if (string != null) {
                    possibleMatch = (PossibleMatch)hashMap.get(string);
                }
                if (possibleMatch == null) {
                    int n = this.getDisjunctionCount(string);
                    possibleMatch = new PossibleMatch(string, n);
                    hashMap.put(string, possibleMatch);
                }
                possibleMatch.matchedClause();
                if (!possibleMatch.isMatch()) continue;
                treeSet.add(string);
            }
            return treeSet;
        }
    }

    class DisjunctionInfo {
        String predicateId;
        int literalCount;

        DisjunctionInfo(String string, int n) {
            this.predicateId = string;
            this.literalCount = n;
        }
    }

    class PredicateInfo {
        int firstDisjunctionId;
        int disjunctionCount;

        PredicateInfo(int n, int n2) {
            this.firstDisjunctionId = n;
            this.disjunctionCount = n2;
        }
    }

    class ForwardIndex
    implements IndexService.Index {
        File dir;
        byte[] buf = new byte[8192];
        Index index;
        ReadWriteLock lock;

        ForwardIndex() {
            this.index = new Index();
            this.lock = new ReadWriteLock();
        }

        public synchronized void add(String string, InputStream inputStream) throws IOException, IndexService.BadDocumentException, IndexService.IndexException {
            try {
                Expression.Clause clause = IndexServiceImpl.this.getLogicalExpression(inputStream, this.buf);
                this.lock.enterWrite();
                this.index.add(string, clause);
                Object var5_4 = null;
                this.lock.leaveWrite();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.lock.leaveWrite();
                throw throwable;
            }
        }

        public synchronized void remove(String string, InputStream inputStream) throws IOException, IndexService.BadDocumentException, IndexService.IndexException {
            try {
                Expression.Clause clause = IndexServiceImpl.this.getLogicalExpression(inputStream, this.buf);
                this.lock.enterWrite();
                this.index.remove(string, clause);
                Object var5_4 = null;
                this.lock.leaveWrite();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.lock.leaveWrite();
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String[] query(String string) throws IndexService.BadQueryException, IndexService.IndexException {
            String[] stringArray;
            block6: {
                try {
                    String[] stringArray2;
                    block5: {
                        try {
                            String[] stringArray3;
                            XPath xPath = new XPath(string.toUpperCase());
                            Expression.LogicalExpression logicalExpression = xPath.unroll();
                            this.lock.enterRead();
                            TreeSet treeSet = this.index.query(logicalExpression, true);
                            if (treeSet == null) {
                                stringArray2 = null;
                                Object var8_8 = null;
                                break block5;
                            }
                            stringArray = stringArray3 = treeSet.toArray(IndexServiceImpl.this.STRING_ARR);
                            break block6;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new IndexService.BadQueryException("Invalid XPath.", illegalArgumentException);
                        }
                    }
                    this.lock.leaveRead();
                    return stringArray2;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    this.lock.leaveRead();
                    throw throwable;
                }
            }
            Object var8_9 = null;
            this.lock.leaveRead();
            return stringArray;
        }
    }

    class ReverseIndex
    implements IndexService.ReverseIndex {
        File dir;
        byte[] buf = new byte[8192];
        Index index;
        ReadWriteLock lock;

        ReverseIndex() {
            this.index = new Index();
            this.lock = new ReadWriteLock();
        }

        public void add(String string, String string2) throws IndexService.BadQueryException, IndexService.IndexException {
            try {
                try {
                    XPath xPath = new XPath(string2.toUpperCase());
                    Expression.LogicalExpression logicalExpression = xPath.unroll();
                    this.lock.enterWrite();
                    this.index.add(string, (Expression.Clause)logicalExpression);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IndexService.BadQueryException("Invalid xpath.", illegalArgumentException);
                }
                Object var6_6 = null;
                this.lock.leaveWrite();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.lock.leaveWrite();
                throw throwable;
            }
        }

        public void remove(String string, String string2) throws IndexService.BadQueryException, IndexService.IndexException {
            try {
                try {
                    XPath xPath = new XPath(string2.toUpperCase());
                    Expression.LogicalExpression logicalExpression = xPath.unroll();
                    this.lock.enterWrite();
                    this.index.remove(string, (Expression.Clause)logicalExpression);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IndexService.BadQueryException("Invalid xpath.", illegalArgumentException);
                }
                Object var6_6 = null;
                this.lock.leaveWrite();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.lock.leaveWrite();
                throw throwable;
            }
        }

        public String[] query(InputStream inputStream) throws IOException, IndexService.BadDocumentException, IndexService.IndexException {
            try {
                String[] stringArray;
                Expression.Clause clause = IndexServiceImpl.this.getLogicalExpression(inputStream, this.buf);
                this.lock.enterRead();
                String[] stringArray2 = stringArray = this.index.query(clause, false).toArray(IndexServiceImpl.this.STRING_ARR);
                Object var6_5 = null;
                this.lock.leaveRead();
                return stringArray2;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.lock.leaveRead();
                throw throwable;
            }
        }
    }

    static final class SplitString {
        final String prefix;
        final String suffix;
        int hashCode;

        SplitString(String string) {
            int n = SplitString.findPrefixLength(string);
            this.prefix = IndexServiceImpl.intern(SplitString.substring(string, 0, n));
            this.suffix = SplitString.substring(string, n, string.length());
            this.hashCode = string.hashCode();
            ++totalSplitStrings;
            totalChars += string.length();
            totalSuffixChars += this.suffix.length();
        }

        static int findPrefixLength(String string) {
            int n = string.indexOf(64);
            int n2 = n == -1 ? string.indexOf(39) : string.indexOf(91);
            if (n2 == -1) {
                n2 = string.lastIndexOf(47);
            }
            return n2 + 1;
        }

        static String substring(String string, int n, int n2) {
            char[] cArray = string.toCharArray();
            return new String(cArray, n, n2 - n);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof SplitString) {
                SplitString splitString = (SplitString)object;
                return this.prefix == splitString.prefix && this.suffix.equals(splitString.suffix);
            }
            if (object instanceof String) {
                String string = (String)object;
                return string.length() == this.prefix.length() + this.suffix.length() && string.startsWith(this.prefix) && string.endsWith(this.suffix);
            }
            return false;
        }

        public String toString() {
            return this.prefix + " " + this.suffix;
        }
    }

    static class SplitStringComparator
    implements Comparator {
        SplitStringComparator() {
        }

        public int compare(Object object, Object object2) {
            SplitString splitString = (SplitString)object;
            SplitString splitString2 = (SplitString)object2;
            int n = splitString.prefix.compareTo(splitString2.prefix);
            if (n == 0) {
                n = splitString2.suffix.compareTo(splitString2.suffix);
            }
            return n;
        }

        public boolean equals(Object object) {
            return object instanceof SplitStringComparator;
        }
    }
}

