/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.net.URL;
import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.IDFormat;
import net.jxta.impl.id.UUID.ModuleClassID;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;

public final class ModuleSpecID
extends net.jxta.platform.ModuleSpecID {
    private static final int moduleClassIdOffset = 0;
    private static final int moduleSpecIdOffset = 16;
    private static final int padOffset = 32;
    private static final int padSize = 31;
    protected IDBytes id;

    private ModuleSpecID() {
        this.id = new IDBytes();
        this.id.bytes[63] = 6;
    }

    ModuleSpecID(IDBytes iDBytes) {
        this.id = iDBytes;
    }

    ModuleSpecID(UUID uUID, UUID uUID2) {
        this();
        this.id.longIntoBytes(0, uUID.getMostSignificantBits());
        this.id.longIntoBytes(8, uUID.getLeastSignificantBits());
        this.id.longIntoBytes(16, uUID2.getMostSignificantBits());
        this.id.longIntoBytes(24, uUID2.getLeastSignificantBits());
    }

    public ModuleSpecID(net.jxta.platform.ModuleClassID moduleClassID) {
        this(((ModuleClassID)moduleClassID).getClassUUID(), UUIDFactory.newUUID());
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof String) {
            return object.equals(this.toString());
        }
        if (object instanceof ModuleSpecID) {
            return this.id.equals(((ModuleSpecID)object).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        return this.getIDFormat() + "-" + (String)this.id.getUniqueValue();
    }

    public URL getURL() {
        return IDFormat.getURL((String)this.getUniqueValue());
    }

    public net.jxta.platform.ModuleClassID getBaseClass() {
        return new ModuleClassID(this.getClassUUID(), new UUID(0L, 0L));
    }

    public boolean isOfSameBaseClass(net.jxta.platform.ModuleClassID moduleClassID) {
        return this.getClassUUID().equals(((ModuleClassID)moduleClassID).getClassUUID());
    }

    public boolean isOfSameBaseClass(net.jxta.platform.ModuleSpecID moduleSpecID) {
        return this.getClassUUID().equals(((ModuleSpecID)moduleSpecID).getClassUUID());
    }

    UUID getClassUUID() {
        UUID uUID = new UUID(this.id.bytesIntoLong(0), this.id.bytesIntoLong(8));
        return uUID;
    }

    UUID getSpecUUID() {
        UUID uUID = new UUID(this.id.bytesIntoLong(16), this.id.bytesIntoLong(24));
        return uUID;
    }
}

