/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import net.jxta.id.ID;
import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.IDFormat;
import net.jxta.impl.id.UUID.PeerGroupID;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;

public final class CodatID
extends net.jxta.codat.CodatID {
    static final int hashSize = 20;
    static final int groupIdOffset = 0;
    static final int idOffset = 16;
    static final int codatHashOffset = 32;
    static final int padOffset = 52;
    static final int padSize = 11;
    protected IDBytes id;

    private CodatID() {
        this.id = new IDBytes();
        this.id.bytes[63] = 1;
    }

    CodatID(IDBytes iDBytes) {
        this.id = iDBytes;
    }

    public CodatID(PeerGroupID peerGroupID) {
        this();
        UUID uUID = new UUID(peerGroupID.id.bytesIntoLong(0), peerGroupID.id.bytesIntoLong(8));
        UUID uUID2 = UUIDFactory.newUUID();
        this.id.longIntoBytes(0, uUID.getMostSignificantBits());
        this.id.longIntoBytes(8, uUID.getLeastSignificantBits());
        this.id.longIntoBytes(16, uUID2.getMostSignificantBits());
        this.id.longIntoBytes(24, uUID2.getLeastSignificantBits());
    }

    public CodatID(PeerGroupID peerGroupID, InputStream inputStream) throws IOException {
        this(peerGroupID);
        int n;
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            messageDigest = null;
        }
        if (messageDigest == null) {
            throw new ProviderException("SHA1 digest algorithm found");
        }
        messageDigest.reset();
        while ((n = inputStream.read()) != -1) {
            messageDigest.update((byte)n);
        }
        inputStream.close();
        try {
            byte[] byArray = messageDigest.digest();
            int n2 = 0;
            while (n2 < 20) {
                this.id.bytes[n2 + 32] = byArray[n2];
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new IOException("Digest algorithm could not complete");
        }
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof String) {
            return object.equals(this.toString());
        }
        if (object instanceof CodatID) {
            return this.id.equals(((CodatID)object).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        return this.getIDFormat() + "-" + (String)this.id.getUniqueValue();
    }

    public URL getURL() {
        return IDFormat.getURL((String)this.getUniqueValue());
    }

    public ID getPeerGroupID() {
        UUID uUID = new UUID(this.id.bytesIntoLong(0), this.id.bytesIntoLong(8));
        PeerGroupID peerGroupID = new PeerGroupID(uUID);
        return IDFormat.translateToWellKnown(peerGroupID);
    }

    public boolean isStatic() {
        int n = 32;
        while (n < 52) {
            if (0 != this.id.bytes[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

