/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointProtocol;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.endpoint.tcp.Header;
import net.jxta.impl.endpoint.tcp.TcpConnection;
import net.jxta.impl.endpoint.tcp.TcpConnectionManager;
import net.jxta.impl.endpoint.tcp.TcpNonBlockingMessenger;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.EndpointAdvertisement;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TcpTransport
implements EndpointProtocol,
Runnable,
Module {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tcp$TcpTransport == null ? (class$net$jxta$impl$endpoint$tcp$TcpTransport = TcpTransport.class$("net.jxta.impl.endpoint.tcp.TcpTransport")) : class$net$jxta$impl$endpoint$tcp$TcpTransport).getName());
    public ServerSocket unicastSocket;
    public InetAddress usingInterface;
    private InetAddress propagateInetAddress;
    private int propagatePort;
    private int propagateSize;
    public int serverSocketPort;
    private Thread multicastThread = null;
    private Thread unicastThread = null;
    private MulticastSocket multicastSocket = null;
    private PeerGroup group = null;
    public EndpointService endpoint = null;
    private EndpointAddress publicAddress = null;
    private EndpointAdvertisement epadv = null;
    private EndpointAddress mAddress = null;
    private String localSubnet = null;
    private String protocolName = "tcp";
    private boolean allowMulticast = true;
    private TcpConnectionManager connManager = null;
    public static int unicastPortNb = 9701;
    public static String multicastAddress = "224.0.1.85";
    public static int multicastPortNb = 1234;
    public static int multicastPacketSize = 16384;
    public static String serverName = null;
    public static String interfaceAddress = null;
    private IncomingUnicastThreads unicastThreads = null;
    public static final int DefaultNbOfUnicastThreads = 1;
    public static final int MaxNbOfUnicastThreads = 50;
    public static final int MaxNbOfUnicastKeepAliveThreads = 40;
    public static final int MaxKeepAliveDelay = 900000;
    private IncomingMulticastThreads multicastThreads = null;
    public static final int DefaultNbOfMulticastThreads = 0;
    public static final int MaxNbOfMulticastThreads = 20;
    public static final int MaxNbOfPendingSockets = 100;
    public static final int MaxCnxBacklog = 50;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tcp$TcpTransport;

    public int getPort() {
        return this.serverSocketPort;
    }

    public InetAddress getMcastAddr() {
        return this.propagateInetAddress;
    }

    public int getMcastPort() {
        return this.propagatePort;
    }

    public int getMcastSize() {
        return this.propagateSize;
    }

    public boolean allowOverLoad() {
        return false;
    }

    public int startApp(String[] stringArray) {
        return 0;
    }

    public void stopApp() {
        this.endpoint.removeEndpointProtocol(this);
        if (LOG.isEnabledFor(Priority.WARN)) {
            LOG.warn((Object)"There may be more things to be done here");
        }
    }

    public void init(PeerGroup peerGroup, ID iD, Advertisement advertisement) throws PeerGroupException {
        this.connManager = new TcpConnectionManager(this);
        try {
            Object object;
            Enumeration enumeration;
            ModuleImplAdvertisement moduleImplAdvertisement = (ModuleImplAdvertisement)advertisement;
            PeerAdvertisement peerAdvertisement = (PeerAdvertisement)peerGroup.getConfigAdvertisement();
            Element element = moduleImplAdvertisement.getParam();
            if (element != null && (enumeration = element.getChildren("Proto")).hasMoreElements()) {
                object = (TextElement)enumeration.nextElement();
                this.protocolName = object.getTextValue();
            }
            if ((enumeration = (element = peerAdvertisement.getServiceParam(iD)).getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
                element = (Element)enumeration.nextElement();
            } else {
                enumeration = element.getChildren(TCPAdv.getAdvertisementType());
                if (enumeration.hasMoreElements()) {
                    element = (Element)enumeration.nextElement();
                }
            }
            object = (TCPAdv)AdvertisementFactory.newAdvertisement((TextElement)element);
            unicastPortNb = new Integer(((TCPAdv)object).getPort());
            multicastAddress = ((TCPAdv)object).getMulticastAddr();
            multicastPortNb = new Integer(((TCPAdv)object).getMulticastPort());
            multicastPacketSize = new Integer(((TCPAdv)object).getMulticastSize());
            interfaceAddress = ((TCPAdv)object).getInterfaceAddress();
            serverName = ((TCPAdv)object).getServer();
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"Configuring TCP Transport");
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("UnicastPort:" + unicastPortNb));
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("MulticastAddr:" + multicastAddress));
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("MulticastPort:" + multicastPortNb));
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("MulticastPacketSize:" + multicastPacketSize));
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Interface address:" + interfaceAddress == null ? "(unspecified)" : interfaceAddress));
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Public address:" + serverName == null ? "(unspecified)" : serverName));
            }
            this.unicastThreads = new IncomingUnicastThreads(this, 1);
            this.multicastThreads = new IncomingMulticastThreads(this, 0);
            if (interfaceAddress == null) {
                interfaceAddress = InetAddress.getLocalHost().getHostAddress();
            }
            this.usingInterface = InetAddress.getByName(interfaceAddress);
            this.unicastSocket = new ServerSocket(unicastPortNb, 50, this.usingInterface);
            this.serverSocketPort = unicastPortNb;
            if (serverName == null) {
                serverName = interfaceAddress + ":" + unicastPortNb;
            }
            this.endpoint = peerGroup.getEndpointService();
            this.publicAddress = this.endpoint.newEndpointAddress(this.protocolName + "://" + serverName);
            this.mAddress = this.endpoint.newEndpointAddress(this.protocolName + "://" + multicastAddress);
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Binding to : " + this.usingInterface.getHostAddress()));
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Publishing Address : " + this.publicAddress.toString()));
            }
            this.unicastThread = new Thread((Runnable)this, "TcpTransport:unicast server thread");
            this.unicastThread.start();
            this.propagatePort = multicastPortNb;
            this.propagateSize = multicastPacketSize;
            this.propagateInetAddress = InetAddress.getByName(multicastAddress);
            Object var9_10 = null;
            this.multicastSocket = new MulticastSocket(this.propagatePort);
            this.multicastSocket.setInterface(this.usingInterface);
            this.multicastSocket.joinGroup(this.propagateInetAddress);
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Multicast : " + this.propagateInetAddress.getHostAddress() + ":" + this.propagatePort + " on interface " + this.multicastSocket.getInterface().getHostAddress()));
            }
            this.multicastThread = new Thread((Runnable)this, "TcpTransport:multicast server thread");
            this.multicastThread.start();
            this.endpoint.addEndpointProtocol(this);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Not initialized: " + exception.toString()));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Initialization exception", (Throwable)exception);
            }
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"FIXME: there may be threads that need killing.");
            }
            throw new PeerGroupException(exception.getMessage());
        }
    }

    public void run() {
        block4: {
            try {
                Thread thread = Thread.currentThread();
                if (thread.equals(this.unicastThread)) {
                    this.runUnicastServer();
                }
                if (thread.equals(this.multicastThread)) {
                    this.runMulticastServer();
                }
            }
            catch (Throwable throwable) {
                if (!LOG.isEnabledFor(Priority.FATAL)) break block4;
                LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), throwable);
            }
        }
    }

    public void runUnicastServer() {
        while (true) {
            Socket socket;
            try {
                socket = this.unicastSocket.accept();
                socket.setSoTimeout(900000);
                socket.setKeepAlive(true);
            }
            catch (IOException iOException) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                LOG.debug((Object)("ServerSocket.accept() on port " + this.serverSocketPort + " has failed with: " + iOException.toString()));
                continue;
            }
            catch (SecurityException securityException) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                LOG.debug((Object)("ServerSocket.accept() on port " + this.serverSocketPort + " has failed : " + securityException.toString()));
                continue;
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"runUnicastServer: received a connection");
            }
            this.processReceivingSocket(socket);
        }
    }

    public void runMulticastServer() {
        while (true) {
            byte[] byArray = new byte[this.propagateSize];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            try {
                this.multicastSocket.receive(datagramPacket);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break;
                LOG.debug((Object)("runMulticastServer " + exception));
                break;
            }
            this.processReceivingBuffer(byArray);
        }
    }

    public void processMulticast(byte[] byArray) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processMulticast starts");
        }
        if (byArray == null || byArray.length < Header.length) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   buffer null or truncated.");
            }
            return;
        }
        try {
            Header header = new Header();
            if (!header.initFromNetwork(byArray, 0)) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"header is corrupted. Msg ignored.");
                }
                throw new IOException("header is corrupted. Msg ignored.");
            }
            if (header.size > byArray.length) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"size from header is larger than buffer. Msg was truncated.");
                }
                throw new IOException("size from header is larger than buffer. Msg was truncated.");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, Header.length, header.size);
            Message message = this.endpoint.newMessage();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("application/x-jxta-msg")).readMessage(byteArrayInputStream, message);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  handing message to EndpointService");
            }
            if (!this.allowMulticast) {
                return;
            }
            EndpointAddress endpointAddress = message.getSourceAddress();
            if (endpointAddress != null) {
                this.checkConnection(endpointAddress);
            }
            this.endpoint.demux(message);
            Thread.yield();
        }
        catch (IOException iOException) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("   discard message - exception " + iOException));
            }
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public void runReceive(Socket var1_1, boolean var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public EndpointMessenger getMessenger(EndpointAddress endpointAddress) throws IOException {
        String string = endpointAddress.getProtocolAddress();
        if (string.indexOf("127.0.0.1") >= 0) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"getMessenger is trying to get 127.0.0.1 - discard");
            }
            return null;
        }
        return new TcpNonBlockingMessenger(endpointAddress, this, this.connManager);
    }

    public synchronized void propagate(Message message, String string, String string2, String string3) throws IOException {
        block16: {
            DatagramPacket datagramPacket;
            block15: {
                int n;
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"propagate");
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("prunepeer = " + string3));
                }
                this.mAddress.setServiceName(string);
                this.mAddress.setServiceParameter(string2);
                message.setDestinationAddress(this.mAddress);
                message.setSourceAddress(this.publicAddress);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("application/x-jxta-msg")).writeMessage(byteArrayOutputStream, message);
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                byte[] byArray2 = new byte[multicastPacketSize];
                int n2 = Header.length;
                while (-1 != (n = byteArrayInputStream.read(byArray2, n2, multicastPacketSize - n2))) {
                    if ((n2 += n) < multicastPacketSize) continue;
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Message discarded : larger than multicast packet size (" + multicastPacketSize + ")"));
                    }
                    throw new IOException("Message discarded : larger than multicast packet size (" + multicastPacketSize + ")");
                }
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (Header.length == n2) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Message discarded : could not read whole message from stream");
                    }
                    throw new IOException("Message discarded : could not read whole message from stream");
                }
                Header header = new Header();
                header.cmd = 1;
                header.srcAddr = this.usingInterface.getAddress();
                header.srcPort = this.serverSocketPort;
                header.size = n2 - Header.length;
                header.buildForNetwork(byArray2, 0);
                datagramPacket = new DatagramPacket(byArray2, n2, this.propagateInetAddress, this.propagatePort);
                if (this.multicastSocket == null) {
                    try {
                        this.multicastSocket = new MulticastSocket(this.propagatePort);
                        this.multicastSocket.setInterface(this.usingInterface);
                        this.multicastSocket.joinGroup(this.propagateInetAddress);
                    }
                    catch (Exception exception) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) break block15;
                        LOG.debug((Object)exception);
                    }
                }
            }
            try {
                this.multicastSocket.send(datagramPacket);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block16;
                LOG.debug((Object)exception);
            }
        }
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public EndpointAddress getPublicAddress() {
        return this.publicAddress;
    }

    public boolean isConnectionOriented() {
        return true;
    }

    public boolean allowRouting() {
        return true;
    }

    public boolean ping(EndpointAddress endpointAddress) {
        Object object;
        block11: {
            try {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("ping to " + endpointAddress.toString()));
                }
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block11;
                LOG.debug((Object)("ping cannot print address because: " + exception));
            }
        }
        try {
            object = endpointAddress.getProtocolAddress();
            if (((String)object).indexOf("127.0.0.1") >= 0) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   pinging localhost - discard");
                }
                return false;
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("  failed " + exception));
            }
            return false;
        }
        object = this.connManager.getTcpConnection(endpointAddress);
        if (object == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  no connection return false ");
            }
            return false;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("  return " + ((TcpConnection)object).isConnected()));
        }
        return ((TcpConnection)object).isConnected();
    }

    private void checkConnection(EndpointAddress endpointAddress) {
        TcpConnection tcpConnection = this.connManager.getTcpConnection(endpointAddress);
        if (tcpConnection == null) {
            return;
        }
        tcpConnection.notifyActivity();
    }

    void processReceivingSocket(Socket socket) {
        this.unicastThreads.newSocket(socket);
    }

    void processReceivingBuffer(byte[] byArray) {
        this.multicastThreads.newBuffer(byArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class IncomingMulticastThreads
    implements Runnable {
        protected Vector buffers = null;
        protected TcpTransport tp = null;
        private volatile int waitingThreads = 0;
        private int nbOfThreads = 0;

        public IncomingMulticastThreads(TcpTransport tcpTransport2, int n) {
            this.tp = tcpTransport2;
            this.buffers = new Vector();
            int n2 = 0;
            while (n2 < n) {
                ++this.nbOfThreads;
                Thread thread = new Thread((Runnable)this, "TCP Incoming Multicast:" + this.nbOfThreads);
                thread.start();
                ++n2;
            }
        }

        public void run() {
            try {
                byte[] byArray = null;
                while (true) {
                    if ((byArray = this.waitForBuffer()) == null) {
                        this.decThreads();
                        return;
                    }
                    this.tp.processMulticast(byArray);
                }
            }
            catch (Throwable throwable) {
                if (LOG.isEnabledFor(Priority.FATAL)) {
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), throwable);
                }
                return;
            }
        }

        private synchronized void decThreads() {
            --this.nbOfThreads;
        }

        protected synchronized byte[] waitForBuffer() {
            byte[] byArray = null;
            while (true) {
                if (this.buffers.size() > 0) {
                    block12: {
                        try {
                            byArray = (byte[])this.buffers.elementAt(0);
                        }
                        catch (Exception exception) {
                            if (!LOG.isEnabledFor(Priority.DEBUG)) break block12;
                            LOG.debug((Object)("waitForBuffer error: " + exception));
                        }
                    }
                    if (byArray != null) {
                        block13: {
                            try {
                                this.buffers.removeElementAt(0);
                            }
                            catch (Exception exception) {
                                if (!LOG.isEnabledFor(Priority.DEBUG)) break block13;
                                LOG.debug((Object)("waitForBuffer error: " + exception));
                            }
                        }
                        return byArray;
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"waitForBuffer cannot get incoming buffer");
                    }
                }
                if (this.mustDie()) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("waitForBuffer: killing thread " + Thread.currentThread().getName()));
                    }
                    return null;
                }
                try {
                    ++this.waitingThreads;
                    this.wait();
                    --this.waitingThreads;
                }
                catch (Exception exception) {
                }
            }
        }

        private synchronized boolean mustDie() {
            return this.nbOfThreads > 20 || this.waitingThreads > 0;
        }

        protected synchronized void newBuffer(byte[] byArray) {
            this.buffers.addElement(byArray);
            if (this.waitingThreads == 0) {
                ++this.nbOfThreads;
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"newBuffer: create a new Multicast receive Thread");
                }
                Thread thread = new Thread((Runnable)this, "TCP Incoming Multicast:" + this.nbOfThreads);
                thread.start();
            }
            try {
                this.notify();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class IncomingUnicastThreads
    implements Runnable {
        protected Vector sockets = null;
        protected TcpTransport tp = null;
        private volatile int waitingThreads = 0;
        private int nbOfThreads = 0;
        private int nbOfKeepAlive = 0;

        public IncomingUnicastThreads(TcpTransport tcpTransport2, int n) {
            this.tp = tcpTransport2;
            this.sockets = new Vector();
            int n2 = 0;
            while (n2 < n) {
                ++this.nbOfThreads;
                Thread thread = new Thread((Runnable)this, "TCP Incoming Unicast:" + this.nbOfThreads);
                thread.start();
                ++n2;
            }
        }

        public void run() {
            try {
                Socket socket = null;
                while (true) {
                    if ((socket = this.waitForSocket()) == null) {
                        this.decThreads();
                        return;
                    }
                    boolean bl = this.doesKeepAlive();
                    this.tp.runReceive(socket, bl);
                    if (!bl) continue;
                    this.stopKeepAlive();
                }
            }
            catch (Throwable throwable) {
                if (LOG.isEnabledFor(Priority.FATAL)) {
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), throwable);
                }
                return;
            }
        }

        private synchronized void decThreads() {
            --this.nbOfThreads;
        }

        protected synchronized Socket waitForSocket() {
            Socket socket = null;
            while (true) {
                if (this.sockets.size() > 0) {
                    block12: {
                        try {
                            socket = (Socket)this.sockets.elementAt(0);
                        }
                        catch (Exception exception) {
                            if (!LOG.isEnabledFor(Priority.DEBUG)) break block12;
                            LOG.debug((Object)("waitForSocket error: " + exception));
                        }
                    }
                    if (socket != null) {
                        block13: {
                            try {
                                this.sockets.removeElementAt(0);
                            }
                            catch (Exception exception) {
                                if (!LOG.isEnabledFor(Priority.DEBUG)) break block13;
                                LOG.debug((Object)("waitForSocket error: " + exception));
                            }
                        }
                        return socket;
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"waitForSocket cannot get incoming socket");
                    }
                }
                if (this.mustDie()) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"waitForSocket: killing thread");
                    }
                    return null;
                }
                try {
                    ++this.waitingThreads;
                    this.wait();
                    --this.waitingThreads;
                }
                catch (Exception exception) {
                }
            }
        }

        private synchronized boolean mustDie() {
            return this.nbOfThreads > 50 || this.waitingThreads > 1;
        }

        private synchronized boolean doesKeepAlive() {
            if (this.nbOfKeepAlive >= 40) {
                return false;
            }
            ++this.nbOfKeepAlive;
            return true;
        }

        private synchronized void stopKeepAlive() {
            --this.nbOfKeepAlive;
        }

        protected synchronized void newSocket(Socket socket) {
            if (this.sockets.size() > 100) {
                block8: {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) break block8;
                        LOG.debug((Object)("newSocket socket.close failed with " + exception));
                    }
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"newSocket: too many incoming request, dropped incoming message");
                }
                return;
            }
            this.sockets.addElement(socket);
            if (this.waitingThreads == 0) {
                ++this.nbOfThreads;
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"newSocket: create a new Thread");
                }
                Thread thread = new Thread((Runnable)this, "TCP Incoming Unicast:" + this.nbOfThreads);
                thread.start();
            }
            try {
                this.notify();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

