/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

public class Header {
    public byte cmd;
    public byte[] srcAddr = new byte[4];
    public int srcPort;
    public int size;
    public int option;
    public int packetId;
    public static int length = 20;
    public static final int PROPAGATE = 1;
    public static final int UNICAST = 2;
    public static final int ACK = 3;
    public static final int NACK = 4;
    public static final int HANDCHECK = 1;
    public static final int NONBLOCKING = 2;

    private static void htonl(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)((n & 0xFF000000) >> 24);
        byArray[n2 + 1] = (byte)((n & 0xFF0000) >> 16);
        byArray[n2 + 2] = (byte)((n & 0xFF00) >> 8);
        byArray[n2 + 3] = (byte)(n & 0xFF);
    }

    private static void htons(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)((n & 0xFF00) >> 8);
        byArray[n2 + 1] = (byte)(n & 0xFF);
    }

    private static int ntohl(byte[] byArray, int n) {
        return byArray[n] << 24 & 0xFF000000 | byArray[n + 1] << 16 & 0xFF0000 | byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] & 0xFF;
    }

    private static int ntohs(byte[] byArray, int n) {
        return byArray[n] << 24 & 0xFF000000 | byArray[n + 1] << 16 & 0xFF0000 | byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] & 0xFF;
    }

    public boolean initFromNetwork(byte[] byArray, int n) {
        this.cmd = byArray[n];
        if (this.cmd != 1 && this.cmd != 2 && this.cmd != 3 && this.cmd != 4) {
            return false;
        }
        this.srcAddr[0] = byArray[n + 1];
        this.srcAddr[1] = byArray[n + 2];
        this.srcAddr[2] = byArray[n + 3];
        this.srcAddr[3] = byArray[n + 4];
        this.srcPort = Header.ntohs(byArray, n + 5);
        this.size = Header.ntohl(byArray, n + 7);
        this.option = byArray[n + 11];
        this.packetId = Header.ntohl(byArray, n + 12);
        return true;
    }

    public void buildForNetwork(byte[] byArray, int n) {
        int n2 = n;
        byArray[n2++] = this.cmd;
        byArray[n2++] = this.srcAddr[0];
        byArray[n2++] = this.srcAddr[1];
        byArray[n2++] = this.srcAddr[2];
        byArray[n2++] = this.srcAddr[3];
        Header.htons(this.srcPort, byArray, n2);
        Header.htonl(this.size, byArray, n2 += 2);
        n2 += 4;
        byArray[n2++] = (byte)this.option;
        Header.htonl(this.packetId, byArray, n2);
        n2 += 4;
    }
}

