/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.beep;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import net.jxta.document.Advertisement;
import net.jxta.document.StructuredDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointProtocol;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.Address;
import net.jxta.impl.endpoint.beep.BeepNonBlockingMessenger;
import net.jxta.impl.endpoint.beep.BeepSession;
import net.jxta.impl.endpoint.beep.JxtaBeepProfile;
import net.jxta.impl.protocol.BeepAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.beepcore.beep.core.BEEPException;
import org.beepcore.beep.core.ProfileRegistry;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.core.SessionTuningProperties;
import org.beepcore.beep.profile.ProfileConfiguration;
import org.beepcore.beep.transport.tcp.AutomatedTCPSessionCreator;
import org.beepcore.beep.transport.tcp.TCPSession;
import org.beepcore.beep.util.ConsoleLog;
import org.beepcore.beep.util.Log;
import org.beepcore.beep.util.LogService;

public class BeepTransport
implements EndpointProtocol {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$beep$BeepTransport == null ? (class$net$jxta$impl$endpoint$beep$BeepTransport = BeepTransport.class$("net.jxta.impl.endpoint.beep.BeepTransport")) : class$net$jxta$impl$endpoint$beep$BeepTransport).getName());
    private static final long PINGDELAY = 2000L;
    private EndpointService endpoint;
    private Advertisement implAdv;
    private BeepAdv beepAdv;
    private String localAddress;
    private InetAddress usingInterface;
    private int useTcpPort;
    private String publicAddress;
    private Address ourAddress;
    ProfileRegistry reg;
    HashMap activeSessions = new HashMap();
    static /* synthetic */ Class class$net$jxta$impl$endpoint$beep$BeepTransport;

    public boolean allowOverLoad() {
        return false;
    }

    public int startApp(String[] stringArray) {
        return 1;
    }

    public void stopApp() {
    }

    public void init(PeerGroup peerGroup, ID iD, Advertisement advertisement) throws PeerGroupException {
        Object object;
        ModuleImplAdvertisement moduleImplAdvertisement = (ModuleImplAdvertisement)advertisement;
        PeerAdvertisement peerAdvertisement = (PeerAdvertisement)peerGroup.getConfigAdvertisement();
        StructuredDocument structuredDocument = peerAdvertisement.getServiceParam(iD);
        Enumeration enumeration = structuredDocument.getChildren(TransportAdvertisement.getAdvertisementType());
        if (enumeration.hasMoreElements()) {
            this.beepAdv = (BeepAdv)enumeration.nextElement();
        } else {
            enumeration = structuredDocument.getChildren(BeepAdv.getAdvertisementType());
            if (enumeration.hasMoreElements()) {
                this.beepAdv = (BeepAdv)enumeration.nextElement();
            }
        }
        this.useTcpPort = this.beepAdv.getPort();
        this.localAddress = this.beepAdv.getLocalAddress();
        this.publicAddress = this.beepAdv.getPublicAddress();
        try {
            this.usingInterface = this.localAddress == null || this.localAddress.equalsIgnoreCase("TBD") ? InetAddress.getLocalHost() : InetAddress.getByName(this.localAddress);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("Could not find IP address for local Host!");
        }
        if (this.publicAddress == null || this.publicAddress.equalsIgnoreCase("TBD")) {
            this.publicAddress = this.usingInterface.getHostAddress() + ":" + this.useTcpPort;
        }
        this.ourAddress = new Address();
        this.ourAddress.setProtocolName(this.getProtocolName());
        this.ourAddress.setProtocolAddress(this.publicAddress);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"Configured  Beep Transport");
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("  Using Intf:" + this.usingInterface.getHostAddress()));
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("  Using Port:" + this.useTcpPort));
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("  Local Addr:" + this.ourAddress));
        }
        if (LOG.getChainedPriority().equals(Priority.DEBUG)) {
            object = new ConsoleLog();
            object.setSeverity(8);
            Log.setLogService((LogService)object);
        }
        this.endpoint = peerGroup.getEndpointService();
        object = "net.jxta.impl.endpoint.beep.JxtaBeepProfile";
        this.reg = new ProfileRegistry();
        SessionTuningProperties sessionTuningProperties = new SessionTuningProperties();
        ProfileConfiguration profileConfiguration = new ProfileConfiguration();
        try {
            JxtaBeepProfile jxtaBeepProfile;
            try {
                jxtaBeepProfile = (JxtaBeepProfile)Class.forName((String)object).newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Exception("Class " + (String)object + " cannot be constructed.");
            }
            catch (InstantiationException instantiationException) {
                throw new Exception("Class " + (String)object + " returned an error");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Exception("Class " + (String)object + " not found");
            }
            catch (ClassCastException classCastException) {
                throw new Exception("class " + (String)object + " does not " + "implement the org.beepcore.beep.profile.Profile interface");
            }
            jxtaBeepProfile.SetEndpoint(this.endpoint);
            this.reg.addStartChannelListener("http://xml.resource.org/profiles/JXTA/Beep", jxtaBeepProfile.init("http://xml.resource.org/profiles/JXTA/Beep", profileConfiguration), null);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"BeepTransport.init failure", (Throwable)exception);
            }
            return;
        }
        new IncomingBeepSeesionDaemon(this).start();
        new BeepSeesionIdleOutDaemon(this).start();
    }

    public EndpointMessenger getMessenger(EndpointAddress endpointAddress) throws IOException {
        if (!endpointAddress.getProtocolName().equals(this.getProtocolName())) {
            throw new IllegalArgumentException("Not a BEEP EndpointService address!");
        }
        String string = endpointAddress.getProtocolAddress();
        BeepSession beepSession = null;
        HashMap hashMap = this.activeSessions;
        synchronized (hashMap) {
            if (this.activeSessions.containsKey(string)) {
                beepSession = (BeepSession)this.activeSessions.get(string);
                beepSession.updateLastUsed();
            } else {
                beepSession = new BeepSession(this, endpointAddress);
                this.activeSessions.put(string, beepSession);
            }
        }
        return new BeepNonBlockingMessenger(beepSession);
    }

    public synchronized void propagate(Message message, String string, String string2, String string3) throws IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"propagate not supported");
        }
    }

    public String getProtocolName() {
        return BeepTransport.getSupportedProtocolName();
    }

    public static String getSupportedProtocolName() {
        return "BEEP";
    }

    public void close() {
        HashMap hashMap = this.activeSessions;
        synchronized (hashMap) {
            Iterator iterator = this.activeSessions.values().iterator();
            while (iterator.hasNext()) {
                BeepSession beepSession = (BeepSession)iterator.next();
                beepSession.close();
                beepSession = null;
                iterator.remove();
            }
        }
        this.activeSessions = null;
    }

    public EndpointAddress getPublicAddress() {
        return this.ourAddress;
    }

    public boolean allowRouting() {
        return true;
    }

    public boolean isConnectionOriented() {
        return true;
    }

    public boolean ping(EndpointAddress endpointAddress) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("ping to " + endpointAddress.toString()));
        }
        boolean bl = true;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("ping (always) returns " + bl));
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BeepSeesionIdleOutDaemon
    extends Thread {
        private static final int POLLINGINTERVAL = 10;
        private static final int IDLEINTERVAL = 120;
        private BeepTransport ourMaster;

        BeepSeesionIdleOutDaemon(BeepTransport beepTransport2) {
            super("BeepTransport Session Idle Closer Daemon : " + beepTransport2.toString());
            this.ourMaster = beepTransport2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"BeepSeesionIdleOutDaemon.run");
            }
            try {
                block6: while (true) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread();
                        Thread.interrupted();
                    }
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"BeepSeesionIdleOutDaemon polling for idle session");
                    }
                    HashMap hashMap = this.ourMaster.activeSessions;
                    synchronized (hashMap) {
                        Iterator iterator = this.ourMaster.activeSessions.values().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                continue block6;
                            }
                            BeepSession beepSession = (BeepSession)iterator.next();
                            if (beepSession.getLastUsed() + 120000L > System.currentTimeMillis()) continue;
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("Closing session with " + beepSession.getDestEndpoint()));
                            }
                            iterator.remove();
                            beepSession.close();
                            beepSession = null;
                        }
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                if (!LOG.isEnabledFor(Priority.FATAL)) return;
                LOG.fatal((Object)("Uncaught Throwable, Listener " + Thread.currentThread().getName() + " exiting"), throwable);
                return;
            }
        }
    }

    private class IncomingBeepSeesionDaemon
    extends Thread {
        private BeepTransport ourMaster;

        IncomingBeepSeesionDaemon(BeepTransport beepTransport2) {
            super("BeepTransport Incoming Session Daemon : " + beepTransport2.toString());
            this.ourMaster = beepTransport2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("IncomingBeepSeesionDaemon.run starting listener - " + this.ourMaster.usingInterface.getHostAddress() + ":" + this.ourMaster.useTcpPort));
            }
            while (true) {
                try {
                    while (true) {
                        TCPSession tCPSession = AutomatedTCPSessionCreator.listen((InetAddress)this.ourMaster.usingInterface, (int)this.ourMaster.useTcpPort, (ProfileRegistry)this.ourMaster.reg);
                        HashMap hashMap = this.ourMaster.activeSessions;
                        synchronized (hashMap) {
                            BeepSession beepSession = new BeepSession(this.ourMaster, (Session)tCPSession);
                            this.ourMaster.activeSessions.put(beepSession.getDestEndpoint(), beepSession);
                        }
                    }
                }
                catch (BEEPException bEEPException) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)("Listener exception : " + bEEPException.getMessage()), (Throwable)bEEPException);
                    continue;
                }
                catch (Throwable throwable) {
                    if (!LOG.isEnabledFor(Priority.FATAL)) return;
                    LOG.fatal((Object)("Uncaught Throwable, Listener " + Thread.currentThread().getName() + " exiting"), throwable);
                    return;
                }
                break;
            }
        }
    }
}

